/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io.gcf.datagram;

import com.sun.j2se.io.ConnectionBase;
import com.sun.j2se.io.gcf.datagram.DatagramObject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

public class Protocol
extends ConnectionBase
implements DatagramConnection {
    DatagramSocket endpoint;
    private String host = null;
    private int port;

    protected static String getAddress(String string) throws IOException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException("No ':' in protocol name " + string);
        }
        if (n == 0) {
            return null;
        }
        return string.substring(0, n);
    }

    protected static int getPort(String string) throws IOException, NumberFormatException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException("No ':' in protocol name " + string);
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    public void open(String string, int n, boolean bl) throws IOException {
        if (string.charAt(0) != '/' || string.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + string);
        }
        string = string.substring(2);
        this.host = Protocol.getAddress(string);
        this.port = Protocol.getPort(string);
        if (this.port <= 0) {
            throw new IllegalArgumentException("Bad port number \"//\" " + string);
        }
        this.endpoint = this.host == null ? new DatagramSocket(this.port) : new DatagramSocket();
        try {
            byte[] byArray = new byte[256];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, 256);
            if (this.host != null) {
                datagramPacket.setAddress(InetAddress.getByName(this.host));
            } else {
                datagramPacket.setAddress(InetAddress.getByName("localhost"));
            }
            datagramPacket.setPort(this.port);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid datagram address " + this.host + ":" + this.port);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Unknown host " + this.host + ":" + this.port);
        }
        catch (SecurityException securityException) {
        }
    }

    public String getAddress() {
        InetAddress inetAddress = this.endpoint.getLocalAddress();
        return "datagram://" + inetAddress.getHostName() + ":" + inetAddress.getHostAddress();
    }

    public int getMaximumLength() throws IOException {
        try {
            return this.endpoint.getReceiveBufferSize();
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
    }

    public int getNominalLength() throws IOException {
        return this.getMaximumLength();
    }

    public void setTimeout(int n) {
    }

    public void send(Datagram datagram) throws IOException {
        DatagramObject datagramObject = (DatagramObject)datagram;
        this.endpoint.send(datagramObject.dgram);
    }

    public void receive(Datagram datagram) throws IOException {
        DatagramObject datagramObject = (DatagramObject)datagram;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.host != null) {
                securityManager.checkAccept(this.host, datagramObject.dgram.getPort());
            } else {
                securityManager.checkAccept("localhost", datagramObject.dgram.getPort());
            }
        }
        this.endpoint.receive(datagramObject.dgram);
        int n = datagramObject.dgram.getPort();
        if (this.host != null) {
            try {
                datagramObject.setAddress("datagram://" + this.host + ":" + n);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException in datagram::receive");
            }
        }
        try {
            datagramObject.setAddress("datagram://:" + n);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException in datagram::receive");
        }
        datagramObject.pointer = 0;
    }

    public void close() throws IOException {
        this.endpoint.close();
    }

    public Datagram newDatagram(int n) throws IllegalArgumentException, IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        return this.newDatagram(new byte[n], n);
    }

    public Datagram newDatagram(int n, String string) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        return this.newDatagram(new byte[n], n, string);
    }

    public Datagram newDatagram(byte[] byArray, int n) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        if (n > this.getMaximumLength()) {
            throw new IllegalArgumentException("Size: " + n + " is more than max size: " + this.getMaximumLength());
        }
        if (byArray == null) {
            throw new IllegalArgumentException("buf is null");
        }
        DatagramObject datagramObject = new DatagramObject(new DatagramPacket(byArray, n));
        if (this.host != null) {
            try {
                datagramObject.setAddress("datagram://" + this.host + ":" + this.port);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException in datagram::newDatagram");
            }
        }
        try {
            datagramObject.setAddress("datagram://:" + this.port);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException in datagram::newDatagram");
        }
        return datagramObject;
    }

    public Datagram newDatagram(byte[] byArray, int n, String string) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Size is negative: " + n);
        }
        if (n > this.getMaximumLength()) {
            throw new IllegalArgumentException("Size: " + n + " is more than max size: " + this.getMaximumLength());
        }
        if (string == null) {
            throw new IllegalArgumentException("addr is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("buf is null");
        }
        DatagramObject datagramObject = (DatagramObject)this.newDatagram(byArray, n);
        datagramObject.setAddress(string);
        return datagramObject;
    }
}

