/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2se.io;

import java.util.Hashtable;

public class DateParser {
    protected int year;
    protected int month;
    protected int day;
    protected int hour;
    protected int minute;
    protected int second;
    protected int milli;
    protected static int tz_offset;
    private static Hashtable timezones;
    private int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private String[] month_shorts = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private String[] weekday_shorts = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static long julianDayOffset;
    private static int millisPerHour;
    private static int millisPerDay;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final String[] wtb;
    private static final int[] ttb;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;

    DateParser(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 1583 || n2 < 0 || n2 > 11 || n3 < 0 || n3 > this.days_in_month[n2] && (n2 != 1 || n3 != 29 || n % 4 != 0) || n4 < 0 || n4 > 23 || n5 < 0 || n5 > 59 || n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException();
        }
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.milli = 0;
    }

    DateParser(String string) {
        this.internalParse(string);
    }

    static void setTimeZone(String string) {
        if (timezones.get(string) == null) {
            return;
        }
        tz_offset = (Integer)timezones.get(string);
    }

    public static long parse(String string) {
        return new DateParser(string).getTime();
    }

    int getYear() {
        return this.year;
    }

    int getMonth() {
        return this.month;
    }

    int getDay() {
        return this.day;
    }

    int getHour() {
        return this.hour;
    }

    int getMinute() {
        return this.minute;
    }

    int getSecond() {
        return this.second;
    }

    long getTime() {
        long l = this.computeJulianDay(this.year, this.month, this.day);
        long l2 = this.julianDayToMillis(l);
        int n = 0;
        n += this.hour;
        n *= 60;
        n += this.minute;
        n *= 60;
        n += this.second;
        n *= 1000;
        return l2 + (long)(n += this.milli) - (long)tz_offset;
    }

    private final long computeJulianDay(int n, int n2, int n3) {
        long l = 0L;
        boolean bl = n % 4 == 0;
        int n4 = n - 1;
        long l2 = 365L * (long)n4 + DateParser.floorDivide(n4, 4L) + 1721423L;
        bl = bl && (n % 100 != 0 || n % 400 == 0);
        l2 += DateParser.floorDivide(n4, 400L) - DateParser.floorDivide(n4, 100L) + 2L;
        l2 += bl ? (long)LEAP_NUM_DAYS[n2] : (long)NUM_DAYS[n2];
        return l2 += (long)n3;
    }

    private static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    private long julianDayToMillis(long l) {
        return (l - julianDayOffset) * (long)millisPerDay;
    }

    /*
     * Unable to fully structure code
     */
    private void internalParse(String var1_1) {
        block38: {
            var2_2 = -1;
            var3_3 = -1;
            var4_4 = -1;
            var5_5 = -1;
            var6_6 = -1;
            var7_7 = -1;
            var8_8 = -1;
            var9_9 = -1;
            var10_10 = 0;
            var11_11 = -1;
            var12_12 = -1;
            var13_13 = -1;
            var14_14 = 0;
            if (var1_1 == null) break block38;
            var15_15 = var1_1.length();
            block0: while (var10_10 < var15_15) {
                block39: {
                    var9_9 = var1_1.charAt(var10_10);
                    ++var10_10;
                    if (var9_9 <= 32 || var9_9 == 44) continue;
                    if (var9_9 == 40) {
                        var16_16 = 1;
                        while (var10_10 < var15_15) {
                            var9_9 = var1_1.charAt(var10_10);
                            ++var10_10;
                            if (var9_9 == 40) {
                                ++var16_16;
                                continue;
                            }
                            if (var9_9 == 41 && --var16_16 <= 0) continue block0;
                        }
                        continue;
                    }
                    if (48 > var9_9 || var9_9 > 57) break block39;
                    var11_11 = var9_9 - 48;
                    if (true) ** GOTO lbl37
                    do {
                        var11_11 = var11_11 * 10 + var9_9 - 48;
                        ++var10_10;
lbl37:
                        // 2 sources

                        if (var10_10 >= var15_15) break;
                        v0 = var1_1.charAt(var10_10);
                        var9_9 = v0;
                    } while ('0' <= v0 && var9_9 <= 57);
                    if (var14_14 == 43 || var14_14 == 45 && var2_2 >= 0) {
                        var11_11 = var11_11 < 24 ? (var11_11 *= 60) : var11_11 % 100 + var11_11 / 100 * 60;
                        if (var14_14 == 43) {
                            var11_11 = -var11_11;
                        }
                        if (var13_13 != 0 && var13_13 != -1) break block38;
                        var13_13 = var11_11;
                    } else if (var11_11 >= 70) {
                        if (var2_2 >= 0 || var9_9 > 32 && var9_9 != 44 && var9_9 != 47 && var10_10 < var15_15) break block38;
                        var2_2 = var11_11 < 100 ? var11_11 + 1900 : var11_11;
                    } else if (var9_9 == 58) {
                        if (var5_5 < 0) {
                            var5_5 = (byte)var11_11;
                        } else {
                            if (var6_6 >= 0) break block38;
                            var6_6 = (byte)var11_11;
                        }
                    } else if (var9_9 == 47) {
                        if (var3_3 < 0) {
                            var3_3 = (byte)(var11_11 - 1);
                        } else {
                            if (var4_4 >= 0) break block38;
                            var4_4 = (byte)var11_11;
                        }
                    } else {
                        if (var10_10 < var15_15 && var9_9 != 44 && var9_9 > 32 && var9_9 != 45) break block38;
                        if (var5_5 >= 0 && var6_6 < 0) {
                            var6_6 = (byte)var11_11;
                        } else if (var6_6 >= 0 && var7_7 < 0) {
                            var7_7 = (byte)var11_11;
                        } else {
                            if (var4_4 >= 0) break block38;
                            var4_4 = (byte)var11_11;
                        }
                    }
                    var14_14 = 0;
                    continue;
                }
                if (var9_9 == 47 || var9_9 == 58 || var9_9 == 43 || var9_9 == 45) {
                    var14_14 = var9_9;
                    continue;
                }
                var16_16 = var10_10 - 1;
                while (var10_10 < var15_15) {
                    var9_9 = var1_1.charAt(var10_10);
                    if (!(65 <= var9_9 && var9_9 <= 90 || 97 <= var9_9 && var9_9 <= 122)) break;
                    ++var10_10;
                }
                if (var10_10 <= var16_16 + 1) break block38;
                var17_17 = DateParser.wtb.length;
                while (--var17_17 >= 0) {
                    if (!DateParser.wtb[var17_17].regionMatches(true, 0, var1_1, var16_16, var10_10 - var16_16)) continue;
                    var18_18 = DateParser.ttb[var17_17];
                    if (var18_18 == 0) break;
                    if (var18_18 == 1) {
                        if (var5_5 <= 12 && var5_5 >= 1) {
                            if (var5_5 >= 12) break;
                            var5_5 += 12;
                            break;
                        }
                        break block38;
                    }
                    if (var18_18 == 14) {
                        if (var5_5 <= 12 && var5_5 >= 1) {
                            if (var5_5 != 12) break;
                            var5_5 = 0;
                            break;
                        }
                        break block38;
                    }
                    if (var18_18 <= 13) {
                        if (var3_3 < 0) {
                            var3_3 = (byte)(var18_18 - 2);
                            break;
                        }
                        break block38;
                    }
                    var13_13 = var18_18 - 10000;
                    break;
                }
                if (var17_17 >= 0) {
                    var14_14 = 0;
                    continue;
                }
                break block38;
            }
            if (var2_2 >= 1583 && var3_3 >= 0 && var4_4 >= 0) {
                if (var7_7 < 0) {
                    var7_7 = 0;
                }
                if (var6_6 < 0) {
                    var6_6 = 0;
                }
                if (var5_5 < 0) {
                    var5_5 = 0;
                }
                this.year = var2_2;
                this.month = var3_3;
                this.day = var4_4;
                this.hour = var5_5;
                this.minute = var6_6;
                this.second = var7_7;
                this.milli = 0;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        julianDayOffset = 2440588L;
        millisPerHour = 3600000;
        millisPerDay = 24 * millisPerHour;
        wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
        ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
        NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        timezones = new Hashtable();
        timezones.put("GMT", new Integer(0 * millisPerHour));
        timezones.put("UT", new Integer(0 * millisPerHour));
        timezones.put("UTC", new Integer(0 * millisPerHour));
        timezones.put("PST", new Integer(-8 * millisPerHour));
        timezones.put("PDT", new Integer(-7 * millisPerHour));
        timezones.put("JST", new Integer(9 * millisPerHour));
        tz_offset = (Integer)timezones.get("GMT");
    }
}

