/*
 * Decompiled with CFR 0.152.
 */
package example.pim;

import example.pim.ItemSelectionScreen;
import example.pim.PIMDemo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Contact;
import javax.microedition.pim.Event;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.ToDo;

public class ItemDisplayScreen
extends Form
implements CommandListener,
ItemCommandListener {
    private final Command editArrayCommand = new Command("Edit", 4, 1);
    private final Command editBooleanCommand = new Command("Edit", 4, 1);
    private final Command commitCommand = new Command("Commit", 4, 2);
    private final Command backCommand = new Command("Back", 2, 1);
    private final Command showVCard = new Command("Show vCard", 1, 5);
    private final Command showVCalendar = new Command("Show vCalendar", 1, 5);
    private final Command addField = new Command("Add Field", 1, 2);
    private final Command removeField = new Command("Remove Field", 1, 3);
    private final PIMDemo midlet;
    private final ItemSelectionScreen caller;
    private final PIMItem item;
    private final Hashtable fieldTable = new Hashtable();

    public ItemDisplayScreen(PIMDemo pIMDemo, ItemSelectionScreen itemSelectionScreen, PIMItem pIMItem) throws PIMException {
        super("PIM Item");
        this.midlet = pIMDemo;
        this.caller = itemSelectionScreen;
        this.item = pIMItem;
        this.populateForm();
        this.addCommand(this.backCommand);
        this.addCommand(this.commitCommand);
        this.setCommandListener(this);
    }

    private boolean isClassField(int n) {
        return this.item instanceof Contact && n == 102 || this.item instanceof Event && n == 101 || this.item instanceof ToDo && n == 100;
    }

    private void populateForm() throws PIMException {
        this.deleteAll();
        this.fieldTable.clear();
        int[] nArray = this.item.getPIMList().getSupportedFields();
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this.isClassField(n)) continue;
            if (this.item.countValues(n) == 0) {
                bl = false;
                continue;
            }
            int n2 = this.item.getPIMList().getFieldDataType(n);
            String string = this.item.getPIMList().getFieldLabel(n);
            StringItem stringItem = null;
            switch (n2) {
                case 4: {
                    String string2 = this.item.getString(n, 0);
                    if (string2 == null) {
                        string2 = "";
                    }
                    int n3 = 0;
                    if (this.item instanceof Contact) {
                        switch (n) {
                            case 103: {
                                n3 = 1;
                                break;
                            }
                            case 115: {
                                n3 = 3;
                                break;
                            }
                            case 118: {
                                n3 = 4;
                            }
                        }
                    }
                    try {
                        stringItem = new TextField(string, string2, 128, n3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        stringItem = new TextField(string, string2, 128, 0);
                    }
                    break;
                }
                case 1: {
                    stringItem = new StringItem(string, this.item.getBoolean(n, 0) ? "yes" : "no");
                    stringItem.setDefaultCommand(this.editBooleanCommand);
                    break;
                }
                case 5: {
                    String[] stringArray = this.item.getStringArray(n, 0);
                    if (stringArray == null) break;
                    stringItem = new StringItem(string, this.joinStringArray(stringArray));
                    stringItem.setDefaultCommand(this.editArrayCommand);
                    break;
                }
                case 2: {
                    long l = this.item.getDate(n, 0);
                    int n4 = 3;
                    if (this.item instanceof Contact) {
                        switch (n) {
                            case 101: {
                                n4 = 1;
                            }
                        }
                    }
                    stringItem = new DateField(string, n4);
                    ((DateField)stringItem).setDate(new Date(l));
                    break;
                }
                case 3: {
                    stringItem = new TextField(string, String.valueOf(this.item.getInt(n, 0)), 64, 5);
                    break;
                }
                case 0: {
                    byte[] byArray = this.item.getBinary(n, 0);
                    if (byArray == null) break;
                    stringItem = new StringItem(string, byArray.length + " bytes");
                }
            }
            if (stringItem == null) continue;
            this.append((Item)stringItem);
            this.fieldTable.put(stringItem, new Integer(n));
            stringItem.addCommand(this.removeField);
            stringItem.setItemCommandListener((ItemCommandListener)this);
        }
        if (this.item instanceof Contact) {
            this.addCommand(this.showVCard);
        } else {
            this.addCommand(this.showVCalendar);
        }
        if (!bl) {
            this.addCommand(this.addField);
        } else {
            this.removeCommand(this.addField);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            try {
                this.getUserData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.caller.populateList();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.caller);
        } else if (command == this.commitCommand) {
            this.commit();
        } else if (command == this.showVCard) {
            this.showItem("VCARD/2.1");
        } else if (command == this.showVCalendar) {
            this.showItem("VCALENDAR/1.0");
        } else if (command == this.addField) {
            this.addField();
        }
    }

    public void commandAction(Command command, Item item) {
        int n = (Integer)this.fieldTable.get(item);
        if (command == this.editBooleanCommand) {
            boolean bl = !this.item.getBoolean(n, 0);
            this.item.setBoolean(n, 0, 0, bl);
            ((StringItem)item).setText(bl ? "yes" : "no");
        } else if (command == this.editArrayCommand) {
            String string;
            String string2 = this.item.getPIMList().getFieldLabel(n);
            String[] stringArray = this.item.getStringArray(n, 0);
            TextField[] textFieldArray = new TextField[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.item.getPIMList().getArrayElementLabel(n, i);
                textFieldArray[i] = new TextField(string, stringArray[i], 128, 0);
            }
            Form form = new Form(string2, (Item[])textFieldArray);
            string = new Command("OK", 4, 1);
            Command command2 = new Command("Cancel", 3, 1);
            form.addCommand((Command)string);
            form.addCommand(command2);
            form.setCommandListener(new CommandListener((Command)string, textFieldArray, stringArray, n, item){
                private final /* synthetic */ Command val$okCommand;
                private final /* synthetic */ TextField[] val$textFields;
                private final /* synthetic */ String[] val$a;
                private final /* synthetic */ int val$field;
                private final /* synthetic */ Item val$formItem;
                {
                    this.val$okCommand = command;
                    this.val$textFields = textFieldArray;
                    this.val$a = stringArray;
                    this.val$field = n;
                    this.val$formItem = item;
                }

                public void commandAction(Command command, Displayable displayable) {
                    if (command == this.val$okCommand) {
                        for (int i = 0; i < this.val$textFields.length; ++i) {
                            this.val$a[i] = this.val$textFields[i].getString();
                        }
                        ItemDisplayScreen.this.item.setStringArray(this.val$field, 0, ItemDisplayScreen.this.item.getAttributes(this.val$field, 0), this.val$a);
                        ((StringItem)this.val$formItem).setText(ItemDisplayScreen.this.joinStringArray(this.val$a));
                    }
                    Display.getDisplay((MIDlet)ItemDisplayScreen.this.midlet).setCurrent((Displayable)ItemDisplayScreen.this);
                }
            });
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)form);
        } else if (command == this.removeField) {
            this.item.removeValue(n, 0);
            try {
                this.populateForm();
            }
            catch (PIMException pIMException) {
                // empty catch block
            }
        }
    }

    private void commit() {
        try {
            this.getUserData();
            this.item.commit();
            this.populateForm();
        }
        catch (Exception exception) {
            this.midlet.reportException(exception, (Displayable)this);
        }
    }

    private void getUserData() throws NumberFormatException {
        int n = this.size();
        block9: for (int i = 0; i < n; ++i) {
            Item item = this.get(i);
            int n2 = (Integer)this.fieldTable.get(item);
            if (this.item.countValues(n2) < 1) continue;
            int n3 = this.item.getPIMList().getFieldDataType(n2);
            switch (n3) {
                case 4: {
                    String string = ((TextField)item).getString();
                    try {
                        this.item.setString(n2, 0, 0, string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue block9;
                }
                case 2: {
                    long l = ((DateField)item).getDate().getTime();
                    try {
                        this.item.setDate(n2, 0, 0, l);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue block9;
                }
                case 3: {
                    String string = ((TextField)item).getString();
                    int n4 = Integer.parseInt(string);
                    this.item.setInt(n2, 0, 0, n4);
                }
            }
        }
    }

    private void addField() {
        int[] nArray = this.item.getPIMList().getSupportedFields();
        final Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.item.countValues(nArray[i]) != 0 || this.isClassField(nArray[i])) continue;
            vector.addElement(new Integer(nArray[i]));
        }
        final List list = new List("Select a field to add", 3);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            list.append(this.item.getPIMList().getFieldLabel(n), null);
        }
        list.addCommand(new Command("Cancel", 3, 1));
        list.setSelectCommand(new Command("Add", 4, 1));
        list.setCommandListener(new CommandListener(){

            public void commandAction(Command command, Displayable displayable) {
                if (command.getCommandType() == 4) {
                    try {
                        int n = list.getSelectedIndex();
                        int n2 = (Integer)vector.elementAt(n);
                        ItemDisplayScreen.this.addField(n2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ItemDisplayScreen.this.midlet.reportException(illegalArgumentException, (Displayable)ItemDisplayScreen.this);
                    }
                    try {
                        ItemDisplayScreen.this.getUserData();
                        ItemDisplayScreen.this.populateForm();
                    }
                    catch (Exception exception) {
                        ItemDisplayScreen.this.midlet.reportException(exception, (Displayable)ItemDisplayScreen.this);
                    }
                }
                Display.getDisplay((MIDlet)ItemDisplayScreen.this.midlet).setCurrent((Displayable)ItemDisplayScreen.this);
            }
        });
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)list);
    }

    private void addField(int n) {
        switch (this.item.getPIMList().getFieldDataType(n)) {
            case 4: {
                this.item.addString(n, 0, "");
                break;
            }
            case 5: {
                int[] nArray = this.item.getPIMList().getSupportedArrayElements(n);
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    n2 = Math.max(n2, nArray[i] + 1);
                }
                String[] stringArray = new String[n2];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "";
                }
                this.item.addStringArray(n, 0, stringArray);
                break;
            }
            case 0: {
                this.item.addBinary(n, 0, new byte[16], 0, 16);
                break;
            }
            case 1: {
                this.item.addBoolean(n, 0, false);
                break;
            }
            case 2: {
                this.item.addDate(n, 0, new Date().getTime());
                break;
            }
            case 3: {
                this.item.addInt(n, 0, 0);
            }
        }
    }

    private void showItem(String string) {
        try {
            this.getUserData();
            this.populateForm();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PIM.getInstance().toSerialFormat(this.item, (OutputStream)byteArrayOutputStream, "UTF-8", string);
            String string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            Alert alert = new Alert(string, string2, null, AlertType.INFO);
            alert.setTimeout(-2);
            Display.getDisplay((MIDlet)this.midlet).setCurrent(alert, (Displayable)this);
        }
        catch (Exception exception) {
            this.midlet.reportException(exception, (Displayable)this);
        }
    }

    private String joinStringArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

