/*
 * Decompiled with CFR 0.152.
 */
package example.fc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class FileBrowser
extends MIDlet
implements CommandListener {
    private String currDirName = "/";
    private Command view = new Command("View", 8, 1);
    private Command creat = new Command("New", 8, 2);
    private Command creatOK = new Command("OK", 4, 1);
    private Command prop = new Command("Properties", 8, 2);
    private Command back = new Command("Back", 2, 2);
    private Command exit = new Command("Exit", 7, 3);
    private TextField nameInput;
    private ChoiceGroup typeInput;
    private static final String[] attrList = new String[]{"Read", "Write", "Hidden"};
    private static final String[] typeList = new String[]{"Regular File", "Directory"};
    private static final String[] monthList = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private Image dirIcon;
    private Image fileIcon;
    private Image[] iconList;
    private static final String UP_DIRECTORY = "..";
    private static final String MEGA_ROOT = "/";
    private static final String SEP_STR = "/";
    private static final char SEP = '/';

    public FileBrowser() {
        try {
            this.dirIcon = Image.createImage((String)"/icons/dir.png");
        }
        catch (IOException iOException) {
            this.dirIcon = null;
        }
        try {
            this.fileIcon = Image.createImage((String)"/icons/file.png");
        }
        catch (IOException iOException) {
            this.fileIcon = null;
        }
        this.iconList = new Image[]{this.fileIcon, this.dirIcon};
    }

    public void startApp() {
        try {
            this.showCurrDir();
        }
        catch (SecurityException securityException) {
            Alert alert = new Alert("Error", "You are not authorized to access the restricted API", null, AlertType.ERROR);
            alert.setTimeout(-2);
            Form form = new Form("Cannot access FileConnection");
            form.append((Item)new StringItem(null, "You cannot run this MIDlet with the current permissions. Sign the MIDlet suite, or run it in a different security domain"));
            form.addCommand(this.exit);
            form.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)form);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.view) {
            List list = (List)displayable;
            final String string = list.getString(list.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    if (string.endsWith("/") || string.equals(FileBrowser.UP_DIRECTORY)) {
                        FileBrowser.this.traverseDirectory(string);
                    } else {
                        FileBrowser.this.showFile(string);
                    }
                }
            }).start();
        } else if (command == this.prop) {
            List list = (List)displayable;
            String string = list.getString(list.getSelectedIndex());
            this.showProperties(string);
        } else if (command == this.creat) {
            this.createFile();
        } else if (command == this.creatOK) {
            String string = this.nameInput.getString();
            if (string == null || string.equals("")) {
                Alert alert = new Alert("Error!", "File Name is empty. Please provide file name", null, AlertType.ERROR);
                alert.setTimeout(-2);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
            } else {
                this.executeCreateFile(string, this.typeInput.getSelectedIndex() != 0);
                Display.getDisplay((MIDlet)this).getCurrent().removeCommand(this.creatOK);
                Display.getDisplay((MIDlet)this).getCurrent().removeCommand(this.back);
            }
        } else if (command == this.back) {
            this.showCurrDir();
        } else if (command == this.exit) {
            this.destroyApp(false);
        }
    }

    private void executeCreateFile(final String string, final boolean bl) {
        new Thread(new Runnable(){

            public void run() {
                FileBrowser.this.createFile(string, bl);
            }
        }).start();
    }

    void showCurrDir() {
        FileConnection fileConnection = null;
        try {
            List list;
            Enumeration enumeration;
            if ("/".equals(this.currDirName)) {
                enumeration = FileSystemRegistry.listRoots();
                list = new List(this.currDirName, 3);
            } else {
                fileConnection = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName));
                enumeration = fileConnection.list();
                list = new List(this.currDirName, 3);
                list.append(UP_DIRECTORY, this.dirIcon);
            }
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.charAt(string.length() - 1) == '/') {
                    list.append(string, this.dirIcon);
                    continue;
                }
                list.append(string, this.fileIcon);
            }
            list.setSelectCommand(this.view);
            list.addCommand(this.prop);
            if (!"/".equals(this.currDirName)) {
                list.addCommand(this.creat);
            }
            list.addCommand(this.exit);
            list.setCommandListener((CommandListener)this);
            if (fileConnection != null) {
                fileConnection.close();
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)list);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void traverseDirectory(String string) {
        if (this.currDirName.equals("/")) {
            if (string.equals(UP_DIRECTORY)) {
                return;
            }
            this.currDirName = string;
        } else {
            int n;
            this.currDirName = string.equals(UP_DIRECTORY) ? ((n = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2)) != -1 ? this.currDirName.substring(0, n + 1) : "/") : this.currDirName + string;
        }
        this.showCurrDir();
    }

    void showFile(String string) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + string));
            if (!fileConnection.exists()) {
                throw new IOException("File does not exists");
            }
            InputStream inputStream = fileConnection.openInputStream();
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray, 0, 1024);
            inputStream.close();
            fileConnection.close();
            TextBox textBox = new TextBox("View File: " + string, null, 1024, 131072);
            textBox.addCommand(this.back);
            textBox.addCommand(this.exit);
            textBox.setCommandListener((CommandListener)this);
            if (n > 0) {
                textBox.setString(new String(byArray, 0, n));
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)textBox);
        }
        catch (Exception exception) {
            Alert alert = new Alert("Error!", "Can not access file " + string + " in directory " + this.currDirName + "\nException: " + exception.getMessage(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
        }
    }

    void showProperties(String string) {
        try {
            if (string.equals(UP_DIRECTORY)) {
                return;
            }
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + string));
            if (!fileConnection.exists()) {
                throw new IOException("File does not exists");
            }
            Form form = new Form("Properties: " + string);
            ChoiceGroup choiceGroup = new ChoiceGroup("Attributes:", 2, attrList, null);
            choiceGroup.setSelectedFlags(new boolean[]{fileConnection.canRead(), fileConnection.canWrite(), fileConnection.isHidden()});
            form.append((Item)new StringItem("Location:", this.currDirName));
            form.append((Item)new StringItem("Type: ", fileConnection.isDirectory() ? "Directory" : "Regular File"));
            form.append((Item)new StringItem("Modified:", this.myDate(fileConnection.lastModified())));
            form.append((Item)choiceGroup);
            form.addCommand(this.back);
            form.addCommand(this.exit);
            form.setCommandListener((CommandListener)this);
            fileConnection.close();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
        }
        catch (Exception exception) {
            Alert alert = new Alert("Error!", "Can not access file " + string + " in directory " + this.currDirName + "\nException: " + exception.getMessage(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
        }
    }

    void createFile() {
        Form form = new Form("New File");
        this.nameInput = new TextField("Enter Name", null, 256, 0);
        this.typeInput = new ChoiceGroup("Enter File Type", 1, typeList, this.iconList);
        form.append((Item)this.nameInput);
        form.append((Item)this.typeInput);
        form.addCommand(this.creatOK);
        form.addCommand(this.back);
        form.addCommand(this.exit);
        form.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
    }

    void createFile(String string, boolean bl) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + this.currDirName + string));
            if (bl) {
                fileConnection.mkdir();
            } else {
                fileConnection.create();
            }
            this.showCurrDir();
        }
        catch (Exception exception) {
            String string2 = "Can not create file '" + string + "'";
            if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                string2 = string2 + "\n" + exception;
            }
            Alert alert = new Alert("Error!", string2, null, AlertType.ERROR);
            alert.setTimeout(-2);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
            Display.getDisplay((MIDlet)this).getCurrent().addCommand(this.creatOK);
            Display.getDisplay((MIDlet)this).getCurrent().addCommand(this.back);
        }
    }

    private String myDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.get(11));
        stringBuffer.append(':');
        stringBuffer.append(calendar.get(12));
        stringBuffer.append(':');
        stringBuffer.append(calendar.get(13));
        stringBuffer.append(',');
        stringBuffer.append(' ');
        stringBuffer.append(calendar.get(5));
        stringBuffer.append(' ');
        stringBuffer.append(monthList[calendar.get(2)]);
        stringBuffer.append(' ');
        stringBuffer.append(calendar.get(1));
        return stringBuffer.toString();
    }
}

