/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.sun.cldc.io.ConnectionBaseInterface;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static String platform;
    private static boolean j2me;
    private static String classRoot;

    private Connector() {
    }

    public static Connection open(String name) throws IOException {
        return Connector.open(name, 3);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        if (platform != null) {
            try {
                return Connector.openPrim(name, mode, timeouts, platform);
            }
            catch (ClassNotFoundException x) {
                x.printStackTrace();
            }
        }
        try {
            return Connector.openPrim(name, mode, timeouts, j2me ? "j2me" : "j2se");
        }
        catch (ClassNotFoundException x) {
            x.printStackTrace();
            throw new ConnectionNotFoundException("The requested protocol does not exist " + name);
        }
    }

    private static Connection openPrim(String name, int mode, boolean timeouts, String platform) throws IOException, ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null URL");
        }
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IllegalArgumentException("no ':' in URL");
        }
        try {
            String protocol = name.substring(0, colon);
            name = name.substring(colon + 1);
            char[] chars = protocol.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || i > 0 && ('0' <= c && c <= '9' || c == '+' || c == '-' || c == '.')) continue;
                throw new IllegalArgumentException("Invalid protocol name");
            }
            Class clazz = Class.forName(classRoot + "." + platform + "." + protocol + ".Protocol");
            ConnectionBaseInterface uc = (ConnectionBaseInterface)clazz.newInstance();
            return uc.openPrim(name, mode, timeouts);
        }
        catch (InstantiationException x) {
            throw new IOException(x.toString());
        }
        catch (IllegalAccessException x) {
            throw new IOException(x.toString());
        }
        catch (ClassCastException x) {
            throw new IOException(x.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataInputStream openDataInputStream(String name) throws IOException {
        InputConnection con = (InputConnection)Connector.open(name, 1);
        try {
            DataInputStream dataInputStream = con.openDataInputStream();
            return dataInputStream;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        OutputConnection con = (OutputConnection)Connector.open(name, 2);
        try {
            DataOutputStream dataOutputStream = con.openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            con.close();
        }
    }

    public static InputStream openInputStream(String name) throws IOException {
        return Connector.openDataInputStream(name);
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        return Connector.openDataOutputStream(name);
    }

    private static native boolean isNetworkMonitorActive();

    static {
        j2me = false;
        if (System.getProperty("microedition.configuration") != null) {
            j2me = true;
        }
        platform = System.getProperty("microedition.platform");
        classRoot = Connector.isNetworkMonitorActive() ? System.getProperty("javax.microedition.io.Connector.protocolpath") : "com.sun.midp.io";
        if (classRoot == null) {
            classRoot = "com.sun.cldc.io";
        }
    }
}

