/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n;

import com.sun.cldc.i18n.StreamReader;
import com.sun.cldc.i18n.StreamWriter;
import com.sun.kvem.cldc.i18n.j2me.GenericReader;
import com.sun.kvem.cldc.i18n.j2me.GenericWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class Helper {
    private static String defaultEncoding;
    private static String defaultMEPath;
    private static boolean j2me;
    private static String lastReaderEncoding;
    private static StreamReader lastReader;
    private static String lastWriterEncoding;
    private static StreamWriter lastWriter;

    public static Reader getStreamReader(InputStream is) {
        try {
            return Helper.getStreamReader(is, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            try {
                defaultEncoding = "ISO8859_1";
                return Helper.getStreamReader(is, defaultEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Missing default encoding " + defaultEncoding);
            }
        }
    }

    public static Reader getStreamReader(InputStream is, String name) throws UnsupportedEncodingException {
        if (is == null || name == null) {
            throw new NullPointerException();
        }
        StreamReader fr = Helper.getStreamReaderPrim(name);
        return fr.open(is, name);
    }

    private static StreamReader getStreamReaderPrim(String name) throws UnsupportedEncodingException {
        if (name == null) {
            throw new NullPointerException();
        }
        String InternalName = Helper.internalNameForEncoding(name);
        try {
            String className = j2me ? defaultMEPath + '.' + InternalName + "_Reader" : "com.sun.cldc.i18n.j2se.Default_Reader";
            Class clazz = Class.forName(className);
            return (StreamReader)clazz.newInstance();
        }
        catch (ClassNotFoundException x) {
            return new GenericReader(name);
        }
        catch (InstantiationException x) {
            throw new RuntimeException("InstantiationException " + x.getMessage());
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException("IllegalAccessException " + x.getMessage());
        }
        catch (ClassCastException x) {
            throw new RuntimeException("ClassCastException " + x.getMessage());
        }
    }

    public static Writer getStreamWriter(OutputStream os) {
        try {
            return Helper.getStreamWriter(os, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            try {
                defaultEncoding = "ISO8859_1";
                return Helper.getStreamWriter(os, defaultEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Missing default encoding " + defaultEncoding);
            }
        }
    }

    public static Writer getStreamWriter(OutputStream os, String name) throws UnsupportedEncodingException {
        if (os == null || name == null) {
            throw new NullPointerException();
        }
        StreamWriter sw = Helper.getStreamWriterPrim(name);
        return sw.open(os, name);
    }

    private static StreamWriter getStreamWriterPrim(String name) throws UnsupportedEncodingException {
        if (name == null) {
            throw new NullPointerException();
        }
        String InternalName = Helper.internalNameForEncoding(name);
        try {
            String className = j2me ? defaultMEPath + '.' + InternalName + "_Writer" : "com.sun.cldc.i18n.j2se.Default_Writer";
            Class clazz = Class.forName(className);
            return (StreamWriter)clazz.newInstance();
        }
        catch (ClassNotFoundException x) {
            return new GenericWriter(name);
        }
        catch (InstantiationException x) {
            throw new RuntimeException("InstantiationException " + x.getMessage());
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException("IllegalAccessException " + x.getMessage());
        }
        catch (ClassCastException x) {
            throw new RuntimeException("ClassCastException " + x.getMessage());
        }
    }

    public static char[] byteToCharArray(byte[] buffer, int offset, int length) {
        try {
            return Helper.byteToCharArray(buffer, offset, length, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException("Missing default encoding " + defaultEncoding);
        }
    }

    public static byte[] charToByteArray(char[] buffer, int offset, int length) {
        try {
            return Helper.charToByteArray(buffer, offset, length, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException("Missing default encoding " + defaultEncoding);
        }
    }

    public static synchronized char[] byteToCharArray(byte[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(offset));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(length));
        }
        if (offset > buffer.length - length) {
            throw new IndexOutOfBoundsException(Integer.toString(offset + length));
        }
        if (lastReaderEncoding == null || !lastReaderEncoding.equals(enc)) {
            lastReader = Helper.getStreamReaderPrim(enc);
            lastReaderEncoding = enc;
        }
        if (lastReader instanceof GenericReader) {
            try {
                GenericReader r = (GenericReader)lastReader;
                return r.getChars(buffer, offset, length);
            }
            catch (IOException x) {
                throw new RuntimeException("IOException writing writer " + x.getMessage());
            }
        }
        int size = lastReader.sizeOf(buffer, offset, length);
        char[] outbuf = new char[size];
        lastReader.open(new ByteArrayInputStream(buffer, offset, length), enc);
        try {
            lastReader.read(outbuf, 0, size);
            lastReader.close();
        }
        catch (IOException x) {
            throw new RuntimeException("IOException reading reader " + x.getMessage());
        }
        return outbuf;
    }

    public static synchronized byte[] charToByteArray(char[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (lastWriterEncoding == null || !lastWriterEncoding.equals(enc)) {
            lastWriter = Helper.getStreamWriterPrim(enc);
            lastWriterEncoding = enc;
        }
        if (lastWriter instanceof GenericWriter) {
            try {
                GenericWriter w = (GenericWriter)lastWriter;
                return w.getBytes(buffer, offset, length);
            }
            catch (IOException x) {
                throw new RuntimeException("IOException writing writer " + x.getMessage());
            }
        }
        int size = lastWriter.sizeOf(buffer, offset, length);
        ByteArrayOutputStream os = new ByteArrayOutputStream(size);
        lastWriter.open(os, enc);
        try {
            lastWriter.write(buffer, offset, length);
            lastWriter.close();
        }
        catch (IOException x) {
            throw new RuntimeException("IOException writing writer " + x.getMessage());
        }
        try {
            os.close();
        }
        catch (IOException x) {
            // empty catch block
        }
        return os.toByteArray();
    }

    private static String internalNameForEncoding(String encodingName) {
        String internalName = Helper.normalizeEncodingName(encodingName);
        if (internalName.equals("US_ASCII")) {
            return "ISO8859_1";
        }
        if (internalName.equals("ISO_8859_1")) {
            return "ISO8859_1";
        }
        String property = System.getProperty(internalName + "_InternalEncodingName");
        if (property != null) {
            return property;
        }
        return internalName;
    }

    private static String normalizeEncodingName(String encodingName) {
        StringBuffer normalizedName = new StringBuffer(encodingName);
        for (int i = 0; i < normalizedName.length(); ++i) {
            char currentChar = normalizedName.charAt(i);
            if (currentChar == '-' || currentChar == ':') {
                normalizedName.setCharAt(i, '_');
                continue;
            }
            normalizedName.setCharAt(i, Character.toUpperCase(currentChar));
        }
        return normalizedName.toString();
    }

    static {
        j2me = false;
        defaultEncoding = System.getProperty("microedition.encoding");
        if (defaultEncoding == null) {
            defaultEncoding = "ISO8859_1";
        }
        if (System.getProperty("microedition.configuration") != null) {
            j2me = true;
        }
        if ((defaultMEPath = System.getProperty("com.sun.cldc.i18n.Helper.i18npath")) == null) {
            defaultMEPath = "com.sun.cldc.i18n.j2me";
        }
    }
}

