/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPPart;

public abstract class SOAPMessage {
    public static final String CHARACTER_SET_ENCODING = "javax.xml.soap.character-set-encoding";
    public static final String WRITE_XML_DECLARATION = "javax.xml.soap.write-xml-declaration";

    public abstract int countAttachments();

    public abstract void removeAllAttachments();

    public abstract void saveChanges() throws SOAPException;

    public abstract boolean saveRequired();

    public abstract void writeTo(OutputStream var1) throws SOAPException, IOException;

    public abstract String getContentDescription();

    public abstract void setContentDescription(String var1);

    public abstract Iterator getAttachments();

    public abstract AttachmentPart createAttachmentPart();

    public abstract void addAttachmentPart(AttachmentPart var1);

    public abstract MimeHeaders getMimeHeaders();

    public SOAPBody getSOAPBody() throws SOAPException {
        throw new UnsupportedOperationException("getSOAPBody must be overridden by all subclasses of SOAPMessage");
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        throw new UnsupportedOperationException("getSOAPHeader must be overridden by all subclasses of SOAPMessage");
    }

    public abstract SOAPPart getSOAPPart();

    public Object getProperty(String string) throws SOAPException {
        throw new UnsupportedOperationException("getProperty must be overridden by all subclasses of SOAPMessage");
    }

    public void setProperty(String string, Object object) throws SOAPException {
        throw new UnsupportedOperationException("setProperty must be overridden by all subclasses of SOAPMessage");
    }

    public abstract Iterator getAttachments(MimeHeaders var1);

    public AttachmentPart createAttachmentPart(DataHandler dataHandler) {
        AttachmentPart attachmentPart = this.createAttachmentPart();
        attachmentPart.setDataHandler(dataHandler);
        return attachmentPart;
    }

    public AttachmentPart createAttachmentPart(Object object, String string) {
        AttachmentPart attachmentPart = this.createAttachmentPart();
        attachmentPart.setContent(object, string);
        return attachmentPart;
    }
}

