/*
 * Decompiled with CFR 0.152.
 */
package com.superscape.m3g.wtksamples.retainedmode;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.World;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class RetainedModeMidlet
extends MIDlet
implements CommandListener {
    private Display myDisplay = null;
    private JesterCanvas myCanvas = null;
    private Timer myRefreshTimer = new Timer();
    private TimerTask myRefreshTask = null;
    private Command exitCommand = new Command("Exit", 8, 1);
    Graphics3D myGraphics3D = Graphics3D.getInstance();
    World myWorld = null;
    private long worldStartTime = 0L;
    int viewport_x;
    int viewport_y;
    int viewport_width;
    int viewport_height;
    int currentContent = 0;

    public RetainedModeMidlet() {
        this.myDisplay = Display.getDisplay((MIDlet)this);
        this.myCanvas = new JesterCanvas(this);
        this.myCanvas.setCommandListener(this);
        this.myCanvas.addCommand(this.exitCommand);
    }

    public void startApp() throws MIDletStateChangeException {
        this.myDisplay.setCurrent((Displayable)this.myCanvas);
        try {
            this.myWorld = (World)Loader.load((String)"/com/superscape/m3g/wtksamples/retainedmode/content/swerve.m3g")[0];
            this.setupAspectRatio();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.worldStartTime = System.currentTimeMillis();
        this.myCanvas.repaint();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        this.myRefreshTimer.cancel();
        this.myRefreshTimer = null;
    }

    void setupAspectRatio() {
        float[] fArray;
        this.viewport_x = 0;
        this.viewport_y = 0;
        this.viewport_width = this.myCanvas.getWidth();
        this.viewport_height = this.myCanvas.getHeight();
        Camera camera = this.myWorld.getActiveCamera();
        int n = camera.getProjection(fArray = new float[4]);
        if (n != 48) {
            float f = this.viewport_width / this.viewport_height;
            if (f < fArray[1]) {
                float f2 = (float)this.viewport_width / fArray[1];
                this.viewport_height = (int)f2;
                this.viewport_y = (this.myCanvas.getHeight() - this.viewport_height) / 2;
            } else {
                float f3 = (float)this.viewport_height * fArray[1];
                this.viewport_width = (int)f3;
                this.viewport_x = (this.myCanvas.getWidth() - this.viewport_width) / 2;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.myCanvas == null || this.myGraphics3D == null || this.myWorld == null) {
            return;
        }
        if (graphics.getClipWidth() != this.viewport_width || graphics.getClipHeight() != this.viewport_height || graphics.getClipX() != this.viewport_x || graphics.getClipY() != this.viewport_y) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.myCanvas.getWidth(), this.myCanvas.getHeight());
        }
        if (this.myRefreshTask != null) {
            this.myRefreshTask.cancel();
            this.myRefreshTask = null;
        }
        long l = System.currentTimeMillis() - this.worldStartTime;
        if (this.currentContent == 0 && l > 5000L) {
            ++this.currentContent;
            try {
                this.myWorld = (World)Loader.load((String)"/com/superscape/m3g/wtksamples/retainedmode/content/skaterboy.m3g")[0];
                this.setupAspectRatio();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.myCanvas.getWidth(), this.myCanvas.getHeight());
        }
        int n = this.myWorld.animate((int)l);
        this.myGraphics3D.bindTarget((Object)graphics);
        this.myGraphics3D.setViewport(this.viewport_x, this.viewport_y, this.viewport_width, this.viewport_height);
        this.myGraphics3D.render(this.myWorld);
        this.myGraphics3D.releaseTarget();
        if (n < 1) {
            n = 1;
        }
        if (n == Integer.MAX_VALUE) {
            this.myRefreshTask = new RefreshTask();
            this.myRefreshTimer.schedule(this.myRefreshTask, 1000L);
        } else {
            this.myRefreshTask = new RefreshTask();
            this.myRefreshTimer.schedule(this.myRefreshTask, n);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            try {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class JesterCanvas
    extends Canvas {
        RetainedModeMidlet myTestlet;

        JesterCanvas(RetainedModeMidlet retainedModeMidlet2) {
            this.myTestlet = retainedModeMidlet2;
        }

        void init() {
        }

        void destroy() {
        }

        protected void paint(Graphics graphics) {
            this.myTestlet.paint(graphics);
        }

        protected void keyPressed(int n) {
        }

        protected void keyReleased(int n) {
        }

        protected void keyRepeated(int n) {
        }

        protected void pointerDragged(int n, int n2) {
        }

        protected void pointerPressed(int n, int n2) {
        }

        protected void pointerReleased(int n, int n2) {
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        public void run() {
            RetainedModeMidlet.this.myCanvas.repaint(RetainedModeMidlet.this.viewport_x, RetainedModeMidlet.this.viewport_y, RetainedModeMidlet.this.viewport_width, RetainedModeMidlet.this.viewport_height);
        }
    }
}

