/*
 * Decompiled with CFR 0.152.
 */
package com.superscape.m3g.wtksamples.life3d;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class Life3D
extends MIDlet
implements CommandListener {
    private static final int minSurvive = 4;
    private static final int maxSurvive = 5;
    private static final int minBirth = 5;
    private static final int maxBirth = 5;
    private static final int CUBESIZE_BITS = 3;
    private static final int CUBESIZE = 8;
    private static final int NUMCELLS = 512;
    private static final int STEPX = 64;
    private static final int STEPY = 8;
    private static final int STEPZ = 1;
    private static final int MASKX = 448;
    private static final int MASKY = 56;
    private static final int MASKZ = 7;
    private static final int SHIFTX = 6;
    private static final int SHIFTY = 3;
    private static final int SHIFTZ = 0;
    private Display myDisplay = null;
    private CallbackCanvas myCanvas = null;
    private Timer myRefreshTimer = new Timer();
    private TimerTask myRefreshTask = null;
    private Command exitCommand = new Command("Exit", 8, 1);
    private World myWorld = null;
    private Group rootGroup = null;
    private Mesh[] cells;
    private byte[] nextState;
    private byte[] currentState;
    private Random rand = null;
    private float angle = 0.0f;
    private int delay = 1;
    private int delayCount = 0;
    private int population = 0;
    private int generations = 0;
    private int pattern = -1;
    private String patternName = "Random";
    private String[][] patternLibrary = new String[][]{{"L block          ", "433434443533534543"}, {"Skew L block     ", "333334343344433444"}, {"Opposed L block  ", "254263264353354363"}, {"Beehive          ", "353344364355453444464455"}, {"Skew beehive     ", "323333412421423431433442521531"}, {"Broken beehive   ", "434443454535546555645646343344"}, {"Skew beehive plus", "254264345354356364366375445456466"}, {"Beehive var 75   ", "515516524525605606634635715716724725"}, {"Ascend+descend   ", "034044133143145243246256344345354355"}, {"Battered ring    ", "235244245325336354355425434446455535545"}, {"Ring             ", "243253334335346343356353364365434435446456464465"}, {"Cage             ", "334345455454424435433554534545543"}, {"Skew cage        ", "413422424433513514532533623"}, {"Ball             ", "326335337346425427445447526535537546"}, {"Ball 1 cap       ", "326335337346425427445447526535537546235"}, {"Ball 2 caps      ", "326335337346425427445447526535537546235635"}, {"Ball 2 caps hole ", "445447456416425427546526537346326335"}, {"Pinwheel         ", "213214223224303315322334413414423424"}, {"Columns          ", "445447457546556245255344346354"}, {"Columns ext      ", "445447457546556245255344346354144243043053142152"}, {"Staircase        ", "462472540541561563572640641650652"}, {"Cupped hands     ", "035045134136144226234236244325335"}, {"New 1            ", "013022114113125122134133225234"}, {"New 2            ", "422423432522523544543634644643"}, {"New 3            ", "344455433435443446554555534543546"}, {"New 4            ", "111112202210213222301302310321411"}, {"New 5            ", "343353442454452545542555533644643654"}, {"New 6            ", "440450452461541550241251252340342362"}, {"New 7            ", "427434444447535536545546326335336337"}, {"New 8            ", "241250252261340341360362372450461471"}, {"New 9            ", "414415435433524525234233344343325323"}, {"New 10           ", "456466165166175176257264267274357365367"}, {"New 11           ", "156165166255265266472502562571573601661663762771772"}, {"New 12           ", "124125134136224226233237246336343347354356444446454455"}, {"Compass          ", "333432434423443533"}, {"P2 Wonky Compass ", "344454434443445554534"}, {"P2 Double Compass", "461462552553572573661662"}, {"P2 Blinker       ", "151161241250252260262271351361"}, {"P2 Repeater      ", "445446534536544555645646"}, {"P2 Propellor     ", "444424425436545535345334336"}, {"P2 Magic Basket  ", "344345354334446443424425436546543524525533644645655635"}, {"P4 Boat          ", "333334423424432435443444"}, {"P4 Rotor         ", "225235316325327335337346426436"}, {"P4 Beehive       ", "353344364355365453444464455465"}, {"P4 Shuffler      ", "356445447455466545547555566656"}, {"P4 Popper        ", "333334343344433435445454534544"}, {"P4 Glider        ", "111112121122013023010020001002"}};

    public Life3D() {
        this.myDisplay = Display.getDisplay((MIDlet)this);
        this.myCanvas = new CallbackCanvas(this);
        this.myCanvas.setCommandListener(this);
        this.myCanvas.addCommand(this.exitCommand);
    }

    public void startApp() throws MIDletStateChangeException {
        try {
            this.myWorld = new World();
            Group group = new Group();
            this.myWorld.addChild((Node)group);
            group.setOrientation(15.0f, 1.0f, 0.0f, 0.0f);
            this.rootGroup = new Group();
            group.addChild((Node)this.rootGroup);
            Camera camera = new Camera();
            this.myWorld.addChild((Node)camera);
            this.myWorld.setActiveCamera(camera);
            camera.setParallel(12.0f, 1.0f, -8.0f, 8.0f);
            int[][] nArrayArray = new int[][]{{4}, {4}, {4}, {4}, {4}, {4}};
            short[] sArray = new short[]{-1, -1, 1, 1, -1, 1, -1, 1, 1, 1, 1, 1, -1, -1, -1, 1, -1, -1, -1, -1, 1, 1, -1, 1, -1, 1, 1, 1, 1, 1, -1, 1, -1, 1, 1, -1, 1, 1, 1, 1, -1, 1, 1, 1, -1, 1, -1, -1, -1, -1, 1, -1, 1, 1, -1, -1, -1, -1, 1, -1, 1, -1, -1, -1, -1, -1, 1, 1, -1, -1, 1, -1};
            byte[] byArray = new byte[]{-1, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, -1, -1, -1, 0, -1, -1, 0, -1, -1, 0, -1, -1, 0, -1, 0, -1, -1, 0, -1, -1, 0, -1, -1, 0, -1, 0, -1, -1, 0, -1, -1, 0, -1, -1, 0, -1, -1};
            int n = nArrayArray.length;
            int n2 = sArray.length / 3;
            Appearance appearance = new Appearance();
            Appearance[] appearanceArray = new Appearance[n];
            IndexBuffer[] indexBufferArray = new IndexBuffer[n];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                appearanceArray[i] = appearance;
                indexBufferArray[i] = new TriangleStripArray(n3, nArrayArray[i]);
                for (int j = 0; j < nArrayArray[i].length; ++j) {
                    n3 += nArrayArray[i][j];
                }
            }
            VertexBuffer vertexBuffer = new VertexBuffer();
            vertexBuffer.setDefaultColor(-1);
            VertexArray vertexArray = new VertexArray(n2, 3, 2);
            vertexArray.set(0, n2, sArray);
            vertexBuffer.setPositions(vertexArray, 0.4f, null);
            vertexArray = new VertexArray(n2, 3, 1);
            vertexArray.set(0, n2, byArray);
            vertexBuffer.setColors(vertexArray);
            this.cells = new Mesh[512];
            this.nextState = new byte[512];
            this.currentState = new byte[512];
            this.rand = new Random();
            int n4 = 0;
            for (int i = 0; i < 8; ++i) {
                float f = (float)(i * 2 - 8) * 0.5f;
                for (int j = 0; j < 8; ++j) {
                    float f2 = (float)(j * 2 - 8) * 0.5f;
                    for (int k = 0; k < 8; ++k) {
                        float f3 = (float)(k * 2 - 8) * 0.5f;
                        Mesh mesh = new Mesh(vertexBuffer, indexBufferArray, appearanceArray);
                        mesh.setTranslation(f, f2, f3);
                        this.rootGroup.addChild((Node)mesh);
                        this.currentState[n4] = this.rand.nextInt() > 0x40000000 ? (byte)1 : 0;
                        this.cells[n4++] = mesh;
                    }
                }
            }
            this.myDisplay.setCurrent((Displayable)this.myCanvas);
            this.myCanvas.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateNeighbours(int n) {
        if (this.currentState[n] != 0) {
            int n2 = n - 64 & 0x1C0;
            int n3 = n - 8 & 0x38;
            int n4 = n - 1 & 7;
            int n5 = n & 0x1C0;
            int n6 = n & 0x38;
            int n7 = n & 7;
            int n8 = n + 64 & 0x1C0;
            int n9 = n + 8 & 0x38;
            int n10 = n + 1 & 7;
            int n11 = n2 | n3 | n4;
            this.nextState[n11] = (byte)(this.nextState[n11] + 1);
            int n12 = n2 | n3 | n7;
            this.nextState[n12] = (byte)(this.nextState[n12] + 1);
            int n13 = n2 | n3 | n10;
            this.nextState[n13] = (byte)(this.nextState[n13] + 1);
            int n14 = n2 | n6 | n4;
            this.nextState[n14] = (byte)(this.nextState[n14] + 1);
            int n15 = n2 | n6 | n7;
            this.nextState[n15] = (byte)(this.nextState[n15] + 1);
            int n16 = n2 | n6 | n10;
            this.nextState[n16] = (byte)(this.nextState[n16] + 1);
            int n17 = n2 | n9 | n4;
            this.nextState[n17] = (byte)(this.nextState[n17] + 1);
            int n18 = n2 | n9 | n7;
            this.nextState[n18] = (byte)(this.nextState[n18] + 1);
            int n19 = n2 | n9 | n10;
            this.nextState[n19] = (byte)(this.nextState[n19] + 1);
            int n20 = n5 | n3 | n4;
            this.nextState[n20] = (byte)(this.nextState[n20] + 1);
            int n21 = n5 | n3 | n7;
            this.nextState[n21] = (byte)(this.nextState[n21] + 1);
            int n22 = n5 | n3 | n10;
            this.nextState[n22] = (byte)(this.nextState[n22] + 1);
            int n23 = n5 | n6 | n4;
            this.nextState[n23] = (byte)(this.nextState[n23] + 1);
            int n24 = n5 | n6 | n10;
            this.nextState[n24] = (byte)(this.nextState[n24] + 1);
            int n25 = n5 | n9 | n4;
            this.nextState[n25] = (byte)(this.nextState[n25] + 1);
            int n26 = n5 | n9 | n7;
            this.nextState[n26] = (byte)(this.nextState[n26] + 1);
            int n27 = n5 | n9 | n10;
            this.nextState[n27] = (byte)(this.nextState[n27] + 1);
            int n28 = n8 | n3 | n4;
            this.nextState[n28] = (byte)(this.nextState[n28] + 1);
            int n29 = n8 | n3 | n7;
            this.nextState[n29] = (byte)(this.nextState[n29] + 1);
            int n30 = n8 | n3 | n10;
            this.nextState[n30] = (byte)(this.nextState[n30] + 1);
            int n31 = n8 | n6 | n4;
            this.nextState[n31] = (byte)(this.nextState[n31] + 1);
            int n32 = n8 | n6 | n7;
            this.nextState[n32] = (byte)(this.nextState[n32] + 1);
            int n33 = n8 | n6 | n10;
            this.nextState[n33] = (byte)(this.nextState[n33] + 1);
            int n34 = n8 | n9 | n4;
            this.nextState[n34] = (byte)(this.nextState[n34] + 1);
            int n35 = n8 | n9 | n7;
            this.nextState[n35] = (byte)(this.nextState[n35] + 1);
            int n36 = n8 | n9 | n10;
            this.nextState[n36] = (byte)(this.nextState[n36] + 1);
        }
    }

    public void updateState(int n) {
        byte by = this.nextState[n];
        this.nextState[n] = 0;
        if (this.currentState[n] == 0) {
            this.currentState[n] = by >= 5 && by <= 5 ? (byte)1 : 0;
        } else {
            byte by2 = this.currentState[n] = by >= 4 && by <= 5 ? (byte)1 : 0;
        }
        if (this.currentState[n] != 0) {
            this.cells[n].setRenderingEnable(true);
            ++this.population;
        } else {
            this.cells[n].setRenderingEnable(false);
        }
    }

    public void pauseApp() {
        this.myRefreshTask.cancel();
        this.myRefreshTask = null;
        this.myWorld = null;
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        this.myRefreshTimer.cancel();
        this.myRefreshTimer = null;
        this.myRefreshTask = null;
        this.myWorld = null;
        this.myCanvas = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.myCanvas == null || this.myWorld == null) {
            return;
        }
        if (this.myRefreshTask != null) {
            this.myRefreshTask.cancel();
            this.myRefreshTask = null;
        }
        Graphics3D graphics3D = Graphics3D.getInstance();
        graphics3D.bindTarget((Object)graphics);
        try {
            graphics3D.render(this.myWorld);
        }
        finally {
            graphics3D.releaseTarget();
        }
        graphics.setColor(-1);
        graphics.drawString(this.generations + " : " + this.population, 0, 10, 20);
        graphics.drawString(this.patternName, 0, 0, 20);
        this.angle += 1.0f;
        this.rootGroup.setOrientation(this.angle, 0.0f, 1.0f, 0.0f);
        if (--this.delayCount <= 0) {
            int n;
            this.delayCount = this.delay;
            ++this.generations;
            System.gc();
            for (n = 0; n < 512; ++n) {
                this.updateNeighbours(n);
            }
            this.population = 0;
            for (n = 0; n < 512; ++n) {
                this.updateState(n);
            }
            if (this.population == 0) {
                this.loadRandomState();
            }
        }
        this.myRefreshTask = new RefreshTask();
        this.myRefreshTimer.schedule(this.myRefreshTask, 50L);
    }

    private void loadStateFromString(String string) {
        this.clear();
        for (int i = 0; i < string.length(); i += 3) {
            int n = string.charAt(i + 0) - 48 & 7;
            int n2 = string.charAt(i + 1) - 48 & 7;
            int n3 = string.charAt(i + 2) - 48 & 7;
            this.currentState[(n * 8 + n2) * 8 + n3] = 1;
        }
    }

    private void clear() {
        for (int i = 0; i < 512; ++i) {
            this.currentState[i] = 0;
        }
        this.generations = 0;
    }

    private void loadRandomState() {
        this.patternName = "Random";
        for (int i = 0; i < 512; ++i) {
            this.currentState[i] = this.rand.nextInt() > 0x40000000 ? (byte)1 : 0;
        }
        this.generations = 0;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            try {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void keyPressed(int n) {
        switch (n) {
            case 48: {
                this.delay = 1000000;
                this.delayCount = 1000000;
                break;
            }
            case 49: {
                this.delay = 0;
                this.delayCount = 0;
                break;
            }
            case 50: {
                if (this.delay > 0) {
                    --this.delay;
                }
                this.delayCount = 0;
                break;
            }
            case 51: {
                if (this.delay < 20) {
                    ++this.delay;
                }
                this.delayCount = 0;
                break;
            }
            case 52: {
                --this.pattern;
                if (this.pattern < 0) {
                    this.pattern = this.patternLibrary.length - 1;
                }
                this.patternName = this.patternLibrary[this.pattern][0];
                this.loadStateFromString(this.patternLibrary[this.pattern][1]);
                break;
            }
            case 53: {
                ++this.pattern;
                if (this.pattern >= this.patternLibrary.length) {
                    this.pattern = 0;
                }
                this.patternName = this.patternLibrary[this.pattern][0];
                this.loadStateFromString(this.patternLibrary[this.pattern][1]);
                break;
            }
            case 42: {
                this.loadRandomState();
            }
        }
    }

    private class CallbackCanvas
    extends Canvas {
        Life3D mymidlet;

        CallbackCanvas(Life3D life3D2) {
            this.mymidlet = life3D2;
        }

        void init() {
        }

        void destroy() {
        }

        protected void paint(Graphics graphics) {
            this.mymidlet.paint(graphics);
        }

        protected void keyPressed(int n) {
            this.mymidlet.keyPressed(n);
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        public void run() {
            Life3D.this.myCanvas.repaint();
        }
    }
}

