/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import kdp.Log;
import kdp.classparser.FileReference;

public class SearchPath {
    private String pathString;
    private String[] pathArray;

    public SearchPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.pathString = string;
        Log.LOGN(3, "!!!" + this.pathString);
        this.pathArray = arrayList.toArray(new String[arrayList.size()]);
        Log.LOGN(3, "Path array length is :" + this.pathArray.length);
        for (int i = 0; i < this.pathArray.length; ++i) {
            Log.LOGN(3, this.pathArray[i]);
        }
    }

    public boolean isEmpty() {
        return this.pathArray.length == 0;
    }

    public String asString() {
        return this.pathString;
    }

    public String[] asArray() {
        return (String[])this.pathArray.clone();
    }

    public int path_array_length() {
        return this.pathArray.length;
    }

    public FileReference resolve(String string) {
        Log.LOGN(4, "relative filename = " + string);
        Log.LOGN(4, "path array length in resolve is " + this.pathArray.length);
        if (!string.endsWith(".class")) {
            string = string + ".class";
        }
        Log.LOGN(4, "relative filename now = " + string);
        for (int i = 0; i < this.pathArray.length; ++i) {
            Log.LOGN(5, "pa=" + this.pathArray[i] + " " + "rfa=" + string);
            FileReference fileReference = FileReference.create(this.pathArray[i], string);
            if (!fileReference.exists()) continue;
            Log.LOGN(4, "  exists");
            return fileReference;
        }
        return null;
    }

    public String[] children(String string, FilenameFilter filenameFilter) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.pathArray.length; ++i) {
            String[] stringArray;
            FileReference fileReference = FileReference.create(this.pathArray[i], string);
            if (!fileReference.exists() || (stringArray = fileReference.list(filenameFilter)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (treeSet.contains(stringArray[j])) continue;
                treeSet.add(stringArray[j]);
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

