/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class FileReference {
    private FileReference() {
    }

    public static FileReference create(File file) {
        return new BaseFileReference(file);
    }

    public static FileReference create(JarFile jarFile, String string) {
        return new JarFileReference(jarFile, string);
    }

    public static FileReference create(String string, String string2) {
        File file = new File(string);
        if (file.isDirectory()) {
            return new BaseFileReference(new File(file, string2));
        }
        try {
            return new JarFileReference(file, string2);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't open JAR file " + file);
            return new NonExistentFileReference(file + ":" + string2);
        }
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract String[] list(FilenameFilter var1);

    public abstract boolean exists();

    private static class JarManager {
        static Map jars = new TreeMap();

        private JarManager() {
        }

        static JarFile openJar(File file) throws IOException {
            JarFile jarFile = (JarFile)jars.get(file);
            if (jarFile == null) {
                jarFile = new JarFile(file);
                jars.put(file, jarFile);
            }
            return jarFile;
        }
    }

    private static class NonExistentFileReference
    extends FileReference {
        private String description;

        NonExistentFileReference(String string) {
            this.description = string;
        }

        public boolean exists() {
            return false;
        }

        public String toString() {
            return this.description;
        }

        public InputStream getInputStream() throws IOException {
            throw new FileNotFoundException(this.description);
        }

        public String[] list(FilenameFilter filenameFilter) {
            return new String[0];
        }
    }

    private static class JarFileReference
    extends FileReference {
        private JarFile jarFile;
        private String element;

        JarFileReference(JarFile jarFile, String string) {
            this.jarFile = jarFile;
            this.element = string.replace(File.separatorChar, '/');
        }

        JarFileReference(File file, String string) throws IOException {
            this(JarManager.openJar(file), string);
        }

        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.jarFile.getEntry(this.element));
        }

        public String toString() {
            return this.jarFile.getName() + ":" + this.element;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof JarFileReference)) {
                return false;
            }
            JarFileReference jarFileReference = (JarFileReference)object;
            return jarFileReference.jarFile.getName().equals(this.jarFile.getName()) && jarFileReference.element.equals(this.element);
        }

        public boolean exists() {
            return this.jarFile.getEntry(this.element) != null;
        }

        public String[] list(FilenameFilter filenameFilter) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Enumeration<JarEntry> enumeration = this.jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (!string.startsWith(this.element)) continue;
                if ((string = string.substring(this.element.length())).startsWith("/")) {
                    string = string.substring(1);
                }
                if ((n = string.indexOf("/")) != -1) {
                    string = string.substring(0, n);
                }
                if (!filenameFilter.accept(new File(this.element), string)) continue;
                arrayList.add(string);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    private static class BaseFileReference
    extends FileReference {
        private File file;

        BaseFileReference(File file) {
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public String toString() {
            return this.file.toString();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof BaseFileReference)) {
                return false;
            }
            BaseFileReference baseFileReference = (BaseFileReference)object;
            return baseFileReference.file.equals(this.file);
        }

        public boolean exists() {
            return this.file.exists();
        }

        public String[] list(FilenameFilter filenameFilter) {
            return this.file.list(filenameFilter);
        }
    }
}

