/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import kdp.Log;
import kdp.Packet;
import kdp.ProxyListener;

class SocketConnection
implements Runnable {
    Socket socket;
    DataOutputStream out;
    DataInputStream in;
    ProxyListener proxy;

    SocketConnection(ProxyListener proxyListener, Socket socket) throws IOException {
        this.proxy = proxyListener;
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte receiveByte() throws IOException {
        int n = this.in.read();
        return (byte)n;
    }

    public void sendByte(byte by) throws IOException {
        this.out.write(by);
        this.out.flush();
    }

    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            while (true) {
                Packet packet = this.receivePacket();
                if ((packet.flags & 0x80) == 0 || packet.id >= 0) {
                    this.proxy.newPacket(packet);
                    continue;
                }
                this.proxy.replyReceived(packet);
            }
        }
        catch (Exception exception) {
            try {
                Log.LOGN(2, "Socket exception in " + this.proxy + exception + " ...exiting");
                this.proxy.newPacket(null);
                this.proxy.replyReceived(null);
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    public Packet receivePacket() throws IOException {
        int n;
        Packet packet = new Packet();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        int n5 = this.in.read();
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            throw new EOFException();
        }
        int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
        n2 = this.in.read();
        n3 = this.in.read();
        n4 = this.in.read();
        n5 = this.in.read();
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            throw new EOFException();
        }
        packet.id = (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
        packet.flags = (short)this.in.read();
        if (packet.flags < 0) {
            throw new EOFException();
        }
        if ((packet.flags & 0x80) == 0) {
            packet.cmdSet = (short)this.in.read();
            packet.cmd = (short)this.in.read();
            if (packet.cmdSet < 0 || packet.cmd < 0) {
                throw new EOFException();
            }
        } else {
            n2 = this.in.read();
            n3 = this.in.read();
            if (n2 < 0 || n3 < 0) {
                throw new EOFException();
            }
            packet.errorCode = (short)((n2 << 8) + (n3 << 0));
        }
        if ((n6 -= 11) < 0) {
            System.err.println("length is " + n6);
            System.err.println("Read is " + this.in.read());
        }
        packet.data = new byte[n6];
        for (int i = 0; i < packet.data.length; i += n) {
            n = this.in.read(packet.data, i, packet.data.length - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
        return packet;
    }

    public void send(Packet packet) throws IOException {
        int n = packet.data.length + 11;
        this.out.write(n >>> 24 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.out.write(packet.id >>> 24 & 0xFF);
        this.out.write(packet.id >>> 16 & 0xFF);
        this.out.write(packet.id >>> 8 & 0xFF);
        this.out.write(packet.id >>> 0 & 0xFF);
        this.out.write(packet.flags);
        if ((packet.flags & 0x80) == 0) {
            this.out.write(packet.cmdSet);
            this.out.write(packet.cmd);
        } else {
            this.out.write(packet.errorCode >>> 8 & 0xFF);
            this.out.write(packet.errorCode >>> 0 & 0xFF);
        }
        this.out.write(packet.data);
        this.out.flush();
    }
}

