/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import kdp.Packet;
import kdp.ProxyListener;

class PacketStream {
    final ProxyListener proxy;
    private int inCursor = 0;
    final Packet pkt;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean isCommitted = false;
    public int id;

    PacketStream(ProxyListener proxyListener, int n, int n2) {
        this.proxy = proxyListener;
        this.pkt = new Packet();
        this.id = this.pkt.id;
        this.pkt.cmdSet = (short)n;
        this.pkt.cmd = (short)n2;
    }

    PacketStream(ProxyListener proxyListener, int n, short s, short s2) {
        this.pkt = new Packet();
        this.proxy = proxyListener;
        this.pkt.id = n;
        this.id = n;
        this.pkt.errorCode = s2;
        this.pkt.flags = s;
    }

    PacketStream(ProxyListener proxyListener, Packet packet) {
        this.pkt = packet;
        this.proxy = proxyListener;
        this.id = packet.id;
    }

    int id() {
        return this.id;
    }

    void send() {
        if (!this.isCommitted) {
            this.pkt.data = this.dataStream.toByteArray();
            try {
                this.proxy.send(this.pkt);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isCommitted = true;
        }
    }

    void waitForReply() throws Exception {
        if (!this.isCommitted) {
            throw new Exception("waitForReply without send");
        }
        this.proxy.waitForReply(this.pkt);
        if (this.pkt.errorCode != 0) {
            throw new Exception(String.valueOf(this.pkt.errorCode));
        }
    }

    void writeBoolean(boolean bl) {
        if (bl) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte by) {
        this.dataStream.write(by);
    }

    void writeChar(char c) {
        this.dataStream.write((byte)(c >>> 8 & 0xFF));
        this.dataStream.write((byte)(c >>> 0 & 0xFF));
    }

    void writeShort(short s) {
        this.dataStream.write((byte)(s >>> 8 & 0xFF));
        this.dataStream.write((byte)(s >>> 0 & 0xFF));
    }

    void writeInt(int n) {
        this.dataStream.write((byte)(n >>> 24 & 0xFF));
        this.dataStream.write((byte)(n >>> 16 & 0xFF));
        this.dataStream.write((byte)(n >>> 8 & 0xFF));
        this.dataStream.write((byte)(n >>> 0 & 0xFF));
    }

    void writeLong(long l) {
        this.dataStream.write((byte)(l >>> 56 & 0xFFL));
        this.dataStream.write((byte)(l >>> 48 & 0xFFL));
        this.dataStream.write((byte)(l >>> 40 & 0xFFL));
        this.dataStream.write((byte)(l >>> 32 & 0xFFL));
        this.dataStream.write((byte)(l >>> 24 & 0xFFL));
        this.dataStream.write((byte)(l >>> 16 & 0xFFL));
        this.dataStream.write((byte)(l >>> 8 & 0xFFL));
        this.dataStream.write((byte)(l >>> 0 & 0xFFL));
    }

    void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    void writeID(int n, long l) {
        if (n == 8) {
            this.writeLong(l);
        } else {
            this.writeInt((int)l);
        }
    }

    void writeByteArray(byte[] byArray) {
        this.dataStream.write(byArray, 0, byArray.length);
    }

    void writeString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.writeInt(byArray.length);
            this.writeByteArray(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Cannot convert string to UTF8 bytes");
        }
    }

    byte readByte() {
        byte by = this.pkt.data[this.inCursor];
        ++this.inCursor;
        return by;
    }

    boolean readBoolean() {
        byte by = this.readByte();
        return by != 0;
    }

    char readChar() {
        int n = this.pkt.data[this.inCursor++] & 0xFF;
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (char)((n << 8) + n2);
    }

    short readShort() {
        int n = this.pkt.data[this.inCursor++] & 0xFF;
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (short)((n << 8) + n2);
    }

    int readInt() {
        int n = this.pkt.data[this.inCursor++] & 0xFF;
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        int n3 = this.pkt.data[this.inCursor++] & 0xFF;
        int n4 = this.pkt.data[this.inCursor++] & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    long readLong() {
        long l = this.pkt.data[this.inCursor++] & 0xFF;
        long l2 = this.pkt.data[this.inCursor++] & 0xFF;
        long l3 = this.pkt.data[this.inCursor++] & 0xFF;
        long l4 = this.pkt.data[this.inCursor++] & 0xFF;
        long l5 = this.pkt.data[this.inCursor++] & 0xFF;
        long l6 = this.pkt.data[this.inCursor++] & 0xFF;
        long l7 = this.pkt.data[this.inCursor++] & 0xFF;
        long l8 = this.pkt.data[this.inCursor++] & 0xFF;
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    String readString() {
        String string;
        int n = this.readInt();
        try {
            string = new String(this.pkt.data, this.inCursor, n, "UTF8");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println(indexOutOfBoundsException);
            string = "IndexOutOfBoundsExceptions";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
            string = "Conversion error!";
        }
        this.inCursor += n;
        return string;
    }

    private long readID(int n) {
        if (n == 8) {
            return this.readLong();
        }
        return this.readInt();
    }

    int skipBytes(int n) {
        this.inCursor += n;
        return n;
    }

    byte command() {
        return (byte)this.pkt.cmd;
    }
}

