/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Map;
import kdp.DebuggerListener;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LineNumberTableAttribute;

class KVMListener
extends ProxyListener
implements VMConstants {
    SocketConnection connKvm;
    DebuggerListener debuggerListener = null;
    ClassManager manager;
    Options options;
    boolean Ready = false;
    boolean useClassParser = false;
    Socket remoteSocket = null;

    public KVMListener(Options options) {
        this.options = options;
        this.useClassParser = options.getUseClassParser();
    }

    public void set(ProxyListener proxyListener, ClassManager classManager) {
        this.debuggerListener = (DebuggerListener)proxyListener;
        this.manager = classManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Packet packet) throws IOException {
        Object object = this;
        synchronized (object) {
            while (!this.Ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((packet.flags & 0x80) == 0 && packet.id < 0) {
                this.waitingQueue.put(object, packet);
            }
        }
        this.connKvm.send(packet);
    }

    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            try {
                if (this.remoteSocket != null) {
                    this.remoteSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.debuggerListener.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForDebuggerToBind() {
        Object object = this.debuggerListener;
        synchronized (object) {
            while (!this.debuggerListener.Failed && !this.debuggerListener.Ready) {
                try {
                    this.debuggerListener.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.debuggerListener.Failed) {
            object = new PacketStream(this, 1, 10);
            ((PacketStream)object).writeInt(0);
            ((PacketStream)object).send();
            this.quit();
            Runtime.getRuntime().exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ClassFile classFile;
        int n;
        String string;
        int n2;
        byte by;
        int n3;
        int n4;
        try {
            System.err.println("Waiting for KVM...");
            while (this.remoteSocket == null) {
                try {
                    this.remoteSocket = new Socket(this.options.getRemoteHost(), this.options.getRemotePort());
                }
                catch (ConnectException connectException) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.connKvm = new SocketConnection(this, this.remoteSocket);
            System.err.println("Connected to KVM");
        }
        catch (IOException iOException) {
            System.out.println("KVMListener: " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            System.out.println("KVMListener: " + securityException.getMessage());
        }
        Object object = this;
        synchronized (object) {
            this.Ready = true;
            this.notify();
        }
        if (!this.useClassParser) {
            object = new String("JDWP-Handshake").getBytes();
            try {
                int n5;
                for (n5 = 0; n5 < ((Object)object).length; ++n5) {
                    this.connKvm.sendByte((byte)object[n5]);
                }
                for (n5 = 0; n5 < ((Object)object).length; ++n5) {
                    this.connKvm.receiveByte();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        new Thread(this.connKvm).start();
        if (this.useClassParser) {
            PacketStream packetStream = new PacketStream(this, 128, 1);
            packetStream.writeString("KVM Reference Debugger Agent");
            packetStream.writeByte((byte)1);
            packetStream.writeByte((byte)2);
            packetStream.send();
            try {
                packetStream.waitForReply();
            }
            catch (Exception exception) {
                System.out.println("Exception during handshake: " + exception + " exiting...");
                Runtime.getRuntime().exit(1);
            }
            object = packetStream.readString();
            int n6 = packetStream.readInt();
            Log.LOGN(1, "KVM Handshake return string: " + (String)object);
            Log.LOGN(1, "KVM Handshake return options: " + n6);
            if ((n6 & 0x18000) >> 15 == 2) {
                Log.LOGN(1, "Method index base being set to 1");
                method_index_base = 1;
            }
            this.waitForDebuggerToBind();
            packetStream = new PacketStream(this, 1, 3);
            packetStream.send();
            try {
                packetStream.waitForReply();
            }
            catch (Exception exception) {
                System.out.println("Couldn't get list of classes from KVM");
            }
            n4 = packetStream.readInt();
            Log.LOGN(2, n4 + " classes");
            for (n3 = 0; n3 < n4; ++n3) {
                by = packetStream.readByte();
                n2 = packetStream.readInt();
                string = packetStream.readString();
                if (by != 3) {
                    string = new String(string.substring(1, string.length() - 1));
                }
                n = packetStream.readInt();
                classFile = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                if (classFile != null) continue;
                Log.LOGN(3, "allclasses: new class: " + string + " " + Integer.toHexString(n2));
                classFile = this.manager.findClass(by, string);
                if (classFile != null) {
                    classFile.setClassID(n2);
                    classFile.setClassStatus(n);
                    ClassManager.classMap.put(new Integer(n2), classFile);
                    continue;
                }
                Log.LOGN(3, "allclasses: couldn't find class " + string);
            }
        } else {
            this.waitForDebuggerToBind();
        }
        try {
            while (!this.timeToQuit) {
                boolean bl = false;
                Packet packet = this.waitForPacket();
                if (packet != null) {
                    if (this.useClassParser && (packet.flags & 0x80) == 0) {
                        switch (packet.cmdSet) {
                            case 64: {
                                switch (packet.cmd) {
                                    case 100: {
                                        object = new PacketStream(this, packet);
                                        n4 = ((PacketStream)object).readByte();
                                        n3 = ((PacketStream)object).readInt();
                                        byte by2 = ((PacketStream)object).readByte();
                                        if (by2 != 8) break;
                                        int n7 = ((PacketStream)object).readInt();
                                        int n8 = ((PacketStream)object).readInt();
                                        by = ((PacketStream)object).readByte();
                                        n2 = ((PacketStream)object).readInt();
                                        string = ((PacketStream)object).readString();
                                        n = ((PacketStream)object).readInt();
                                        if (by != 3) {
                                            string = new String(string.substring(1, string.length() - 1));
                                        }
                                        Log.LOGN(3, "ClassPrepare:  " + string + ", ID = " + Integer.toHexString(n2));
                                        classFile = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                                        if (classFile == null) {
                                            classFile = this.manager.findClass(by, string);
                                            if (classFile != null) {
                                                ClassManager.classMap.put(new Integer(n2), classFile);
                                                classFile.setClassID(n2);
                                                classFile.setClassStatus(n);
                                                break;
                                            }
                                            Log.LOGN(3, "ClassPrepare: null cf!");
                                            break;
                                        }
                                        Log.LOGN(3, "ClassPrepare: got classfile " + classFile.getClassName());
                                        classFile.setClassStatus(n);
                                    }
                                }
                                break;
                            }
                            case 128: {
                                switch (packet.cmd) {
                                    case 3: {
                                        object = new PacketStream(this, packet);
                                        this.handleSteppingInfo((PacketStream)object);
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                    if (bl) continue;
                    Log.LOG(3, "KVMListener:: ");
                    this.disp(packet);
                    if (packet.cmdSet == 64 && packet.cmd == 100) {
                        Log.LOGN(3, "Eventkind = " + packet.data[5]);
                    }
                    this.debuggerListener.send(packet);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleSteppingInfo(PacketStream packetStream) {
        int n;
        long l;
        long l2;
        long l3;
        MethodInfo methodInfo;
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt();
        int n4 = packetStream.readInt() - method_index_base;
        long l4 = packetStream.readLong();
        Log.LOGN(3, "handleSteppingInfo: cep = " + Integer.toHexString(n2) + " cid = " + Integer.toHexString(n3) + " mid = " + Integer.toHexString(n4));
        PacketStream packetStream2 = new PacketStream(this, 128, 2);
        packetStream2.writeInt(n2);
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n3));
        if (classFile == null || (methodInfo = classFile.getMethodInfoByIndex(n4)) == null) {
            packetStream2.writeLong(0L);
            packetStream2.writeLong(0L);
            packetStream2.send();
            try {
                packetStream2.waitForReply();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        LineNumberTableAttribute lineNumberTableAttribute = null;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            lineNumberTableAttribute = codeAttribute.getLineNumberTable();
        }
        if (codeAttribute == null || lineNumberTableAttribute == null) {
            l3 = -1L;
            l2 = -1L;
            l = -1L;
            n = -1;
            int n5 = -1;
            int n6 = -1;
        } else {
            n = lineNumberTableAttribute.getCurrentLineCodeIndex(l4);
            int n7 = lineNumberTableAttribute.getNextExecutableLineCodeIndex(l4);
            int n8 = lineNumberTableAttribute.getDupCurrentExecutableLineCodeIndex(l4);
            l = lineNumberTableAttribute.getStartPCFromIndex(n7);
            l2 = lineNumberTableAttribute.getStartPCFromIndex(n8);
            l3 = lineNumberTableAttribute.getOffsetofDupNextLine(n8);
        }
        Log.LOGN(3, "handleSteppingInfo  current offset = " + l4);
        Log.LOGN(3, "handleSteppingInfo  target offset = " + l);
        Log.LOGN(3, "handleSteppingInfo  dup current line offset = " + l2);
        Log.LOGN(3, "handleSteppingInfo  offset after current dup = " + l3);
        if (lineNumberTableAttribute != null) {
            Log.LOGN(3, "handleSteppingInfo current line number = " + lineNumberTableAttribute.getLineNumberFromIndex(n));
        }
        packetStream2.writeLong(l);
        packetStream2.writeLong(l2);
        packetStream2.writeLong(l3);
        packetStream2.send();
        try {
            packetStream2.waitForReply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return new String("KVMListener: ");
    }
}

