/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.FieldInfo;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LocalVariable;
import kdp.classparser.attributes.SourceFileAttribute;

class DebuggerListener
extends ProxyListener
implements VMConstants {
    static final int UseClassParser = 1;
    SocketConnection connDebugger;
    ProxyListener KVMListener;
    ClassManager manager = null;
    Packet replyPacket;
    Options options;
    boolean Ready = false;
    boolean Failed = false;
    ServerSocket serverSocket = null;
    Socket acceptSocket = null;

    public DebuggerListener(Options options) {
        this.options = options;
    }

    public void set(ProxyListener proxyListener, ClassManager classManager) {
        this.KVMListener = proxyListener;
        this.manager = classManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Packet packet) throws IOException {
        Object object = this;
        synchronized (object) {
            while (!this.Ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((packet.flags & 0x80) == 0 && packet.id < 0) {
                this.waitingQueue.put(object, packet);
            }
        }
        this.connDebugger.send(packet);
    }

    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            this.KVMListener.quit();
            try {
                if (this.acceptSocket != null) {
                    this.acceptSocket.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n;
        Object object;
        Packet packet = null;
        Object var3_2 = null;
        Object var4_3 = null;
        PacketStream packetStream = null;
        PacketStream packetStream2 = null;
        try {
            if (this.options.getServerMode()) {
                System.out.println("Waiting for debugger on port " + this.options.getLocalPort());
                this.serverSocket = new ServerSocket(this.options.getLocalPort());
                this.acceptSocket = this.serverSocket.accept();
            } else {
                object = this.options.getDebuggerHost();
                n = this.options.getDebuggerPort();
                if (object == null) {
                    object = InetAddress.getLocalHost().getHostName();
                }
                if (n == 0) {
                    throw new IOException("Debugger port not defined");
                }
                System.out.println("Connecting to debugger at " + (String)object + ":" + n);
                this.acceptSocket = new Socket((String)object, n);
            }
            this.connDebugger = new SocketConnection(this, this.acceptSocket);
            System.out.println("Connection received.");
        }
        catch (Exception exception) {
            System.out.println("DebuggerListener: " + exception.getMessage());
            DebuggerListener debuggerListener = this;
            synchronized (debuggerListener) {
                this.Failed = true;
                this.notifyAll();
                return;
            }
        }
        object = new String("JDWP-Handshake").getBytes();
        try {
            for (n = 0; n < ((Object)object).length; ++n) {
                this.connDebugger.receiveByte();
            }
            for (n = 0; n < ((Object)object).length; ++n) {
                this.connDebugger.sendByte((byte)object[n]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object object2 = this;
        synchronized (object2) {
            this.Ready = true;
            this.notifyAll();
        }
        new Thread(this.connDebugger).start();
        try {
            while (!this.timeToQuit) {
                boolean bl = false;
                packet = this.waitForPacket();
                if (packet == null) break;
                if ((packet.flags & 0x80) == 0 && this.options.getUseClassParser()) {
                    packetStream2 = new PacketStream(this, packet);
                    switch (packet.cmdSet) {
                        case 1: {
                            int n2;
                            int n3;
                            byte by;
                            Object object3;
                            switch (packet.cmd) {
                                case 1: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeString("Version 1.0");
                                    packetStream.writeInt(1);
                                    packetStream.writeInt(0);
                                    packetStream.writeString("1.0.3");
                                    packetStream.writeString("KVM");
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 2: {
                                    String string = packetStream2.readString();
                                    Log.LOGN(3, "ClassBySig: class " + string);
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    object3 = ClassManager.classMap.values().iterator();
                                    while (object3.hasNext()) {
                                        try {
                                            object2 = (ClassFile)object3.next();
                                            if (object2 == null) {
                                                throw new Exception("Couldn't find classFile object");
                                            }
                                            if (string.compareTo(((ClassFile)object2).getClassSignature()) != 0) continue;
                                            Log.LOGN(3, "ClassBySig matched " + ((ClassFile)object2).getClassName());
                                            Log.LOGN(6, "Class Signature: " + ((ClassFile)object2).getClassSignature());
                                            packetStream.writeInt(1);
                                            packetStream.writeByte(((ClassFile)object2).getJDWPTypeTag());
                                            packetStream.writeInt(((ClassFile)object2).getClassID());
                                            packetStream.writeInt(((ClassFile)object2).getClassStatus());
                                            packetStream.send();
                                            bl = true;
                                            break;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("ClassesBySig command failed with " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 41);
                                            packetStream.send();
                                            bl = true;
                                        }
                                    }
                                    if (bl) break;
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    Log.LOGN(3, "All_Classes command");
                                    packetStream = new PacketStream(this.KVMListener, 1, 3);
                                    PacketStream packetStream3 = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.send();
                                    try {
                                        packetStream.waitForReply();
                                    }
                                    catch (Exception exception) {
                                        packetStream3.writeInt(0);
                                        packetStream3.send();
                                        bl = true;
                                        break;
                                    }
                                    int n4 = packetStream.readInt();
                                    packetStream3.writeInt(n4);
                                    for (int i = 0; i < n4; ++i) {
                                        by = packetStream.readByte();
                                        n3 = packetStream.readInt();
                                        String string = packetStream.readString();
                                        n2 = packetStream.readInt();
                                        packetStream3.writeByte(by);
                                        packetStream3.writeInt(n3);
                                        packetStream3.writeString(string);
                                        packetStream3.writeInt(n2);
                                        if (by != 3) {
                                            string = new String(string.substring(1, string.length() - 1));
                                        }
                                        Log.LOGN(3, "AllClasses:  " + string + ", ID = " + Integer.toHexString(n3));
                                        object2 = (ClassFile)ClassManager.classMap.get(new Integer(n3));
                                        if (object2 == null) {
                                            object2 = this.manager.findClass(by, string);
                                            if (object2 != null) {
                                                ClassManager.classMap.put(new Integer(n3), object2);
                                                ((ClassFile)object2).setClassID(n3);
                                                ((ClassFile)object2).setClassStatus(n2);
                                                continue;
                                            }
                                            System.out.println("ALL_CLASSES_CMD: couldn't find classfile object");
                                            packetStream3 = new PacketStream(this, packetStream2.id, 128, 41);
                                            packetStream3.send();
                                            bl = true;
                                            break;
                                        }
                                        ((ClassFile)object2).setClassStatus(n2);
                                    }
                                    packetStream3.send();
                                    bl = true;
                                    break;
                                }
                                case 5: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(1);
                                    packetStream.writeInt(-32);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 6: {
                                    packetStream = new PacketStream(this.KVMListener, 1, 10);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    PacketStream packetStream4 = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream4.send();
                                    bl = true;
                                    this.quit();
                                    break;
                                }
                                case 7: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(8);
                                    packetStream.writeInt(4);
                                    packetStream.writeInt(4);
                                    packetStream.writeInt(4);
                                    packetStream.writeInt(4);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 12: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(true);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 13: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeString("");
                                    packetStream.writeInt(0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 14: {
                                    Log.LOGN(3, "Dispose Objects: ");
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 2: {
                            int n3;
                            Object object3;
                            switch (packet.cmd) {
                                case 1: {
                                    n3 = packetStream2.readInt();
                                    Log.LOGN(3, "Signature cmd: class id = " + Integer.toHexString(n3));
                                    try {
                                        object2 = (ClassFile)ClassManager.classMap.get(new Integer(n3));
                                        if (object2 == null) {
                                            throw new Exception("Couldn't get ClassFile object for signature cmd");
                                        }
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        if (n3 == -32) {
                                            packetStream.writeString("Lkvm_threadgroup;");
                                        } else {
                                            packetStream.writeString(((ClassFile)object2).getClassSignature());
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        System.out.println("Signature cmd: exception " + exception);
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 2: {
                                    packetStream2.readInt();
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    n3 = packetStream2.readInt();
                                    try {
                                        object2 = (ClassFile)ClassManager.classMap.get(new Integer(n3));
                                        if (object2 == null) {
                                            throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                        }
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(((ClassFile)object2).getRawAccessFlags());
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        System.out.println("Modifiers cmd: exception " + exception);
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 4: {
                                    n3 = packetStream2.readInt();
                                    Log.LOGN(3, "field command: cid = " + Integer.toHexString(n3));
                                    object2 = (ClassFile)ClassManager.classMap.get(new Integer(n3));
                                    if (object2 == null) {
                                        Log.LOGN(3, "field_cmd: cf == null");
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    if (this.processFields((ClassFile)object2, packetStream, packetStream2.id)) {
                                        packetStream.send();
                                    }
                                    bl = true;
                                    break;
                                }
                                case 5: {
                                    n3 = packetStream2.readInt();
                                    Log.LOGN(3, "methods command: cid = " + Integer.toHexString(n3));
                                    object2 = (ClassFile)ClassManager.classMap.get(new Integer(n3));
                                    if (object2 == null || ((ClassFile)object2).getJDWPTypeTag() == 3) {
                                        Log.LOGN(3, "methods_cmd: cf == null or cf == arrayclass");
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    Log.LOGN(3, "methods for " + ((ClassFile)object2).getClassFileName());
                                    try {
                                        int n5 = method_index_base;
                                        List list = ((ClassFile)object2).getAllMethodInfo();
                                        Iterator iterator = list.iterator();
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        Log.LOGN(5, "Methods: " + list.size() + " methods");
                                        packetStream.writeInt(list.size());
                                        while (iterator.hasNext()) {
                                            MethodInfo methodInfo = (MethodInfo)iterator.next();
                                            if (methodInfo == null) {
                                                throw new Exception("methodinfo null");
                                            }
                                            Log.LOGN(5, "Method: id = " + Integer.toHexString(n5));
                                            packetStream.writeInt(n5++);
                                            Log.LOGN(5, "Method: name = " + methodInfo.getName());
                                            packetStream.writeString(methodInfo.getName());
                                            Log.LOGN(5, "Method: sig = " + methodInfo.getSignatureRaw());
                                            packetStream.writeString(methodInfo.getSignatureRaw());
                                            Log.LOGN(5, "Method: flags = " + methodInfo.getAccessFlags());
                                            packetStream.writeInt(methodInfo.getAccessFlags());
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        System.out.println("Methods cmd: exception " + exception);
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 41);
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 7: {
                                    Log.LOGN(3, "Source file cmd");
                                    n3 = packetStream2.readInt();
                                    try {
                                        object2 = (ClassFile)ClassManager.classMap.get(new Integer(n3));
                                        if (object2 == null) {
                                            throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                        }
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        SourceFileAttribute sourceFileAttribute = ((ClassFile)object2).getSourceAttribute();
                                        if (sourceFileAttribute != null) {
                                            object3 = sourceFileAttribute.getSourceFileName();
                                            Log.LOGN(3, "Returning from attribute: " + (String)object3);
                                            packetStream.writeString((String)object3);
                                        } else {
                                            Log.LOGN(3, "Creating source name: " + ((ClassFile)object2).getBaseName() + ".java");
                                            packetStream.writeString(((ClassFile)object2).getBaseName() + ".java");
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        System.out.println("Sourcefile cmd: exception " + exception);
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 10: {
                                    n3 = packetStream2.readInt();
                                    try {
                                        object2 = (ClassFile)ClassManager.classMap.get(new Integer(n3));
                                        if (object2 == null) {
                                            throw new Exception("Couldn't get ClassFile object for Interfaces cmd");
                                        }
                                        object3 = ((ClassFile)object2).getAllInterfaces();
                                        Iterator iterator = object3.iterator();
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        Log.LOGN(3, "Interfaces: class " + ((ClassFile)object2).getClassName() + " " + object3.size() + " interfaces");
                                        packetStream.writeInt(object3.size());
                                        while (iterator.hasNext()) {
                                            String string = (String)iterator.next();
                                            Log.LOGN(3, "interfaces: classname: " + string);
                                            if (string == null) {
                                                throw new Exception("interface name null");
                                            }
                                            object2 = this.manager.findClass((byte)76, string);
                                            if (object2 == null) {
                                                packetStream.writeInt(0);
                                                continue;
                                            }
                                            packetStream.writeInt(((ClassFile)object2).getClassID());
                                        }
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    catch (Exception exception) {
                                        System.out.println("Interfaces cmd: exception " + exception);
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        packetStream.send();
                                        bl = true;
                                    }
                                }
                            }
                            break;
                        }
                        case 6: {
                            switch (packet.cmd) {
                                case 1: {
                                    this.handleLineTable(packetStream2);
                                    bl = true;
                                    break;
                                }
                                case 2: {
                                    this.handleVariableTable(packetStream2);
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    this.handleByteCode(packetStream2);
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 11: {
                            switch (packet.cmd) {
                                case 5: {
                                    Log.LOGN(3, "Threadreference: threadgroup");
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(-32);
                                    packetStream.send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 12: {
                            Object object3;
                            switch (packet.cmd) {
                                case 1: {
                                    packetStream2.readInt();
                                    Log.LOGN(3, "ThreadGroup: name");
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeString("KVM_System");
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 2: {
                                    int n6 = packetStream2.readInt();
                                    Log.LOGN(3, "ThreadGroup: parent");
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    int n7 = packetStream2.readInt();
                                    Log.LOGN(3, "ThreadGroup: children");
                                    object3 = new PacketStream(this, packetStream2.id, 128, 0);
                                    if (n7 == -32) {
                                        packetStream = new PacketStream(this.KVMListener, 1, 4);
                                        packetStream.send();
                                        try {
                                            packetStream.waitForReply();
                                        }
                                        catch (Exception exception) {
                                            ((PacketStream)object3).writeInt(0);
                                            ((PacketStream)object3).writeInt(0);
                                            ((PacketStream)object3).send();
                                            bl = true;
                                            break;
                                        }
                                        int n8 = packetStream.readInt();
                                        Log.LOGN(3, "threadgroup: " + n8 + " children");
                                        ((PacketStream)object3).writeInt(n8);
                                        while (n8-- > 0) {
                                            ((PacketStream)object3).writeInt(packetStream.readInt());
                                        }
                                    } else {
                                        ((PacketStream)object3).writeInt(0);
                                    }
                                    ((PacketStream)object3).writeInt(0);
                                    ((PacketStream)object3).send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 16: {
                            int n2;
                            byte by;
                            switch (packet.cmd) {
                                case 3: {
                                    Log.LOGN(3, "Stackframe: thisobject");
                                    int n9 = packetStream2.readInt();
                                    int n10 = packetStream2.readInt();
                                    packetStream = new PacketStream(this.KVMListener, 16, 1);
                                    PacketStream packetStream5 = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(n9);
                                    packetStream.writeInt(n10);
                                    packetStream.writeInt(1);
                                    packetStream.writeInt(0);
                                    packetStream.writeByte((byte)76);
                                    packetStream.send();
                                    try {
                                        packetStream.waitForReply();
                                    }
                                    catch (Exception exception) {
                                        packetStream5.writeByte((byte)76);
                                        packetStream5.writeInt(0);
                                        packetStream5.send();
                                        bl = true;
                                        break;
                                    }
                                    n2 = packetStream.readInt();
                                    by = packetStream.readByte();
                                    int n11 = packetStream.readInt();
                                    Log.LOGN(3, "Stackframe: thisobject tag: " + by + " objectID " + n11);
                                    packetStream5.writeByte(by);
                                    packetStream5.writeInt(n11);
                                    packetStream5.send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 17: {
                            Object object3;
                            switch (packet.cmd) {
                                case 1: {
                                    int n12 = packetStream2.readInt();
                                    object3 = new PacketStream(this, packetStream2.id, 128, 0);
                                    object2 = (ClassFile)ClassManager.classMap.get(new Integer(n12));
                                    if (object2 == null) {
                                        ((PacketStream)object3).writeByte((byte)1);
                                    } else {
                                        ((PacketStream)object3).writeByte(((ClassFile)object2).getJDWPTypeTag());
                                    }
                                    ((PacketStream)object3).writeInt(n12);
                                    ((PacketStream)object3).send();
                                    bl = true;
                                }
                            }
                        }
                    }
                }
                if (bl) continue;
                Log.LOG(3, "DebuggerListener: ");
                this.disp(packet);
                if (packet.cmdSet == 15 && packet.cmd == 1) {
                    Log.LOG(3, "EventKind == " + packet.data[0] + "\n");
                }
                this.KVMListener.send(packet);
            }
        }
        catch (IOException iOException) {
            PacketStream packetStream6 = new PacketStream(this, packetStream2.id, 128, 41);
            packetStream6.send();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(packet.cmdSet + "/" + packet.cmd + " caused: " + arrayIndexOutOfBoundsException);
            PacketStream packetStream7 = new PacketStream(this, packetStream2.id, 128, 41);
            packetStream7.send();
        }
    }

    public String toString() {
        return new String("DebuggerListener: ");
    }

    protected String getClassName(byte[] byArray) {
        return new String("");
    }

    protected String getMethodName(byte[] byArray) {
        return new String("");
    }

    protected boolean processFields(ClassFile classFile, PacketStream packetStream, int n) {
        Log.LOGN(3, "processFields for " + classFile.getClassFileName());
        try {
            List list = classFile.getAllFieldInfo();
            if (list == null) {
                packetStream.writeInt(0);
                return true;
            }
            Iterator iterator = list.iterator();
            long l = (long)classFile.getClassID() << 32;
            Log.LOGN(5, "field class id is " + Integer.toHexString(classFile.getClassID()) + " fieldid is " + Long.toHexString(l));
            packetStream.writeInt(list.size());
            while (iterator.hasNext()) {
                FieldInfo fieldInfo = (FieldInfo)iterator.next();
                if (fieldInfo == null) {
                    throw new Exception("fieldinfo null");
                }
                Log.LOGN(5, "Field: id = " + Long.toHexString(l));
                packetStream.writeLong(l++);
                Log.LOGN(5, "Field: name = " + fieldInfo.getName());
                packetStream.writeString(fieldInfo.getName());
                Log.LOGN(5, "Field: sig = " + fieldInfo.getType());
                packetStream.writeString(fieldInfo.getType());
                Log.LOGN(5, "Field: flags = " + fieldInfo.getAccessFlags());
                packetStream.writeInt(fieldInfo.getAccessFlags());
            }
        }
        catch (Exception exception) {
            System.out.println("Fields cmd: exception " + exception);
            packetStream = new PacketStream(this, n, 128, 20);
            packetStream.send();
            return false;
        }
        return true;
    }

    public void handleLineTable(PacketStream packetStream) throws IOException {
        int n;
        long l;
        long l2;
        ClassFile classFile = null;
        int[][] nArray = null;
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt() - method_index_base;
        Log.LOGN(4, "linetable: class id= " + Integer.toHexString(n2) + ", method id= " + Integer.toHexString(n3 + method_index_base));
        classFile = (ClassFile)ClassManager.classMap.get(new Integer(n2));
        if (classFile == null) {
            Log.LOGN(3, "Linetable cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream2.send();
            return;
        }
        Log.LOGN(4, "linetable: class: " + classFile.getClassFileName());
        PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 0);
        MethodInfo methodInfo = classFile.getMethodInfoByIndex(n3);
        if (methodInfo == null) {
            Log.LOGN(1, "Couldn't find methodinfo for index " + n3 + method_index_base);
            packetStream3 = new PacketStream(this, packetStream.id, 128, 23);
            packetStream3.send();
            return;
        }
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            l2 = -1L;
            l = -1L;
        } else {
            l = 0L;
            l2 = codeAttribute.getCodeLength() - 1;
        }
        nArray = methodInfo.getBreakableLineNumbers();
        if (nArray == null) {
            Log.LOGN(1, "No linenumber table found for class " + classFile.getClassName());
            n = 0;
        } else {
            n = nArray.length;
        }
        packetStream3.writeLong(l);
        packetStream3.writeLong(l2);
        Log.LOGN(5, "Starting code offset = " + l + ", Ending code offset = " + l2);
        Log.LOGN(5, "Code Length = " + n);
        packetStream3.writeInt(n);
        for (int i = 0; i < n; ++i) {
            packetStream3.writeLong(nArray[i][1]);
            packetStream3.writeInt(nArray[i][0]);
            Log.LOGN(5, "  index=" + nArray[i][1] + " l#=" + nArray[i][0]);
        }
        packetStream3.send();
    }

    public void handleVariableTable(PacketStream packetStream) throws IOException {
        List list = null;
        MethodInfo methodInfo = null;
        int n = packetStream.readInt();
        Log.LOGN(3, "variable: class id = " + Integer.toHexString(n));
        int n2 = packetStream.readInt() - method_index_base;
        Log.LOGN(3, "variable: method id = " + Integer.toHexString(n2 + method_index_base));
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN(3, "Variabletable cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream2.send();
            return;
        }
        try {
            list = classFile.getVariableTableForMethodIndex(n2);
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassFileName());
            }
        }
        catch (Exception exception) {
            System.out.println("class " + classFile.getClassName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 20);
            packetStream3.send();
            return;
        }
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(methodInfo.getArgCount());
        if (list != null) {
            packetStream4.writeInt(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LocalVariable localVariable = (LocalVariable)iterator.next();
                packetStream4.writeLong(localVariable.getCodeIndex());
                packetStream4.writeString(localVariable.getName());
                packetStream4.writeString(this.getJNISignature(localVariable.getType()));
                packetStream4.writeInt(localVariable.getLength());
                packetStream4.writeInt(localVariable.getSlot());
            }
        } else {
            packetStream4.writeInt(0);
        }
        packetStream4.send();
    }

    private void handleByteCode(PacketStream packetStream) {
        MethodInfo methodInfo = null;
        Log.LOGN(1, "Method: Bytecodes");
        Object var7_3 = null;
        int n = packetStream.readInt();
        Log.LOGN(3, "class id=" + Integer.toHexString(n));
        int n2 = packetStream.readInt() - method_index_base;
        Log.LOGN(3, "method id=" + Integer.toHexString(n2 + method_index_base));
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN(3, "Bytecode cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 20);
            packetStream2.send();
            return;
        }
        try {
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassFileName());
            }
        }
        catch (Exception exception) {
            System.out.println(" class" + classFile.getClassFileName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 23);
            packetStream3.send();
            return;
        }
        byte[] byArray = methodInfo.getCodeAttribute().getByteCodes();
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(byArray.length);
        packetStream4.writeByteArray(byArray);
        packetStream4.send();
    }

    private String getJNISignature(String string) {
        int n;
        int n2 = n = string.length();
        String string2 = new String();
        Log.LOGN(6, "getJNISignature()  type == " + string);
        while ((n = string.lastIndexOf("[]", n)) != -1) {
            string2 = string2 + "[";
            n2 = n--;
        }
        String string3 = string.substring(0, n2);
        string2 = "int".equalsIgnoreCase(string3) ? string2 + "I" : ("boolean".equalsIgnoreCase(string3) ? string2 + "Z" : ("short".equalsIgnoreCase(string3) ? string2 + "S" : ("byte".equalsIgnoreCase(string3) ? string2 + "B" : ("char".equalsIgnoreCase(string3) ? string2 + "C" : ("long".equalsIgnoreCase(string3) ? string2 + "J" : ("float".equalsIgnoreCase(string3) ? string2 + "F" : ("double".equalsIgnoreCase(string3) ? string2 + "D" : string2 + "L" + string3.replace('.', '/') + ";")))))));
        return string2;
    }
}

