/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.mekeytool;

import com.sun.kvem.environment.KeepAliveConnection;
import com.sun.midp.mekeytool.MEKeyTool;
import com.sun.midp.mekeytool.UsageException;
import com.sun.midp.publickeystore.PublicKeyInfo;
import java.io.File;
import java.io.FileNotFoundException;

public class WTKMain
extends MEKeyTool {
    private static final String defaultAppDir = "appdb";
    private static final String defaultKeystoreFilename = "_main.ks";

    public static void main(String[] stringArray) {
        KeepAliveConnection keepAliveConnection = new KeepAliveConnection();
        stringArray = keepAliveConnection.processArgv(stringArray);
        keepAliveConnection.setCallback(KeepAliveConnection.CALLBACK_EXIT);
        keepAliveConnection.run();
        File file = new File(System.getProperty("kvem.home")).getAbsoluteFile();
        File file2 = new File(file, defaultAppDir);
        File file3 = new File(file2, defaultKeystoreFilename);
        if (stringArray.length == 0) {
            System.out.println("\n  Error: No command given");
            WTKMain.displayUsage();
            System.exit(-1);
        }
        if (stringArray[0].equals("-help")) {
            WTKMain.displayUsage();
            System.exit(0);
        }
        try {
            if (stringArray[0].equals("-import")) {
                WTKMain.importCommand(file3, stringArray);
                System.exit(0);
            }
            if (stringArray[0].equals("-delete")) {
                WTKMain.deleteCommand(file3, stringArray);
                System.exit(0);
            }
            if (stringArray[0].equals("-list")) {
                WTKMain.listCommand(file3, stringArray);
                System.exit(0);
            }
            throw new UsageException("  Invalid command: " + stringArray[0]);
        }
        catch (Exception exception) {
            System.out.println("\n  Error: " + exception.getMessage());
            if (exception instanceof UsageException) {
                WTKMain.displayUsage();
            }
            System.exit(-1);
            return;
        }
    }

    private static void displayUsage() {
        System.out.println("\n  keytool argument combinations:\n\n    -help\n    -import [-keystore <filename>]\n            [-storepass <password>] -alias <key alias> [-domain <domain>]\n    -list\n    -delete (-owner <owner name> | -number <key number>)\n\n  The default for -keystore is \"$HOME/.keystore\".\n");
    }

    private static void importCommand(File file, String[] stringArray) throws Exception {
        MEKeyTool mEKeyTool;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "untrusted";
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals("-storepass")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-domain")) {
                    string4 = stringArray[++i];
                    continue;
                }
                throw new UsageException("Invalid argument for import command: " + stringArray[i]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Missing value for " + stringArray[--i]);
            }
        }
        if (string == null) {
            string = System.getProperty("user.home") + File.separator + ".keystore";
        }
        if (string3 == null) {
            throw new Exception("J2SE key alias was not given");
        }
        try {
            mEKeyTool = new MEKeyTool(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            mEKeyTool = new MEKeyTool();
        }
        mEKeyTool.importKeyFromJcaKeystore(string, string2, string3, string4);
        mEKeyTool.saveKeystore(file);
    }

    private static void deleteCommand(File file, String[] stringArray) throws Exception {
        String string = null;
        int n = -1;
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals("-owner")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-number")) {
                    bl = true;
                    ++i;
                    try {
                        n = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new UsageException("Invalid number for the -number argument: " + stringArray[i]);
                    }
                }
                throw new UsageException("Invalid argument for the delete command: " + stringArray[i]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Missing value for " + stringArray[--i]);
            }
        }
        if (string == null && !bl) {
            throw new UsageException("Neither key -owner or -number was not given");
        }
        if (string != null && bl) {
            throw new UsageException("-owner and -number cannot be used together");
        }
        MEKeyTool mEKeyTool = new MEKeyTool(file);
        if (string != null) {
            if (!mEKeyTool.deleteKey(string)) {
                throw new UsageException("Key not found for: " + string);
            }
        } else {
            try {
                mEKeyTool.deleteKey(n - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Invalid number for the -number delete option: " + n);
            }
        }
        mEKeyTool.saveKeystore(file);
    }

    private static void listCommand(File file, String[] stringArray) throws Exception {
        int n;
        for (n = 1; n < stringArray.length; ++n) {
            try {
                if (!stringArray[n].equals("-MEkeystore")) {
                    throw new UsageException("Invalid argument for the list command: " + stringArray[n]);
                }
                file = new File(stringArray[++n]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Missing value for " + stringArray[--n]);
            }
        }
        MEKeyTool mEKeyTool = new MEKeyTool(file);
        PublicKeyInfo publicKeyInfo = mEKeyTool.getFirstKey();
        n = 1;
        while (publicKeyInfo != null) {
            System.out.println("Key " + Integer.toString(n));
            System.out.println(WTKMain.formatKeyInfo(publicKeyInfo));
            publicKeyInfo = mEKeyTool.getNextKey();
            ++n;
        }
        System.out.println("");
    }
}

