/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.mekeytool;

import java.io.UnsupportedEncodingException;

class TLV {
    static final int CONTEXT = 128;
    static final int CONSTRUCTED = 32;
    static final int EXPLICIT = 32;
    static final int ANY_STRING_TYPE = 0;
    static final int BOOLEAN_TYPE = 1;
    static final int INTEGER_TYPE = 2;
    static final int BITSTRING_TYPE = 3;
    static final int OCTETSTR_TYPE = 4;
    static final int NULL_TYPE = 5;
    static final int OID_TYPE = 6;
    static final int UTF8STR_TYPE = 12;
    static final int SEQUENCE_TYPE = 48;
    static final int SET_TYPE = 49;
    static final int PRINTSTR_TYPE = 19;
    static final int TELETEXSTR_TYPE = 20;
    static final int IA5STR_TYPE = 22;
    static final int UCT_TIME_TYPE = 23;
    static final int GEN_TIME_TYPE = 24;
    static final int UNIVSTR_TYPE = 28;
    static final int BMPSTR_TYPE = 30;
    static final int VERSION_TYPE = 160;
    static final int EXTENSIONS_TYPE = 163;
    static char[] hc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    int type;
    int length;
    int valueOffset;
    TLV child;
    TLV next;

    static boolean byteMatch(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4 || byArray.length < n + n2 || byArray2.length < n3 + n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i + n] == byArray2[i + n3]) continue;
            return false;
        }
        return true;
    }

    static String OIDtoString(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        int n3 = n + n2;
        int n4 = byArray[n++] & 0xFF;
        int n5 = n4 / 40;
        int n6 = n4 - n5 * 40;
        stringBuffer.append(n5);
        stringBuffer.append('.');
        stringBuffer.append(n6);
        n5 = 0;
        while (n < n3) {
            n5 <<= 7;
            if ((n4 = byArray[n++]) >= 0) {
                stringBuffer.append('.');
                stringBuffer.append(n5 += n4);
                n5 = 0;
                continue;
            }
            n5 += n4 & 0x7F;
        }
        return stringBuffer.toString();
    }

    static String hexEncode(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null || n2 == 0) {
            return "";
        }
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        char[] cArray = new char[n2 * 3];
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6 = byArray[n + n4] & 0xFF;
            cArray[n5++] = hc[n6 >>> 4];
            cArray[n5++] = hc[n6 & 0xF];
            if (++n4 >= n2) break;
            if (n4 == n3) {
                cArray[n5++] = 32;
                cArray[n5++] = 43;
                break;
            }
            cArray[n5++] = 58;
        }
        return new String(cArray, 0, n5);
    }

    TLV(byte[] byArray, int n) {
        int n2;
        int n3;
        boolean bl;
        this.type = byArray[n++] & 0xFF;
        boolean bl2 = bl = (this.type & 0x20) == 32;
        if ((this.type & 0x1F) == 31) {
            this.type = 0;
            while (true) {
                n3 = byArray[n++];
                this.type <<= 7;
                if (n3 >= 0) {
                    this.type += n3;
                    break;
                }
                this.type += (n3 &= 0x7F);
            }
        }
        if ((n2 = byArray[n++] & 0xFF) >= 128) {
            n3 = n2 - 128;
            if (n3 > 2) {
                throw new RuntimeException("TLV size to large");
            }
            n2 = 0;
            while (n3 > 0) {
                n2 = (n2 << 8) + (byArray[n++] & 0xFF);
                --n3;
            }
        }
        this.length = n2;
        this.valueOffset = n;
        if (bl) {
            n3 = n + this.length;
            TLV tLV = this.child = new TLV(byArray, n);
            while ((n = tLV.valueOffset + tLV.length) < n3) {
                tLV = tLV.next = new TLV(byArray, n);
            }
        }
    }

    void print(byte[] byArray) {
        this.print(byArray, 0);
    }

    private void print(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        if (this.child == null) {
            System.out.print("Type: 0x" + Integer.toHexString(this.type) + " length: " + this.length + " value: ");
            if (this.type == 19 || this.type == 20 || this.type == 12 || this.type == 22 || this.type == 28) {
                try {
                    System.out.print(new String(byArray, this.valueOffset, this.length, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (this.type == 6) {
                System.out.print(TLV.OIDtoString(byArray, this.valueOffset, this.length));
            } else {
                System.out.print(TLV.hexEncode(byArray, this.valueOffset, this.length, 14));
            }
            System.out.println("");
        } else {
            if (this.type == 49) {
                System.out.println("Set:");
            } else if (this.type == 160) {
                System.out.println("Version (explicit):");
            } else if (this.type == 163) {
                System.out.println("Extensions (explicit):");
            } else {
                System.out.println("Sequence:");
            }
            this.child.print(byArray, n + 1);
        }
        if (this.next != null) {
            this.next.print(byArray, n);
        }
    }
}

