/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.mekeytool;

import com.sun.midp.mekeytool.OutputStorage;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.PublicKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class PublicKeyStoreBuilderBase
extends PublicKeyStore {
    private Vector keyList = new Vector();

    public PublicKeyStoreBuilderBase() {
        this.initPublicKeyStore(this.keyList);
    }

    public PublicKeyStoreBuilderBase(InputStream inputStream) throws IOException {
        this.initPublicKeyStore(inputStream, this.keyList);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        OutputStorage outputStorage = new OutputStorage(outputStream);
        Enumeration enumeration = this.keyList.elements();
        while (enumeration.hasMoreElements()) {
            PublicKeyInfo publicKeyInfo = (PublicKeyInfo)enumeration.nextElement();
            this.putKeyInStorage(outputStorage, publicKeyInfo);
        }
    }

    public synchronized void addKey(PublicKeyInfo publicKeyInfo) {
        this.keyList.addElement(publicKeyInfo);
    }

    public synchronized void updateKey(int n, PublicKeyInfo publicKeyInfo) {
        PublicKeyInfo publicKeyInfo2 = this.getKey(n);
        publicKeyInfo.setDomain(publicKeyInfo2.getDomain());
        this.keyList.setElementAt(publicKeyInfo, n);
    }

    public void deleteKey(int n) {
        this.keyList.removeElementAt(n);
    }

    private void putKeyInStorage(OutputStorage outputStorage, PublicKeyInfo publicKeyInfo) throws IOException {
        outputStorage.writeValue((byte)1, publicKeyInfo.getOwner());
        outputStorage.writeValue((byte)2, publicKeyInfo.getNotBefore());
        outputStorage.writeValue((byte)3, publicKeyInfo.getNotAfter());
        outputStorage.writeValue((byte)4, publicKeyInfo.getModulus());
        outputStorage.writeValue((byte)5, publicKeyInfo.getExponent());
        outputStorage.writeValue((byte)6, publicKeyInfo.getDomain());
    }
}

