/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.mekeytool;

import com.sun.midp.mekeytool.PublicKeyStoreBuilderBase;
import com.sun.midp.mekeytool.TLV;
import com.sun.midp.mekeytool.UsageException;
import com.sun.midp.publickeystore.PublicKeyInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Vector;

public class MEKeyTool {
    private static final String defaultAppDir = "appdb";
    private static final String defaultKeystoreFilename = "_main.ks";
    private static final String[] AttrLabel = new String[]{null, null, null, "CN", "SN", null, "C", "L", "ST", "STREET", "O", "OU"};
    private static final String EMAIL_ATTR_LABEL = "EmailAddress";
    private static final byte[] EMAIL_ATTR_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    private PublicKeyStoreBuilderBase keystore;
    private int nextKeyToGet;

    public static void main(String[] stringArray) {
        File file = null;
        if (stringArray.length == 0) {
            System.out.println("\n  Error: No command given");
            MEKeyTool.displayUsage();
            System.exit(-1);
        }
        if (stringArray[0].equals("-help")) {
            MEKeyTool.displayUsage();
            System.exit(0);
        }
        file = new File(defaultAppDir, defaultKeystoreFilename);
        try {
            if (stringArray[0].equals("-import")) {
                MEKeyTool.importCommand(file, stringArray);
                System.exit(0);
            }
            if (stringArray[0].equals("-delete")) {
                MEKeyTool.deleteCommand(file, stringArray);
                System.exit(0);
            }
            if (stringArray[0].equals("-list")) {
                MEKeyTool.listCommand(file, stringArray);
                System.exit(0);
            }
            throw new UsageException("  Invalid command: " + stringArray[0]);
        }
        catch (Exception exception) {
            System.out.println("\n  Error: " + exception.getMessage());
            if (exception instanceof UsageException) {
                MEKeyTool.displayUsage();
            }
            System.exit(-1);
            return;
        }
    }

    private static void displayUsage() {
        System.out.println("\n  MEKeyTool argument combinations:\n\n    -help\n    -import [-MEkeystore <filename>] [-keystore <filename>]\n            [-storepass <password>] -alias <key alias> [-domain <domain>]\n    -list [-MEkeystore <filename>]\n    -delete [-MEkeystore <filename>]\n            (-owner <owner name> | -number <key number>)\n\n  The default for -MEkeystore is \"appdb/_main.ks\".\n  The default for -keystore is \"$HOME/.keystore\".\n");
    }

    private static void importCommand(File file, String[] stringArray) throws Exception {
        MEKeyTool mEKeyTool;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "untrusted";
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals("-MEkeystore")) {
                    file = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-keystore")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-storepass")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-domain")) {
                    string4 = stringArray[++i];
                    continue;
                }
                throw new UsageException("Invalid argument for import command: " + stringArray[i]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Missing value for " + stringArray[--i]);
            }
        }
        if (string == null) {
            string = System.getProperty("user.home") + File.separator + ".keystore";
        }
        if (string3 == null) {
            throw new Exception("J2SE key alias was not given");
        }
        try {
            mEKeyTool = new MEKeyTool(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            mEKeyTool = new MEKeyTool();
        }
        mEKeyTool.importKeyFromJcaKeystore(string, string2, string3, string4);
        mEKeyTool.saveKeystore(file);
    }

    private static void deleteCommand(File file, String[] stringArray) throws Exception {
        String string = null;
        int n = -1;
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals("-MEkeystore")) {
                    file = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-owner")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-number")) {
                    bl = true;
                    ++i;
                    try {
                        n = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new UsageException("Invalid number for the -number argument: " + stringArray[i]);
                    }
                }
                throw new UsageException("Invalid argument for the delete command: " + stringArray[i]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Missing value for " + stringArray[--i]);
            }
        }
        if (string == null && !bl) {
            throw new UsageException("Neither key -owner or -number was not given");
        }
        if (string != null && bl) {
            throw new UsageException("-owner and -number cannot be used together");
        }
        MEKeyTool mEKeyTool = new MEKeyTool(file);
        if (string != null) {
            if (!mEKeyTool.deleteKey(string)) {
                throw new UsageException("Key not found for: " + string);
            }
        } else {
            try {
                mEKeyTool.deleteKey(n - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Invalid number for the -number delete option: " + n);
            }
        }
        mEKeyTool.saveKeystore(file);
    }

    private static void listCommand(File file, String[] stringArray) throws Exception {
        int n;
        for (n = 1; n < stringArray.length; ++n) {
            try {
                if (!stringArray[n].equals("-MEkeystore")) {
                    throw new UsageException("Invalid argument for the list command: " + stringArray[n]);
                }
                file = new File(stringArray[++n]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UsageException("Missing value for " + stringArray[--n]);
            }
        }
        MEKeyTool mEKeyTool = new MEKeyTool(file);
        PublicKeyInfo publicKeyInfo = mEKeyTool.getFirstKey();
        n = 1;
        while (publicKeyInfo != null) {
            System.out.println("Key " + Integer.toString(n));
            System.out.println(MEKeyTool.formatKeyInfo(publicKeyInfo));
            publicKeyInfo = mEKeyTool.getNextKey();
            ++n;
        }
        System.out.println("");
    }

    public MEKeyTool() {
        this.keystore = new PublicKeyStoreBuilderBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MEKeyTool(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        try {
            this.keystore = new PublicKeyStoreBuilderBase(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MEKeyTool(File file) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.keystore = new PublicKeyStoreBuilderBase(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
    }

    public MEKeyTool(InputStream inputStream) throws IOException {
        this.keystore = new PublicKeyStoreBuilderBase(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importKeyFromJcaKeystore(String string, String string2, String string3, String string4) throws IOException, GeneralSecurityException {
        KeyStore keyStore;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (string2 == null) {
                keyStore.load(fileInputStream, null);
            } else {
                keyStore.load(fileInputStream, string2.toCharArray());
            }
        }
        finally {
            fileInputStream.close();
        }
        this.importKeyFromJcaKeystore(keyStore, string3, string4);
    }

    public void importKeyFromJcaKeystore(KeyStore keyStore, String string, String string2) throws IOException, GeneralSecurityException {
        int n;
        int n2;
        RSAPublicKey rSAPublicKey;
        String string3;
        X509Certificate x509Certificate;
        try {
            x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        }
        catch (ClassCastException classCastException) {
            throw new CertificateException("Certificate not X.509 type");
        }
        if (x509Certificate == null) {
            throw new CertificateException("Certificate not found");
        }
        byte[] byArray = x509Certificate.getTBSCertificate();
        TLV tLV = new TLV(byArray, 0);
        try {
            TLV tLV2 = tLV.child;
            if (tLV2.type == 160) {
                tLV2 = tLV2.next;
            }
            tLV2 = tLV2.next;
            tLV2 = tLV2.next;
            tLV2 = tLV2.next;
            tLV2 = tLV2.next;
            string3 = this.parseDN(byArray, tLV2);
        }
        catch (NullPointerException nullPointerException) {
            throw new CertificateException("TBSCertificate corrupt 1");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CertificateException("TBSCertificate corrupt 2");
        }
        long l = x509Certificate.getNotBefore().getTime();
        long l2 = x509Certificate.getNotAfter().getTime();
        try {
            rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Key in certificate is not an RSA key");
        }
        byte[] byArray2 = rSAPublicKey.getModulus().toByteArray();
        for (n2 = 0; n2 < byArray2.length && byArray2[n2] == 0; ++n2) {
        }
        int n3 = byArray2.length - n2;
        n3 = (n3 + 7) / 8 * 8;
        byte[] byArray3 = new byte[n3];
        int n4 = byArray2.length - 1;
        for (n = n3 - 1; n4 >= 0 && n >= 0; --n4, --n) {
            byArray3[n] = byArray2[n4];
        }
        byte[] byArray4 = rSAPublicKey.getPublicExponent().toByteArray();
        Vector vector = this.keystore.findKeys(string3);
        if (vector != null) {
            boolean bl = false;
            block9: for (int i = 0; !bl && i < vector.size(); ++i) {
                byte[] byArray5;
                PublicKeyInfo publicKeyInfo = (PublicKeyInfo)vector.elementAt(i);
                if (!publicKeyInfo.getOwner().equals(string3) || byArray3.length != (byArray5 = publicKeyInfo.getModulus()).length) continue;
                bl = true;
                for (int j = 0; n < byArray3.length && j < byArray5.length; ++j) {
                    if (byArray3[j] == byArray5[j]) continue;
                    bl = false;
                    continue block9;
                }
            }
            if (bl) {
                throw new CertificateException("Owner already has this key in the ME keystore");
            }
        }
        this.keystore.addKey(new PublicKeyInfo(string3, l, l2, byArray3, byArray4, string2));
    }

    public boolean deleteKey(String string) {
        for (int i = 0; i < this.keystore.numberOfKeys(); ++i) {
            PublicKeyInfo publicKeyInfo = this.keystore.getKey(i);
            if (!publicKeyInfo.getOwner().equals(string)) continue;
            this.keystore.deleteKey(i);
            return true;
        }
        return false;
    }

    public void deleteKey(int n) {
        this.keystore.deleteKey(n);
    }

    protected PublicKeyInfo getFirstKey() {
        this.nextKeyToGet = 0;
        return this.getNextKey();
    }

    protected PublicKeyInfo getNextKey() {
        PublicKeyInfo publicKeyInfo;
        try {
            publicKeyInfo = this.keystore.getKey(this.nextKeyToGet);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        ++this.nextKeyToGet;
        return publicKeyInfo;
    }

    public void saveKeystore(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.keystore.serialize(fileOutputStream);
        fileOutputStream.close();
    }

    public PublicKeyStoreBuilderBase getKeystore() {
        return this.keystore;
    }

    public static String formatKeyInfo(PublicKeyInfo publicKeyInfo) {
        return "  Owner: " + publicKeyInfo.getOwner() + "\n  Valid from " + new Date(publicKeyInfo.getNotBefore()).toString() + " to " + new Date(publicKeyInfo.getNotAfter()).toString() + "\n  Security Domain: " + publicKeyInfo.getDomain();
    }

    private String parseDN(byte[] byArray, TLV tLV) {
        StringBuffer stringBuffer = new StringBuffer(256);
        TLV tLV2 = tLV.child;
        while (tLV2 != null) {
            if (tLV2 != tLV.child) {
                stringBuffer.append(";");
            }
            TLV tLV3 = tLV2.child.child;
            if (tLV3.length == 3 && byArray[tLV3.valueOffset] == 85 && byArray[tLV3.valueOffset + 1] == 4) {
                int n = byArray[tLV3.valueOffset + 2] & 0xFF;
                if (n < AttrLabel.length && AttrLabel[n] != null) {
                    stringBuffer.append(AttrLabel[n]);
                } else {
                    stringBuffer.append(TLV.hexEncode(byArray, tLV3.valueOffset, tLV3.length, -1));
                }
            } else if (TLV.byteMatch(byArray, tLV3.valueOffset, tLV3.length, EMAIL_ATTR_OID, 0, EMAIL_ATTR_OID.length)) {
                stringBuffer.append(EMAIL_ATTR_LABEL);
            } else {
                stringBuffer.append(TLV.hexEncode(byArray, tLV3.valueOffset, tLV3.length, -1));
            }
            stringBuffer.append("=");
            TLV tLV4 = tLV2.child.child.next;
            if (tLV4.type == 19 || tLV4.type == 20 || tLV4.type == 12 || tLV4.type == 22 || tLV4.type == 28) {
                try {
                    stringBuffer.append(new String(byArray, tLV4.valueOffset, tLV4.length, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException.toString());
                }
            } else {
                stringBuffer.append(TLV.hexEncode(byArray, tLV4.valueOffset, tLV4.length, -1));
            }
            tLV2 = tLV2.next;
        }
        return stringBuffer.toString();
    }
}

