/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import com.sun.midp.rms.RecordStoreFile;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordEnumerationImpl;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordStore {
    public static final int AUTHMODE_PRIVATE = 0;
    public static final int AUTHMODE_ANY = 1;
    private static final int AUTHMODE_ANY_RO = 2;
    private static final byte[] DB_INIT = new byte[]{109, 105, 100, 112, 45, 114, 109, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int SIGNATURE_LENGTH = 8;
    private static final int DB_RECORD_HEADER_LENGTH = 16;
    private static final int DB_BLOCK_SIZE = 16;
    private static final int DB_COMPACTBUFFER_SIZE = 64;
    private static Vector dbCache = new Vector(3);
    private static final Object dbCacheLock = new Object();
    private static RecordStoreFile rootRSF = new RecordStoreFile();
    private String recordStoreName;
    private String uniqueIdPath;
    private int opencount;
    private RecordStoreFile dbraf;
    Object rsLock;
    private Vector recordListener;
    private RecordHeaderCache recHeadCache;
    private static int CACHE_SIZE = 8;
    private static byte[] recHeadBuf = new byte[16];
    private int dbNextRecordID = 1;
    private int dbVersion;
    private int dbAuthMode;
    private int dbNumLiveRecords;
    private long dbLastModified;
    private int dbFirstRecordOffset;
    private int dbFirstFreeBlockOffset;
    private int dbDataStart = 48;
    private int dbDataEnd = 48;
    private static byte[] dbState = new byte[DB_INIT.length];
    private static final int RS_SIGNATURE = 0;
    private static final int RS_NUM_LIVE = 8;
    private static final int RS_AUTHMODE = 12;
    private static final int RS_VERSION = 16;
    private static final int RS_NEXT_ID = 20;
    private static final int RS_REC_START = 24;
    private static final int RS_FREE_START = 28;
    private static final int RS_LAST_MODIFIED = 32;
    private static final int RS_DATA_START = 40;
    private static final int RS_DATA_END = 44;
    private static final int bytesPer100millis = RecordStore.getSlowingFactor() * 200;
    private static final int latency = (5 - RecordStore.getSlowingFactor()) * 10;
    private static int accessCount = 0;
    private static long lastTime = 0L;
    private static int lastRead = 0;

    private RecordStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecordStore(String recordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        String uidPath = rootRSF.getUniqueIdPath(recordStoreName);
        Object object = dbCacheLock;
        synchronized (object) {
            for (int n = 0; n < dbCache.size(); ++n) {
                RecordStore db = (RecordStore)dbCache.elementAt(n);
                if (!db.uniqueIdPath.equals(uidPath)) continue;
                throw new RecordStoreException("deleteRecordStore error: record store is still open");
            }
            if (rootRSF.exists(uidPath)) {
                boolean success = rootRSF.deleteFile(recordStoreName);
                if (!success) {
                    throw new RecordStoreException("deleteRecordStore failed");
                }
            } else {
                throw new RecordStoreNotFoundException("deleteRecordStore error: file not found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        String uidPath = rootRSF.getUniqueIdPath(recordStoreName);
        Object object = dbCacheLock;
        synchronized (object) {
            RecordStore db;
            if (recordStoreName.length() > 32 || recordStoreName.length() == 0) {
                throw new IllegalArgumentException();
            }
            for (int n = 0; n < dbCache.size(); ++n) {
                db = (RecordStore)dbCache.elementAt(n);
                if (!db.uniqueIdPath.equals(uidPath)) continue;
                ++db.opencount;
                return db;
            }
            db = new RecordStore(uidPath, recordStoreName, createIfNecessary);
            db.opencount = 1;
            dbCache.addElement(db);
            return db;
        }
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary, int authmode, boolean writable) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        RecordStore rs = RecordStore.openRecordStore(recordStoreName, createIfNecessary);
        rs.setMode(authmode, writable);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String recordStoreName, String vendorName, String suiteName) throws RecordStoreException, RecordStoreNotFoundException {
        if (vendorName == null || suiteName == null) {
            throw new IllegalArgumentException("vendorName and suiteName must be non null");
        }
        Object object = dbCacheLock;
        synchronized (object) {
            RecordStore db;
            if (recordStoreName.length() > 32 || recordStoreName.length() == 0) {
                throw new IllegalArgumentException();
            }
            String uidPath = rootRSF.getUniqueIdPath(vendorName, suiteName, recordStoreName);
            for (int n = 0; n < dbCache.size(); ++n) {
                db = (RecordStore)dbCache.elementAt(n);
                if (!db.uniqueIdPath.equals(uidPath)) continue;
                if (!db.checkOwner() && db.dbAuthMode == 0) {
                    throw new SecurityException();
                }
                ++db.opencount;
                return db;
            }
            db = new RecordStore(uidPath, recordStoreName, false);
            db.opencount = 1;
            dbCache.addElement(db);
            if (!db.checkOwner() && db.dbAuthMode == 0) {
                db.closeRecordStore();
                throw new SecurityException();
            }
            return db;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int authmode, boolean writable) throws RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            if (!this.checkOwner()) {
                throw new SecurityException();
            }
            if (authmode != 0 && authmode != 1) {
                throw new IllegalArgumentException();
            }
            this.dbAuthMode = authmode;
            if (authmode == 1 && !writable) {
                this.dbAuthMode = 2;
            }
            this.storeDBState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            Object object2 = dbCacheLock;
            synchronized (object2) {
                this.checkOpen();
                RecordStore db = null;
                for (int n = 0; n < dbCache.size(); ++n) {
                    db = (RecordStore)dbCache.elementAt(n);
                    if (db != this) continue;
                    --db.opencount;
                    break;
                }
                if (db.opencount <= 0) {
                    dbCache.removeElement(db);
                    try {
                        if (!this.recordListener.isEmpty()) {
                            this.recordListener.removeAllElements();
                        }
                        if (this.dbFirstFreeBlockOffset != 0) {
                            this.compactRecords();
                            this.dbraf.truncate(this.dbDataEnd);
                        }
                        this.dbraf.close();
                    }
                    catch (IOException ioe) {
                        throw new RecordStoreException("error closing .db file");
                    }
                    finally {
                        this.dbraf = null;
                        this.recHeadCache = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listRecordStores() {
        Object object = dbCacheLock;
        synchronized (object) {
            String[] returnstrings = rootRSF.listRecordStores();
            return returnstrings;
        }
    }

    public String getName() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.recordStoreName;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbVersion;
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbNumLiveRecords;
    }

    public int getSize() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbDataEnd;
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        this.checkOpen();
        int rv = this.dbraf.spaceAvailable() - 16 - 16;
        return rv < 0 ? 0 : rv;
    }

    public long getLastModified() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbLastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordListener(RecordListener listener) {
        Object object = this.rsLock;
        synchronized (object) {
            if (!this.recordListener.contains(listener)) {
                this.recordListener.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecordListener(RecordListener listener) {
        Object object = this.rsLock;
        synchronized (object) {
            this.recordListener.removeElement(listener);
        }
    }

    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        this.checkOpen();
        return this.dbNextRecordID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRecord(byte[] data, int offset, int numBytes) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            if (!this.checkWritable()) {
                throw new SecurityException();
            }
            if (data == null && numBytes > 0) {
                throw new NullPointerException("illegal arguments: null data,  numBytes > 0");
            }
            int id = this.dbNextRecordID++;
            RecordHeader rh = this.allocateNewRecordStorage(id, numBytes);
            try {
                if (data != null) {
                    rh.write(data, offset);
                }
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error writing new record data");
            }
            ++this.dbNumLiveRecords;
            ++this.dbVersion;
            this.storeDBState();
            this.notifyRecordAddedListeners(id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            if (!this.checkWritable()) {
                throw new SecurityException();
            }
            RecordHeader rh = null;
            try {
                rh = this.findRecord(recordId, false);
                this.freeRecord(rh);
                this.recHeadCache.invalidate(rh.id);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error updating file after record deletion");
            }
            --this.dbNumLiveRecords;
            ++this.dbVersion;
            this.storeDBState();
            this.notifyRecordDeletedListeners(recordId);
        }
    }

    public int getRecordSize(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            try {
                RecordHeader rh = this.findRecord(recordId, true);
                return rh.dataLenOrNextFree;
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error reading record data");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecord(int recordId, byte[] buffer, int offset) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            RecordHeader rh;
            this.checkOpen();
            try {
                rh = this.findRecord(recordId, true);
                rh.read(buffer, offset);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error reading record data");
            }
            return rh.dataLenOrNextFree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            boolean size = false;
            byte[] data = null;
            try {
                RecordHeader rh = this.findRecord(recordId, true);
                if (rh.dataLenOrNextFree == 0) {
                    return null;
                }
                data = new byte[rh.dataLenOrNextFree];
                rh.read(data, 0);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error reading record data");
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setRecord(int recordId, byte[] newData, int offset, int numBytes) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        var5_5 = this.rsLock;
        synchronized (var5_5) {
            this.checkOpen();
            if (!this.checkWritable()) {
                throw new SecurityException();
            }
            if (newData == null && numBytes > 0) {
                throw new NullPointerException();
            }
            rh = null;
            newrh = null;
            try {
                rh = this.findRecord(recordId, false);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error finding record data");
            }
            if (numBytes <= rh.blockSize - 16) {
                allocSize = this.getAllocSize(numBytes);
                if (rh.blockSize - allocSize >= 32) {
                    this.splitRecord(rh, allocSize);
                }
                rh.dataLenOrNextFree = numBytes;
                try {
                    rh.store();
                    this.recHeadCache.insert(rh);
                    if (newData == null) ** GOTO lbl37
                    rh.write(newData, offset);
                }
                catch (IOException ioe) {
                    throw new RecordStoreException("error writing record data");
                }
            } else {
                this.freeRecord(rh);
                newrh = this.allocateNewRecordStorage(recordId, numBytes);
                try {
                    if (newData != null) {
                        newrh.write(newData, offset);
                    }
                }
                catch (IOException ioe) {
                    throw new RecordStoreException("error moving record data");
                }
            }
lbl37:
            // 3 sources

            ++this.dbVersion;
            this.storeDBState();
            this.notifyRecordChangedListeners(recordId);
        }
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) throws RecordStoreNotOpenException {
        this.checkOpen();
        return new RecordEnumerationImpl(this, filter, comparator, keepUpdated);
    }

    private RecordHeader findRecord(int recordId, boolean addToCache) throws InvalidRecordIDException, IOException {
        int cur_offset = this.dbFirstRecordOffset;
        if (cur_offset == 0) {
            throw new InvalidRecordIDException();
        }
        RecordHeader rh = this.recHeadCache.get(recordId);
        if (rh != null) {
            return rh;
        }
        rh = new RecordHeader();
        while (cur_offset != 0) {
            rh.load(cur_offset);
            if (rh.id == recordId) break;
            cur_offset = rh.nextOffset;
        }
        if (cur_offset == 0) {
            throw new InvalidRecordIDException();
        }
        if (addToCache) {
            this.recHeadCache.insert(rh);
        }
        return rh;
    }

    private int getAllocSize(int numBytes) {
        int rv = 16 + numBytes;
        int pad = 16 - rv % 16;
        if (pad != 16) {
            rv += pad;
        }
        return rv;
    }

    private RecordHeader allocateNewRecordStorage(int id, int dataSize) throws RecordStoreException, RecordStoreFullException {
        int allocSize = this.getAllocSize(dataSize);
        boolean foundBlock = false;
        RecordHeader block = new RecordHeader();
        try {
            int offset = this.dbFirstFreeBlockOffset;
            while (offset != 0) {
                block.load(offset);
                if (block.blockSize >= allocSize) {
                    foundBlock = true;
                    break;
                }
                offset = block.dataLenOrNextFree;
            }
        }
        catch (IOException ioe) {
            throw new RecordStoreException("error finding first fit block");
        }
        if (!foundBlock) {
            if (this.dbraf.spaceAvailable() < allocSize) {
                throw new RecordStoreFullException();
            }
            block = new RecordHeader(this.dbDataEnd, id, this.dbFirstRecordOffset, allocSize, dataSize);
            try {
                block.store();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error writing new record data");
            }
            this.dbFirstRecordOffset = this.dbDataEnd;
            this.dbDataEnd += allocSize;
        } else {
            if (block.id != -1) {
                throw new RecordStoreException("ALLOC ERR " + block.id + " is not a free block!");
            }
            this.removeFreeBlock(block);
            block.id = id;
            if (block.blockSize - allocSize >= 32) {
                this.splitRecord(block, allocSize);
            }
            block.dataLenOrNextFree = dataSize;
            try {
                block.store();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error writing free block after alloc");
            }
        }
        this.recHeadCache.insert(block);
        return block;
    }

    private void splitRecord(RecordHeader recHead, int allocSize) throws RecordStoreException {
        int extraSpace = recHead.blockSize - allocSize;
        int oldBlockSize = recHead.blockSize;
        recHead.blockSize = allocSize;
        if (recHead.offset != this.dbFirstRecordOffset) {
            int fboffset = recHead.offset + allocSize;
            RecordHeader newfb = new RecordHeader(fboffset, -1, recHead.offset, extraSpace, 0);
            try {
                this.freeRecord(newfb);
                RecordHeader prh = new RecordHeader(recHead.offset + oldBlockSize);
                prh.nextOffset = fboffset;
                prh.store();
                this.recHeadCache.invalidate(prh.id);
                this.storeDBState();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("splitRecord error");
            }
        } else {
            this.dbDataEnd = recHead.offset + recHead.blockSize;
        }
    }

    private void freeRecord(RecordHeader rh) throws RecordStoreException {
        if (rh.offset == this.dbFirstRecordOffset) {
            this.dbFirstRecordOffset = rh.nextOffset;
            this.dbDataEnd = rh.offset;
        } else {
            rh.id = -1;
            rh.dataLenOrNextFree = this.dbFirstFreeBlockOffset;
            this.dbFirstFreeBlockOffset = rh.offset;
            try {
                rh.store();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("free record failed");
            }
        }
    }

    private void removeFreeBlock(RecordHeader blockToFree) throws RecordStoreException {
        RecordHeader block = new RecordHeader();
        RecordHeader prev = new RecordHeader();
        RecordHeader tmp = null;
        try {
            int offset = this.dbFirstFreeBlockOffset;
            while (offset != 0) {
                block.load(offset);
                if (block.offset == blockToFree.offset) {
                    if (block.id != -1) {
                        throw new RecordStoreException("removeFreeBlock id is not -1");
                    }
                    if (prev.offset == 0) {
                        this.dbFirstFreeBlockOffset = block.dataLenOrNextFree;
                    } else {
                        prev.dataLenOrNextFree = block.dataLenOrNextFree;
                        prev.store();
                    }
                }
                offset = block.dataLenOrNextFree;
                tmp = prev;
                prev = block;
                block = tmp;
            }
        }
        catch (IOException ioe) {
            throw new RecordStoreException("removeFreeBlock block not found");
        }
    }

    private void storeDBState() throws RecordStoreException {
        try {
            this.dbLastModified = System.currentTimeMillis();
            RecordStore.putInt(this.dbNumLiveRecords, dbState, 8);
            RecordStore.putInt(this.dbAuthMode, dbState, 12);
            RecordStore.putInt(this.dbVersion, dbState, 16);
            RecordStore.putInt(this.dbNextRecordID, dbState, 20);
            RecordStore.putInt(this.dbFirstRecordOffset, dbState, 24);
            RecordStore.putInt(this.dbFirstFreeBlockOffset, dbState, 28);
            RecordStore.putLong(this.dbLastModified, dbState, 32);
            RecordStore.putInt(this.dbDataStart, dbState, 40);
            RecordStore.putInt(this.dbDataEnd, dbState, 44);
            this.dbraf.seek(8);
            int numbytes = DB_INIT.length - 8;
            this.dbraf.write(dbState, 8, numbytes);
        }
        catch (IOException ioe) {
            throw new RecordStoreException("error writing record store attributes");
        }
    }

    boolean isOpen() {
        return this.dbraf != null;
    }

    private void checkOpen() throws RecordStoreNotOpenException {
        if (this.dbraf == null) {
            throw new RecordStoreNotOpenException();
        }
    }

    private void notifyRecordChangedListeners(int recordId) {
        for (int i = 0; i < this.recordListener.size(); ++i) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordChanged(this, recordId);
        }
    }

    private void notifyRecordAddedListeners(int recordId) {
        for (int i = 0; i < this.recordListener.size(); ++i) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordAdded(this, recordId);
        }
    }

    private void notifyRecordDeletedListeners(int recordId) {
        for (int i = 0; i < this.recordListener.size(); ++i) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordDeleted(this, recordId);
        }
    }

    static int getInt(byte[] data, int offset) {
        int r = data[offset++];
        r = r << 8 | data[offset++] & 0xFF;
        r = r << 8 | data[offset++] & 0xFF;
        r = r << 8 | data[offset++] & 0xFF;
        return r;
    }

    static long getLong(byte[] data, int offset) {
        long r = data[offset++];
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        return r;
    }

    static int putInt(int i, byte[] data, int offset) {
        data[offset++] = (byte)(i >> 24 & 0xFF);
        data[offset++] = (byte)(i >> 16 & 0xFF);
        data[offset++] = (byte)(i >> 8 & 0xFF);
        data[offset] = (byte)(i & 0xFF);
        return 4;
    }

    static int putLong(long l, byte[] data, int offset) {
        data[offset++] = (byte)(l >> 56 & 0xFFL);
        data[offset++] = (byte)(l >> 48 & 0xFFL);
        data[offset++] = (byte)(l >> 40 & 0xFFL);
        data[offset++] = (byte)(l >> 32 & 0xFFL);
        data[offset++] = (byte)(l >> 24 & 0xFFL);
        data[offset++] = (byte)(l >> 16 & 0xFFL);
        data[offset++] = (byte)(l >> 8 & 0xFFL);
        data[offset] = (byte)(l & 0xFFL);
        return 8;
    }

    int[] getRecordIDs() {
        if (this.dbraf == null) {
            return null;
        }
        int index = 0;
        int[] tmp = new int[this.dbNumLiveRecords];
        int offset = this.dbFirstRecordOffset;
        RecordHeader rh = new RecordHeader();
        try {
            while (offset != 0) {
                rh.load(offset);
                if (rh.id > 0) {
                    tmp[index++] = rh.id;
                }
                offset = rh.nextOffset;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return tmp;
    }

    private void compactRecords() throws RecordStoreNotOpenException, RecordStoreException {
        int offset = this.dbDataStart;
        int target = 0;
        byte[] chunkBuffer = new byte[64];
        RecordHeader rh = new RecordHeader();
        int prevRec = 0;
        while (offset < this.dbDataEnd) {
            try {
                rh.load(offset);
            }
            catch (IOException ioe) {
                System.out.println("Unexpected IOException in CompactRS!");
            }
            if (rh.id == -1) {
                if (target == 0) {
                    target = offset;
                }
                offset += rh.blockSize;
                continue;
            }
            if (target == 0) {
                prevRec = offset;
                offset += rh.blockSize;
                continue;
            }
            int old_offset = target;
            rh.offset = target;
            rh.nextOffset = prevRec;
            try {
                int numToMove;
                rh.store();
                offset += 16;
                target += 16;
                for (int bytesLeft = rh.blockSize - 16; bytesLeft > 0; bytesLeft -= numToMove) {
                    numToMove = bytesLeft < 64 ? bytesLeft : 64;
                    this.dbraf.seek(offset);
                    this.dbraf.read(chunkBuffer, 0, numToMove);
                    this.dbraf.seek(target);
                    this.dbraf.write(chunkBuffer, 0, numToMove);
                    offset += numToMove;
                    target += numToMove;
                }
            }
            catch (IOException ioe) {
                System.out.println("Unexpected IOException in CompactRS!");
            }
            prevRec = old_offset;
        }
        if (rh.offset != 0) {
            this.dbDataEnd = rh.offset + rh.blockSize;
        }
        this.dbFirstRecordOffset = rh.offset;
        this.dbFirstFreeBlockOffset = 0;
        this.storeDBState();
    }

    static synchronized int getBytesQuota(int request) {
        if (bytesPer100millis == 0) {
            return request;
        }
        int granted = request > bytesPer100millis ? bytesPer100millis : request;
        try {
            Thread.sleep(100 * granted / bytesPer100millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        lastRead += granted;
        return granted;
    }

    static synchronized void addLatency() {
        if (latency == 50) {
            return;
        }
        long startTime = System.currentTimeMillis() / 1000L;
        if (startTime != lastTime) {
            accessCount = 0;
            lastTime = System.currentTimeMillis() / 1000L;
        } else if (++accessCount >= 5) {
            accessCount = 0;
            try {
                Thread.sleep(latency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordStore(String uidPath, String recordStoreName, boolean create) throws RecordStoreException, RecordStoreNotFoundException {
        int space;
        this.recordStoreName = recordStoreName;
        this.uniqueIdPath = uidPath;
        this.recHeadCache = new RecordHeaderCache(CACHE_SIZE);
        this.rsLock = new Object();
        this.recordListener = new Vector(3);
        boolean exists = rootRSF.exists(uidPath);
        if (!create && !exists) {
            throw new RecordStoreNotFoundException("cannot find record store file");
        }
        if (create && !exists && (space = rootRSF.spaceAvailable()) - DB_INIT.length < 0) {
            throw new RecordStoreFullException();
        }
        try {
            this.dbraf = rootRSF.newRecordStoreFile(uidPath);
            if (create && !exists) {
                this.dbraf.seek(0);
                RecordStore.putLong(System.currentTimeMillis(), DB_INIT, 32);
                RecordStore.putInt(48, DB_INIT, 40);
                RecordStore.putInt(48, DB_INIT, 44);
                this.dbraf.write(DB_INIT);
            } else {
                byte[] buf = new byte[DB_INIT.length];
                this.dbraf.seek(0);
                this.dbraf.read(buf);
                for (int i = 0; i < 8; ++i) {
                    if (buf[i] == DB_INIT[i]) continue;
                    throw new RecordStoreException("invalid record store contents");
                }
                this.dbNumLiveRecords = RecordStore.getInt(buf, 8);
                this.dbVersion = RecordStore.getInt(buf, 16);
                this.dbAuthMode = RecordStore.getInt(buf, 12);
                this.dbNextRecordID = RecordStore.getInt(buf, 20);
                this.dbFirstRecordOffset = RecordStore.getInt(buf, 24);
                this.dbFirstFreeBlockOffset = RecordStore.getInt(buf, 28);
                this.dbLastModified = RecordStore.getLong(buf, 32);
                this.dbDataStart = RecordStore.getInt(buf, 40);
                this.dbDataEnd = RecordStore.getInt(buf, 44);
            }
        }
        catch (IOException ioe) {
            try {
                if (this.dbraf != null) {
                    this.dbraf.close();
                }
            }
            catch (IOException ioe2) {
            }
            finally {
                this.dbraf = null;
            }
            throw new RecordStoreException("error opening record store file");
        }
    }

    private boolean checkOwner() {
        String rsfUid;
        String myUid = this.dbraf.getUniqueIdPath(this.recordStoreName);
        return myUid.equals(rsfUid = this.dbraf.getUniqueIdPath());
    }

    private boolean checkWritable() {
        if (this.checkOwner()) {
            return true;
        }
        return this.dbAuthMode == 1;
    }

    private static native int getSlowingFactor();

    private class RecordHeaderCache {
        private RecordHeader[] mCache;

        RecordHeaderCache(int size) {
            this.mCache = new RecordHeader[size];
        }

        RecordHeader get(int rec_id) {
            int idx = rec_id % this.mCache.length;
            RecordHeader rh = this.mCache[idx];
            if (this.mCache[idx] != null && this.mCache[idx].id != rec_id) {
                return null;
            }
            return rh;
        }

        void insert(RecordHeader rh) {
            int idx = rh.id % this.mCache.length;
            this.mCache[idx] = rh;
        }

        void invalidate(int rec_id) {
            int idx;
            if (rec_id > 0 && this.mCache[idx = rec_id % this.mCache.length] != null && this.mCache[idx].id == rec_id) {
                this.mCache[idx] = null;
            }
        }
    }

    private class RecordHeader {
        private static final int REC_ID = 0;
        private static final int NEXT_OFFSET = 4;
        private static final int BLOCK_SIZE = 8;
        private static final int DATALEN_OR_NEXTFREE = 12;
        private static final int DATA_OFFSET = 16;
        int offset;
        int id;
        int nextOffset;
        int blockSize;
        int dataLenOrNextFree;

        RecordHeader() {
        }

        RecordHeader(int _offset) throws IOException {
            this.load(_offset);
        }

        RecordHeader(int _offset, int _id, int next_offset, int size, int len_or_free) {
            this.offset = _offset;
            this.id = _id;
            this.nextOffset = next_offset;
            this.blockSize = size;
            this.dataLenOrNextFree = len_or_free;
        }

        void load(int _offset) throws IOException {
            this.offset = _offset;
            RecordStore.this.dbraf.seek(this.offset);
            RecordStore.this.dbraf.read(recHeadBuf, 0, 16);
            this.id = RecordStore.getInt(recHeadBuf, 0);
            this.nextOffset = RecordStore.getInt(recHeadBuf, 4);
            this.blockSize = RecordStore.getInt(recHeadBuf, 8);
            this.dataLenOrNextFree = RecordStore.getInt(recHeadBuf, 12);
        }

        void store() throws IOException {
            RecordStore.putInt(this.id, recHeadBuf, 0);
            RecordStore.putInt(this.nextOffset, recHeadBuf, 4);
            RecordStore.putInt(this.blockSize, recHeadBuf, 8);
            RecordStore.putInt(this.dataLenOrNextFree, recHeadBuf, 12);
            RecordStore.this.dbraf.seek(this.offset);
            RecordStore.this.dbraf.write(recHeadBuf, 0, 16);
        }

        int read(byte[] buf, int _offset) throws IOException {
            int bytesRead;
            RecordStore.this.dbraf.seek(this.offset + 16);
            RecordStore.addLatency();
            for (int tmp = bytesRead = RecordStore.this.dbraf.read(buf, _offset, this.dataLenOrNextFree); tmp > 0; tmp -= RecordStore.getBytesQuota(tmp)) {
            }
            return bytesRead;
        }

        void write(byte[] buf, int _offset) throws IOException {
            RecordStore.this.dbraf.seek(this.offset + 16);
            RecordStore.addLatency();
            RecordStore.this.dbraf.write(buf, _offset, this.dataLenOrNextFree);
            for (int tmp = this.dataLenOrNextFree; tmp > 0; tmp -= RecordStore.getBytesQuota(tmp)) {
            }
        }
    }
}

