/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.Screen;

public class Ticker {
    private String message;
    private String displayedMessage;
    private int messageLoc;
    private int messageWidth;
    private int tickSpeed;
    private static final Image TICKER_IMG = ImmutableImage.createIcon("ticker_border.png");
    static final long TICK_RATE = 250L;
    static final int PREFERRED_HEIGHT = Screen.CONTENT_HEIGHT + 4;
    static final int DECORATION_HEIGHT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticker(String str) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setupText(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String str) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setupText(str);
        }
    }

    public String getString() {
        return this.message;
    }

    void paintContent(Graphics g) {
        if (g.getClipHeight() > Screen.CONTENT_HEIGHT) {
            for (int imgLoc = 0; imgLoc < Display.WIDTH; imgLoc += 96) {
                g.drawImage(TICKER_IMG, imgLoc, 0, 20);
                g.drawImage(TICKER_IMG, imgLoc, Screen.CONTENT_HEIGHT + 3, 20);
            }
        }
        g.setColor(Display.ERASE_COLOR);
        g.fillRect(0, 2, Display.WIDTH, Screen.CONTENT_HEIGHT + 1);
        g.setColor(Display.FG_COLOR);
        this.messageLoc -= this.tickSpeed;
        g.drawString(this.displayedMessage, this.messageLoc, 2, 20);
        if (this.messageLoc <= -this.messageWidth) {
            this.messageLoc = Display.WIDTH;
        }
    }

    void reset() {
        this.messageLoc = Display.WIDTH;
    }

    private final void setupText(String message) {
        if (message == null) {
            throw new NullPointerException();
        }
        StringBuffer msg = new StringBuffer(message);
        int offset = 0;
        boolean modified = false;
        while ((offset = message.indexOf(10, offset)) != -1) {
            msg.setCharAt(offset, ' ');
            ++offset;
            modified = true;
        }
        this.message = message;
        this.displayedMessage = modified ? msg.toString() : message;
        this.messageWidth = Screen.CONTENT_FONT.stringWidth(this.displayedMessage);
        this.tickSpeed = this.messageWidth < 5 ? this.messageWidth : 5;
        this.reset();
    }
}

