/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.DynamicCharacterArray;
import com.sun.midp.lcdui.InputMethodClient;
import com.sun.midp.lcdui.InputMethodHandler;
import com.sun.midp.lcdui.PhoneDial;
import com.sun.midp.lcdui.Text;
import com.sun.midp.lcdui.TextCursor;
import com.sun.midp.lcdui.TextPolicy;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;

public class TextField
extends Item {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int CONSTRAINT_MASK = 65535;
    private boolean firstTimeInTraverse = true;
    private boolean editable;
    private boolean fitsOneLine;
    private static int BORDER_PAD = 2;
    DynamicCharacterArray buffer;
    TextCursor cursor;
    char currentInputChar;
    int oldNumChars;
    boolean multiLine;
    boolean hasBorder;
    boolean usePreferredX = true;
    String initialInputMode = null;
    InputMethodHandler inputHandler = null;
    InputMethodClientImpl inputClient = null;
    private boolean ignoreNextKeyEntered;
    private char[] inputChars = new char[2];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextField(String label, String text, int maxSize, int constraints) {
        super(label);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.buffer = new DynamicCharacterArray(maxSize);
            this.cursor = new TextCursor(0);
            this.cursor.visible = false;
            this.hasBorder = true;
            this.inputHandler = InputMethodHandler.getInputMethodHandler();
            this.inputClient = new InputMethodClientImpl();
            this.setConstraints(constraints);
            this.inputClient.setInputMethodHandler(this.inputHandler);
            this.inputHandler.setInputMethodClient(this.inputClient);
            this.setString(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.buffer.toString();
        }
    }

    public void setString(String text) {
        if (text == null) {
            this.setChars(null, 0, 0);
        } else {
            this.setChars(text.toCharArray(), 0, text.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChars(char[] data) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            try {
                this.buffer.getChars(0, this.buffer.length(), data, 0);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
            return this.buffer.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChars(char[] data, int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (data == null) {
                this.buffer.delete(0, this.buffer.length());
                this.cursor.index = 0;
                this.cursor.option = 0;
            } else {
                if (offset < 0 || offset > data.length || length < 0 || length > data.length || offset + length < 0 || offset + length > data.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (length > this.buffer.capacity()) {
                    throw new IllegalArgumentException();
                }
                if (length > 0) {
                    DynamicCharacterArray dca = new DynamicCharacterArray(length);
                    dca.set(data, offset, length);
                    if (!TextPolicy.isValidString(dca, this.inputClient.getConstraints())) {
                        throw new IllegalArgumentException();
                    }
                }
                this.buffer.set(data, offset, length);
                this.cursor.index = this.buffer.length();
                this.cursor.option = 0;
            }
            this.invalidate();
        }
    }

    public void insert(String src, int position) {
        this.insert(src.toCharArray(), 0, src.length(), position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(char[] data, int offset, int length, int position) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int pos = this.buffer.insert(data, offset, length, position);
            if (!TextPolicy.isValidString(this.buffer, this.inputClient.getConstraints())) {
                this.buffer.delete(pos, length);
                throw new IllegalArgumentException();
            }
            if (position <= this.cursor.index) {
                this.cursor.index += length;
                this.cursor.option = 0;
            }
            this.invalidate();
        }
    }

    private void insert(char ch, int position) {
        char[] chArray = new char[]{ch};
        this.insert(chArray, 0, 1, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (length == 0) {
                return;
            }
            String str = this.buffer.toString();
            this.buffer.delete(offset, length);
            if (!TextPolicy.isValidString(this.buffer, this.inputClient.getConstraints())) {
                this.buffer.delete(0, this.buffer.length());
                this.buffer.insert(0, str);
                throw new IllegalArgumentException();
            }
            if (this.cursor.index >= offset) {
                int diff = this.cursor.index - offset;
                this.cursor.index = this.cursor.index - (diff < length ? diff : length);
                this.cursor.option = 0;
            }
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSize() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.buffer.capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaxSize(int maxSize) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int oldCapacity = this.buffer.capacity();
            this.buffer.setCapacity(maxSize);
            if (!TextPolicy.isValidString(this.buffer, this.inputClient.getConstraints())) {
                this.buffer.setCapacity(oldCapacity);
                throw new IllegalArgumentException();
            }
            this.invalidate();
            return this.buffer.capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.buffer.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretPosition() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.cursor.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraints(int constraints) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if ((constraints & 0xFFFF) < 0 || (constraints & 0xFFFF) > 5) {
                throw new IllegalArgumentException();
            }
            if (this.inputClient.setConstraints(constraints) && !TextPolicy.isValidString(this.buffer, constraints)) {
                this.delete(0, this.buffer.length());
            }
            this.editable = (0x20000 & constraints) != 131072;
            this.multiLine = (constraints & 0xFFFF) != 3;
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConstraints() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.inputClient.getConstraints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialInputMode(String characterSubset) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.initialInputMode = characterSubset;
        }
    }

    void commitPendingInteraction() {
        this.inputHandler.endComposition(false);
    }

    boolean equateNLA() {
        if (super.equateNLA()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    boolean equateNLB() {
        if (super.equateNLB()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    int callMinimumWidth() {
        if ((this.layout == 0 || this.equateNLB() && this.equateNLA()) && this.owner != null) {
            return this.owner.getWidth();
        }
        return Screen.CONTENT_FONT.charWidth('W') * 8;
    }

    int callPreferredWidth(int h) {
        int textW = Screen.CONTENT_FONT.charWidth('W') * this.buffer.capacity();
        textW += 2 * BORDER_PAD;
        int labelW = this.getLabelWidth();
        if (labelW > 0) {
            labelW += 2;
        }
        return textW + labelW;
    }

    int callMinimumHeight() {
        return Screen.CONTENT_HEIGHT + 2 * BORDER_PAD;
    }

    int callPreferredHeight(int w) {
        boolean bl = w == -1 ? true : (this.fitsOneLine = w >= this.callPreferredWidth(-1));
        if (this.fitsOneLine) {
            return 2 * BORDER_PAD + Screen.CONTENT_HEIGHT;
        }
        if (this.buffer.length() == 0) {
            return 2 * BORDER_PAD + this.getLabelHeight(w) + Screen.CONTENT_HEIGHT;
        }
        return 2 * BORDER_PAD + this.getLabelHeight(w) + Text.getHeightForWidth(TextPolicy.getDisplayString(this.buffer, this.currentInputChar, this.inputClient.getConstraints(), this.inputHandler, this.cursor), Screen.CONTENT_FONT, w - (2 * BORDER_PAD + 1), 0);
    }

    void callPaint(Graphics g, int width, int height) {
        int labelHeight = this.getLabelHeight(width);
        int labelWidth = this.getLabelWidth();
        if (labelWidth > 0) {
            labelWidth += 2;
        }
        if (g.getClipY() < labelHeight) {
            if (this.fitsOneLine) {
                g.translate(0, 2);
            }
            super.paintLabel(g, width);
            if (this.fitsOneLine) {
                g.translate(0, -2);
            }
        }
        if (this.fitsOneLine) {
            width -= labelWidth;
            g.translate(labelWidth, 0);
        } else {
            height -= labelHeight;
            g.translate(0, labelHeight);
        }
        if (this.hasBorder) {
            if (!this.hasFocus) {
                g.setColor(0xAFAFAF);
            }
            g.drawRect(0, 0, width - 1, height - 1);
        }
        g.setColor(this.editable ? Display.FG_COLOR : 0xAFAFAF);
        g.translate(BORDER_PAD + 1, BORDER_PAD);
        TextPolicy.paint(this.buffer, this.currentInputChar, this.inputClient.getConstraints(), this.inputHandler, Screen.CONTENT_FONT, g, width - (2 * BORDER_PAD + 1), height, 0, 0, this.cursor);
        g.translate(-(BORDER_PAD + 1), -BORDER_PAD);
        if (this.fitsOneLine) {
            g.translate(-labelWidth, 0);
        } else {
            g.translate(0, -labelHeight);
        }
        g.setColor(Display.FG_COLOR);
        if (this.usePreferredX) {
            this.cursor.preferredX = this.cursor.x;
        }
    }

    void validateCursor() {
        TextPolicy.paint(this.buffer, this.currentInputChar, this.inputClient.getConstraints(), this.inputHandler, Screen.CONTENT_FONT, null, this.bounds[2] - (2 * BORDER_PAD + 1), this.bounds[3], 0, 0, this.cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keyEntered(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.oldNumChars = this.buffer.length();
            this.cursor.visible = true;
            this.currentInputChar = '\u0000';
            switch (keyCode) {
                case -3: {
                    if (this.buffer.length() <= 0) break;
                    this.delete(0, this.buffer.length());
                    this.notifyStateChanged();
                    break;
                }
                case -2: {
                    try {
                        if (this.cursor.index <= 0) break;
                        this.delete(this.cursor.index - 1, 1);
                        this.validateCursor();
                        this.notifyStateChanged();
                    }
                    catch (IllegalArgumentException e) {
                        if (this.buffer.length() <= 0) break;
                        this.delete(0, this.buffer.length());
                        this.notifyStateChanged();
                    }
                    break;
                }
                case -4: {
                    try {
                        if (this.buffer.length() <= 0) break;
                        if (this.buffer.charAt(0) == '-') {
                            this.delete(0, 1);
                        } else {
                            this.insert('-', 0);
                        }
                        this.notifyStateChanged();
                    }
                    catch (IllegalArgumentException e) {
                        AlertType.WARNING.playSound(this.owner.currentDisplay);
                    }
                    break;
                }
                default: {
                    try {
                        int inputLength = 0;
                        if ((this.inputClient.getConstraints() & 0xFFFF) == 5 && keyCode == 46 && this.buffer.length() == 0) {
                            this.inputChars[inputLength] = 48;
                            ++inputLength;
                        }
                        this.inputChars[inputLength] = (char)keyCode;
                        this.insert(this.inputChars, 0, ++inputLength, this.cursor.index);
                        this.validateCursor();
                        this.notifyStateChanged();
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        AlertType.WARNING.playSound(this.owner.currentDisplay);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyPressed(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (Display.getSystemKey(keyCode) == 2) {
                if ((this.inputClient.getConstraints() & 0xFFFF) == 3) {
                    PhoneDial.call(this.getString());
                }
                return;
            }
            if (!this.editable) {
                AlertType.WARNING.playSound(this.owner.currentDisplay);
                return;
            }
            int key = this.inputHandler.keyPressed(keyCode);
            if (key != -1) {
                if (this.buffer.length() == this.buffer.capacity()) {
                    AlertType.WARNING.playSound(this.owner.currentDisplay);
                    this.inputHandler.flush();
                    return;
                }
                this.currentInputChar = (char)key;
                this.cursor.visible = false;
                this.invalidate();
                this.validateCursor();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyReleased(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.inputHandler.keyReleased(keyCode);
        }
    }

    void callKeyRepeated(int keyCode) {
        this.callKeyPressed(keyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyTyped(char c) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (!this.editable) {
                AlertType.WARNING.playSound(this.owner.currentDisplay);
                return;
            }
            this.inputHandler.keyTyped(c);
        }
    }

    boolean moveCursor(int dir) {
        boolean keyUsed = false;
        switch (dir) {
            case 2: {
                if (this.cursor.index <= 0) break;
                --this.cursor.index;
                this.cursor.option = 0;
                keyUsed = true;
                break;
            }
            case 5: {
                if (this.cursor.index >= this.buffer.length()) break;
                ++this.cursor.index;
                this.cursor.option = 0;
                keyUsed = true;
                break;
            }
            case 1: {
                if (!this.multiLine) break;
                this.cursor.y -= Screen.CONTENT_FONT.getHeight();
                if (this.cursor.y > 0) {
                    this.cursor.option = 1;
                    keyUsed = true;
                    break;
                }
                this.cursor.y += Screen.CONTENT_FONT.getHeight();
                break;
            }
            case 6: {
                if (!this.multiLine) break;
                this.cursor.y += Screen.CONTENT_FONT.getHeight();
                int height = this.bounds[3];
                if (this.getLabelHeight(this.bounds[2]) != height) {
                    height -= this.getLabelHeight(this.bounds[2]);
                }
                if (this.cursor.y < height) {
                    this.cursor.option = 1;
                    keyUsed = true;
                    break;
                }
                this.cursor.y -= Screen.CONTENT_FONT.getHeight();
            }
        }
        return keyUsed;
    }

    boolean callTraverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        super.callTraverse(dir, viewportWidth, viewportHeight, visRect_inout);
        boolean ret = false;
        boolean bl = this.usePreferredX = dir != 1 && dir != 6;
        if (this.firstTimeInTraverse || dir == 0) {
            if (this.firstTimeInTraverse) {
                this.inputClient.setInputMode(this.initialInputMode);
                this.inputHandler.setInputMethodClient(this.inputClient);
                this.cursor.option = 0;
                this.cursor.visible = this.editable;
                this.firstTimeInTraverse = false;
            }
            this.repaint();
            if (this.owner.currentDisplay != null) {
                this.owner.currentDisplay.serviceRepaints(this.owner);
            }
            ret = true;
        } else {
            this.inputHandler.endComposition(false);
            if (this.moveCursor(dir)) {
                this.repaint();
                if (this.owner.currentDisplay != null) {
                    this.owner.currentDisplay.serviceRepaints(this.owner);
                }
                ret = true;
            }
        }
        visRect_inout[0] = this.cursor.x;
        visRect_inout[1] = this.cursor.y - this.cursor.height;
        if (!this.fitsOneLine) {
            visRect_inout[1] = visRect_inout[1] + this.getLabelHeight(visRect_inout[2]);
        }
        visRect_inout[2] = this.cursor.width;
        visRect_inout[3] = this.cursor.height + BORDER_PAD + 2;
        return ret;
    }

    void callTraverseOut() {
        super.callTraverseOut();
        this.firstTimeInTraverse = true;
        this.inputHandler.clearInputMethodClient(this.inputClient);
        try {
            this.owner.currentDisplay.setInputMode(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cursor.option = 0;
        this.cursor.index = this.buffer.length();
        this.cursor.visible = false;
        this.repaint();
    }

    void callHideNotify() {
        this.firstTimeInTraverse = true;
    }

    void setBorder(boolean state) {
        this.hasBorder = state;
    }

    private class InputMethodClientImpl
    implements InputMethodClient {
        private InputMethodHandler imh = null;
        private int constraints = 0;
        private String inputMode = null;
        private String[] allowedModes = null;

        private InputMethodClientImpl() {
        }

        public void setInputMethodHandler(InputMethodHandler imh) {
            this.imh = imh;
        }

        public void setInputMode(String inputMode) {
            this.inputMode = inputMode;
        }

        public String getInputMode() {
            return this.inputMode;
        }

        public void setAllowedModes(String[] allowedModes) {
            this.allowedModes = new String[allowedModes.length];
            System.arraycopy(allowedModes, 0, this.allowedModes, 0, allowedModes.length);
        }

        public String[] getAllowedModes() {
            return this.allowedModes;
        }

        public int getConstraints() {
            return this.constraints;
        }

        public boolean setConstraints(int constraints) {
            this.constraints = constraints;
            if (this.imh != null) {
                return this.imh.setConstraints(constraints);
            }
            return true;
        }

        public void keyEntered(int keyCode) {
            TextField.this.keyEntered(keyCode);
        }

        public void showInputMode(int mode) {
            if (TextField.this.hasFocus && TextField.this.owner.currentDisplay != null) {
                TextField.this.owner.currentDisplay.setInputMode(mode);
            }
        }

        public Display getDisplay() {
            return TextField.this.owner.currentDisplay;
        }

        public void setCurrent(Displayable displayable, Display display) {
            TextField.this.owner.resetToTop = false;
            display.setCurrent(displayable);
        }

        public boolean isNewWord() {
            if (TextField.this.buffer.length() == 0) {
                return true;
            }
            return TextField.this.cursor.index > 0 && (TextField.this.buffer.charAt(TextField.this.cursor.index - 1) == ' ' || TextField.this.buffer.charAt(TextField.this.cursor.index - 1) == '\n' || TextField.this.buffer.charAt(TextField.this.cursor.index - 1) == '\t');
        }

        public boolean isNewSentence() {
            if (TextField.this.buffer.length() == 0) {
                return true;
            }
            if (TextField.this.cursor.index > 0 && TextField.this.buffer.charAt(TextField.this.cursor.index - 1) != ' ' && TextField.this.buffer.charAt(TextField.this.cursor.index - 1) != '\n' && TextField.this.buffer.charAt(TextField.this.cursor.index - 1) != '\t') {
                return false;
            }
            for (int i = TextField.this.cursor.index - 2; i >= 0; --i) {
                if (TextField.this.buffer.charAt(i) == '.') {
                    return true;
                }
                if (TextField.this.buffer.charAt(i) == ' ' || TextField.this.buffer.charAt(i) == '\n' || TextField.this.buffer.charAt(i) == '\t') continue;
                return false;
            }
            return true;
        }

        public boolean isNewInputEntry() {
            return TextField.this.buffer.length() == 0 && TextField.this.oldNumChars != 0;
        }
    }
}

