/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Text;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Screen;

public class StringItem
extends Item {
    private String str;
    private Font font;
    private int appearanceMode;
    private int originalAppearanceMode;
    private int minimumLineHeight;
    private boolean skipTraverse;

    public StringItem(String label, String text) {
        this(label, text, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringItem(String label, String text, int appearanceMode) {
        super(label);
        Object object = Display.LCDUILock;
        synchronized (object) {
            switch (appearanceMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.appearanceMode = appearanceMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.str = text;
            this.font = Screen.CONTENT_FONT;
            int labelFontHeight = LABEL_FONT.getHeight();
            this.minimumLineHeight = Screen.CONTENT_HEIGHT;
            if (this.minimumLineHeight < labelFontHeight) {
                this.minimumLineHeight = labelFontHeight;
            }
            this.checkTraverse();
        }
    }

    public String getText() {
        return this.str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.str = text;
            this.checkTraverse();
            this.invalidate();
        }
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setPreferredSize(int width, int height) {
        super.setPreferredSize(width, height);
    }

    int callMinimumWidth() {
        int pW = this.callPreferredWidth(-1);
        int w = this.font.charWidth('W') * 8 + 6 * this.font.charWidth('.');
        if (w > pW) {
            w = pW;
        }
        if (this.isButton()) {
            w += 10;
        }
        return w;
    }

    int callPreferredWidth(int h) {
        if (this.isButton()) {
            int buttonPad = 10;
            int prefW = Text.getTwoStringsWidth(this.label, this.str, LABEL_FONT, this.font, DEFAULT_WIDTH - buttonPad, 2);
            return prefW > 0 ? prefW + buttonPad : 0;
        }
        return Text.getTwoStringsWidth(this.label, this.str, LABEL_FONT, this.font, DEFAULT_WIDTH, 2);
    }

    int callMinimumHeight() {
        return this.callPreferredHeight(-1);
    }

    int callPreferredHeight(int w) {
        if (w == -1) {
            w = DEFAULT_WIDTH;
        }
        if (this.isButton()) {
            int buttonPad = 10;
            int prefH = Text.getTwoStringsHeight(this.label, this.str, LABEL_FONT, this.font, w - buttonPad, 2);
            return prefH > 0 ? prefH + buttonPad : 0;
        }
        return Text.getTwoStringsHeight(this.label, this.str, LABEL_FONT, this.font, w, 2);
    }

    boolean equateNLB() {
        if (this.label != null && this.label.length() > 0) {
            if (this.label.charAt(0) == '\n') {
                return true;
            }
        } else if (this.str != null && this.str.length() > 0) {
            if (this.str.charAt(0) == '\n') {
                return true;
            }
        } else {
            return false;
        }
        if ((this.layout & 0x4000) == 16384) {
            return (this.layout & 0x100) == 256;
        }
        return this.label != null && this.label.length() > 0;
    }

    boolean equateNLA() {
        if (this.str != null && this.str.length() > 0) {
            if (this.str.charAt(this.str.length() - 1) == '\n') {
                return true;
            }
        } else if (this.label != null && this.label.length() > 0) {
            if (this.label.charAt(this.label.length() - 1) == '\n') {
                return true;
            }
        } else {
            return false;
        }
        if ((this.layout & 0x4000) == 16384) {
            return (this.layout & 0x200) == 512;
        }
        return false;
    }

    boolean shouldSkipTraverse() {
        if (!(this.label != null && this.label.length() != 0 || this.str != null && this.str.length() != 0)) {
            return true;
        }
        return this.skipTraverse;
    }

    void callPaint(Graphics g, int width, int height) {
        int labelHeight;
        Font lFont;
        int offset;
        int w = width;
        int h = height;
        int translateY = 0;
        int translateX = 0;
        if (this.isButton()) {
            translateY = 5;
            translateX = 5;
            w -= 2 * translateX;
            h -= 2 * translateY;
            g.translate(translateX, translateY);
        }
        if ((offset = Text.paint(this.label, lFont = LABEL_FONT, g, w, labelHeight = this.getLabelHeight(w), 0, 0, null)) > 0) {
            offset += 2;
        }
        int mode = 0;
        if (this.numCommands > 0 && this.appearanceMode == 1) {
            mode = this.hasFocus ? 3 : 2;
        }
        int yOffset = labelHeight;
        if (labelHeight > 0) {
            yOffset -= lFont.getHeight() < this.font.getHeight() ? lFont.getHeight() : this.font.getHeight();
        }
        g.translate(0, yOffset);
        Text.paint(this.str, this.font, g, w, h - yOffset, offset, mode, null);
        g.translate(-translateX, -(translateY += yOffset));
        if (this.isButton()) {
            this.drawButtonBorder(g, 0, 0, width, height, this.hasFocus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyPressed(int keyCode) {
        if (keyCode != Display.KEYCODE_SELECT) {
            return;
        }
        if (this.getCommandCount() <= 0 || this.commandListener == null) {
            return;
        }
        ItemCommandListener cl = null;
        Command defaultCmd = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            cl = this.commandListener;
            defaultCmd = this.defaultCommand;
        }
        if (cl != null) {
            try {
                object = Display.calloutLock;
                synchronized (object) {
                    if (defaultCmd != null) {
                        cl.commandAction(defaultCmd, this);
                    }
                }
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCommandImpl(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.addCommandImpl(cmd);
            if (this.numCommands >= 1 && this.appearanceMode == 0) {
                this.appearanceMode = this.originalAppearanceMode == 2 ? 2 : 1;
            }
            this.checkTraverse();
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCommandImpl(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.removeCommandImpl(cmd);
            if (this.numCommands < 1 && this.appearanceMode != 0) {
                this.originalAppearanceMode = this.appearanceMode;
                this.appearanceMode = 0;
            }
            this.checkTraverse();
            this.invalidate();
        }
    }

    private void checkTraverse() {
        this.skipTraverse = this.str == null && this.label == null ? true : (this.str == null && this.label.trim().equals("") ? true : this.label == null && this.str.trim().equals(""));
    }

    private boolean isButton() {
        return this.numCommands > 0 && this.appearanceMode == 2;
    }
}

