/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.MutableImage;

public class Image {
    int width;
    int height;
    int imgData;
    private static final int INVALID_TRANSFORM_BITS = -8;

    Image() {
    }

    public static Image createImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        return new MutableImage(width, height);
    }

    public static Image createImage(Image source) {
        return new ImmutableImage(source);
    }

    public static Image createImage(String name) throws IOException {
        try {
            return new ImmutableImage(name);
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    public static Image createImage(byte[] imageData, int imageOffset, int imageLength) {
        if (imageOffset < 0 || imageOffset >= imageData.length || imageLength < 0 || imageOffset + imageLength > imageData.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new ImmutableImage(imageData, imageOffset, imageLength);
    }

    public static Image createImage(Image image, int x, int y, int width, int height, int transform) {
        if ((transform & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException();
        }
        if (x < 0 || y < 0 || x + width > image.width || y + height > image.height || width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        if (x == 0 && y == 0 && width == image.width && height == image.height && transform == 0) {
            return image;
        }
        return new ImmutableImage(image, x, y, width, height, transform);
    }

    public Graphics getGraphics() {
        throw new IllegalStateException();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isMutable() {
        return false;
    }

    public static Image createImage(InputStream stream) throws IOException {
        try {
            return new ImmutableImage(stream);
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    public static Image createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        if (width * height > rgb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new ImmutableImage(rgb, width, height, processAlpha);
    }

    public native void getRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

