/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;

public class DateField
extends Item {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    static final Date EPOCH = new Date(0L);
    static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    static final int[] TRIG_TABLE = new int[]{65535, 65525, 65495, 65445, 65375, 65285, 65175, 65046, 64897, 64728, 64539, 64330, 64102, 63855, 63588, 63301, 62996, 62671, 62327, 61964, 61582, 61182, 60762, 60325, 59869, 59394, 58902, 58392, 57863, 57318, 56754, 56174, 55576, 54962, 54330, 53683, 53018, 52338, 51642, 50930, 50202, 49459, 48701, 47929, 47141, 46340, 45524, 44694, 43851, 42994, 42125, 41242, 40347, 39439, 38520, 37589, 36646, 35692, 34728, 33753, Short.MAX_VALUE, 31771, 30766, 29752, 28728, 27696, 26655, 25606, 24549, 23485, 22414, 21336, 20251, 19160, 18063, 16961, 15854, 14742, 13625, 12504, 11380, 10251, 9120, 7986, 6850, 5711, 4571, 3429, 2287, 1143, 0};
    private int highlight = -1;
    private boolean traversedIn;
    private boolean initialized;
    private int mode;
    private EditScreen editor = null;
    private Calendar currentDate;
    private static final boolean CLOCK_USES_AM_PM = true;
    private static final Image ARROW_UP = ImmutableImage.createIcon("date_up.png");
    private static final Image ARROW_DOWN = ImmutableImage.createIcon("date_down.png");
    private static final Image ARROW_LEFT = ImmutableImage.createIcon("date_left.png");
    private static final Image ARROW_RIGHT = ImmutableImage.createIcon("date_right.png");

    public DateField(String label, int mode) {
        this(label, mode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateField(String label, int mode, TimeZone timeZone) {
        super(label);
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (mode != 1 && mode != 2 && mode != 3) {
                throw new IllegalArgumentException("Invalid input mode");
            }
            this.mode = mode;
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
            this.currentDate = Calendar.getInstance(timeZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.initialized ? new Date(this.currentDate.getTime().getTime()) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(Date date) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (date == null) {
                this.initialized = false;
            } else {
                this.currentDate.setTime(date);
                if (this.mode == 2) {
                    this.initialized = this.currentDate.get(1) == 1970 && this.currentDate.get(2) == 0 && this.currentDate.get(5) == 1;
                } else {
                    if (this.mode == 1) {
                        this.currentDate.set(11, 0);
                        this.currentDate.set(12, 0);
                    }
                    this.initialized = true;
                }
                this.currentDate.set(13, 0);
                this.currentDate.set(14, 0);
            }
            this.invalidate();
        }
    }

    public int getInputMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("Invalid input mode");
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.mode != mode) {
                int oldMode = this.mode;
                this.mode = mode;
                if (mode == 2) {
                    this.currentDate.set(1, 1970);
                    this.currentDate.set(2, 0);
                    this.currentDate.set(5, 1);
                } else if (mode == 1) {
                    this.currentDate.set(11, 0);
                    this.currentDate.set(12, 0);
                }
                this.invalidate();
            }
        }
    }

    boolean equateNLA() {
        if (super.equateNLA()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    boolean equateNLB() {
        if (super.equateNLB()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    void saveDate(Date date) {
        this.initialized = true;
        this.currentDate.setTime(date);
        this.invalidate();
    }

    int callMinimumWidth() {
        return Screen.CONTENT_FONT.stringWidth("Www,99 Www 0000") + 2;
    }

    int callPreferredWidth(int h) {
        return this.callMinimumWidth();
    }

    int callMinimumHeight() {
        return this.callPreferredHeight(-1);
    }

    int callPreferredHeight(int w) {
        if (this.mode == 3) {
            return this.getLabelHeight(w) + Screen.CONTENT_HEIGHT * 2 + 2;
        }
        return this.getLabelHeight(w) + Screen.CONTENT_HEIGHT;
    }

    void callPaint(Graphics g, int width, int height) {
        int labelHeight = super.paintLabel(g, width) + 2;
        g.translate(0, labelHeight);
        int offset = 0;
        switch (this.mode) {
            case 2: 
            case 3: {
                String str = this.toString(2);
                if (this.highlight == 0 && this.hasFocus) {
                    g.fillRect(2, 0, Screen.CONTENT_FONT.stringWidth(str), Screen.CONTENT_HEIGHT);
                    g.setColor(Display.FG_H_COLOR);
                }
                g.drawString(str, 2, 0, 20);
                g.setColor(Display.FG_COLOR);
                if (this.mode == 2) break;
                offset = Screen.CONTENT_HEIGHT;
            }
            case 1: {
                String str = this.toString(1);
                if (this.highlight == 0 && this.mode == 1 && this.hasFocus || this.highlight == 1 && this.mode == 3 && this.hasFocus) {
                    g.fillRect(2, offset, Screen.CONTENT_FONT.stringWidth(str), Screen.CONTENT_HEIGHT);
                    g.setColor(Display.FG_H_COLOR);
                }
                g.drawString(this.toString(1), 2, offset, 20);
                g.setColor(Display.FG_COLOR);
            }
        }
        g.translate(0, -labelHeight);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean callTraverse(int dir, int viewportWidth, int viewportHeight, int[] visRect) {
        int numEls;
        super.callTraverse(dir, viewportWidth, viewportHeight, visRect);
        int n = numEls = this.mode == 3 ? 2 : 1;
        if (!this.traversedIn) {
            this.traversedIn = true;
            if (this.highlight == -1) {
                switch (dir) {
                    case 1: {
                        this.highlight = numEls - 1;
                        break;
                    }
                    case 6: {
                        this.highlight = 0;
                        break;
                    }
                }
            }
        } else if (dir == 1) {
            if (this.highlight <= 0) return false;
            --this.highlight;
        } else if (dir == 6) {
            if (this.highlight >= numEls - 1) return false;
            ++this.highlight;
        }
        visRect[1] = this.getLabelHeight(visRect[2]) + 2;
        if (this.highlight > 0) {
            visRect[1] = visRect[1] + Screen.CONTENT_HEIGHT;
        }
        visRect[3] = Screen.CONTENT_HEIGHT;
        this.repaint();
        return true;
    }

    void callTraverseOut() {
        super.callTraverseOut();
        this.traversedIn = false;
    }

    void callKeyPressed(int keyCode) {
        if (keyCode != Display.KEYCODE_SELECT) {
            return;
        }
        Screen returnScreen = this.getOwner();
        if (this.editor == null) {
            this.editor = new EditScreen(returnScreen, this);
        }
        switch (this.mode) {
            case 1: {
                if (!this.initialized) {
                    this.currentDate.set(11, 0);
                    this.currentDate.set(12, 0);
                    this.currentDate.set(13, 0);
                    this.currentDate.set(14, 0);
                }
                this.editor.setDateTime(this.currentDate.getTime(), 1);
                break;
            }
            case 2: {
                this.editor.setDateTime(this.initialized ? this.currentDate.getTime() : EPOCH, 2);
                break;
            }
            case 3: {
                this.editor.setDateTime(this.currentDate.getTime(), this.highlight < 1 ? 2 : 1);
            }
        }
        returnScreen.resetToTop = false;
        returnScreen.currentDisplay.setCurrent(this.editor);
    }

    static String ampmString(Calendar calendar) {
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        if (hour >= 12) {
            return minute == 0 && hour == 12 ? "noon" : "PM";
        }
        return minute == 0 && hour == 0 ? "mid." : "AM";
    }

    static String dayOfWeekString(Calendar calendar) {
        String str;
        switch (calendar.get(7)) {
            case 1: {
                str = "Sun";
                break;
            }
            case 2: {
                str = "Mon";
                break;
            }
            case 3: {
                str = "Tue";
                break;
            }
            case 4: {
                str = "Wed";
                break;
            }
            case 5: {
                str = "Thu";
                break;
            }
            case 6: {
                str = "Fri";
                break;
            }
            case 7: {
                str = "Sat";
                break;
            }
            default: {
                str = Integer.toString(calendar.get(7));
            }
        }
        return str;
    }

    String toString(int mode) {
        if (mode == 1) {
            if (!this.initialized) {
                return Resource.getString("<date>");
            }
            return Resource.getDateString(DateField.dayOfWeekString(this.currentDate), DateField.twoDigits(this.currentDate.get(5)), MONTH_NAMES[this.currentDate.get(2)].substring(0, 3), Integer.toString(this.currentDate.get(1)));
        }
        if (mode == 2) {
            if (!this.initialized) {
                return Resource.getString("<time>");
            }
            return Resource.getTimeString(DateField.twoDigits(this.currentDate.get(10)), DateField.twoDigits(this.currentDate.get(12)), DateField.twoDigits(this.currentDate.get(13)), DateField.ampmString(this.currentDate));
        }
        if (!this.initialized) {
            return Resource.getString("<date/time>");
        }
        return Resource.getDateTimeString(DateField.dayOfWeekString(this.currentDate), DateField.twoDigits(this.currentDate.get(5)), MONTH_NAMES[this.currentDate.get(2)].substring(0, 3), Integer.toString(this.currentDate.get(1)), DateField.twoDigits(this.currentDate.get(11)), DateField.twoDigits(this.currentDate.get(12)), DateField.twoDigits(this.currentDate.get(13)), DateField.ampmString(this.currentDate));
    }

    static int cos(int angle) {
        angle += 360000;
        if ((angle %= 360) >= 270) {
            return TRIG_TABLE[360 - angle];
        }
        if (angle >= 180) {
            return -TRIG_TABLE[angle - 180];
        }
        if (angle >= 90) {
            return -TRIG_TABLE[180 - angle];
        }
        return TRIG_TABLE[angle];
    }

    static int sin(int angle) {
        return DateField.cos(angle - 90);
    }

    private static String twoDigits(int n) {
        if (n == 0) {
            return "00";
        }
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    class EditScreen
    extends Screen
    implements CommandListener {
        Calendar calendar;
        int mode;
        DateField field;
        Screen returnScreen;
        int timeSel = 0;
        private static final boolean SELECT_TRANSFERS_FOCUS = false;
        Command Back = new Command(Resource.getString("Back"), 2, 0);
        Command OK = new Command(Resource.getString("Save"), 4, 1);
        private boolean ampmAfterTime = Resource.isAMPMafterTime();
        private int width;
        private int height;
        private int highlight;
        private int lastDay;
        private int dayOffset;
        Font large = Font.getFont(0, 0, 16);
        Font regular = Font.getFont(0, 0, 8);
        Font bold = Font.getFont(0, 1, 8);

        EditScreen(Screen returnScreen, DateField field) {
            super(field.getLabel());
            this.returnScreen = returnScreen;
            this.field = field;
            this.calendar = Calendar.getInstance();
            this.addCommand(this.OK);
            this.addCommand(this.Back);
            this.setCommandListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command cmd, Displayable s) {
            Form form = null;
            DateField item = null;
            Object object = Display.LCDUILock;
            synchronized (object) {
                if (cmd == this.OK) {
                    this.field.saveDate(this.calendar.getTime());
                    item = this.field;
                    form = (Form)item.getOwner();
                }
                this.currentDisplay.setCurrent(this.returnScreen);
            }
            if (form != null) {
                this.currentDisplay.itemStateChanged(item);
            }
        }

        void setDateTime(Date currentValue, int mode) {
            this.calendar.setTime(currentValue);
            this.mode = mode;
            this.timeSel = !this.ampmAfterTime ? 9 : 10;
            this.highlight = -1;
            this.callRepaint();
        }

        void callShowNotify(Display d) {
            super.callShowNotify(d);
            this.layout();
            this.setDayOffset();
            this.lastDay = this.daysInMonth(this.calendar.get(2), this.calendar.get(1));
        }

        void callPaint(Graphics g, Object target) {
            super.callPaint(g, target);
            g.translate(this.viewport[0], this.viewport[1] + 5);
            if (this.mode == 2) {
                this.paintClock(g);
            } else {
                this.paintCalendar(g);
            }
            g.translate(-this.viewport[0], -(this.viewport[1] + 5));
        }

        void layout() {
            super.layout();
            this.width = this.viewport[2];
            this.height = this.viewport[3];
        }

        int initHilight(int vpY, int vpH) {
            int hilightBottom;
            if (this.mode == 1 && (hilightBottom = this.highlightY(true)) > vpH) {
                return hilightBottom - vpH;
            }
            return 0;
        }

        void callKeyPressed(int keyCode) {
            int gameAction = Display.getGameAction(keyCode);
            switch (gameAction) {
                case 8: {
                    this.selectFired();
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    if (this.mode == 1) {
                        this.traverseDate(gameAction, DateField.this.bounds[1], DateField.this.bounds[1] + DateField.this.bounds[3]);
                    } else {
                        this.traverseClock(gameAction, DateField.this.bounds[1], DateField.this.bounds[1] + DateField.this.bounds[3]);
                    }
                    this.callRepaint();
                }
            }
        }

        void callKeyRepeated(int keyCode) {
            int gameAction = Display.getGameAction(keyCode);
            switch (gameAction) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    if (this.mode == 1) {
                        this.traverseDate(gameAction, DateField.this.bounds[1], DateField.this.bounds[1] + DateField.this.bounds[3]);
                    } else {
                        this.traverseClock(gameAction, DateField.this.bounds[1], DateField.this.bounds[1] + DateField.this.bounds[3]);
                    }
                    this.callRepaint();
                }
            }
        }

        void selectFired() {
        }

        void paintClock(Graphics g) {
            int len;
            int offset;
            int hour = this.calendar.get(10) % 12;
            int minute = this.calendar.get(12);
            g.setColor(Display.ERASE_COLOR);
            g.fillRect(0, 0, this.width, this.height);
            int digits_height = this.large.getHeight() + ARROW_UP.getHeight() + ARROW_DOWN.getHeight() + 2;
            int clockSize = this.height - digits_height;
            if (this.width < clockSize) {
                clockSize = this.width;
            }
            if (60 < clockSize) {
                clockSize = 60;
            }
            g.translate((this.width - clockSize) / 2, (this.height - (clockSize + digits_height)) / 2);
            g.setColor(Display.FG_COLOR);
            g.drawRoundRect(0, 0, clockSize, clockSize, clockSize / 2, clockSize / 2);
            g.drawLine(clockSize / 2, 0, clockSize / 2, 5);
            g.drawLine(clockSize / 2, clockSize, clockSize / 2, clockSize - 5);
            g.drawLine(0, clockSize / 2, 5, clockSize / 2);
            g.drawLine(clockSize, clockSize / 2, clockSize - 5, clockSize / 2);
            int minuteAngle = 90 - minute * 6;
            int hourAngle = 90 - (hour * 30 + minute / 2);
            g.translate(clockSize / 2, clockSize / 2);
            g.drawLine(0, 0, DateField.cos(hourAngle) * clockSize / 4 >> 16, -(DateField.sin(hourAngle) * clockSize / 4) >> 16);
            g.drawLine(0, 0, DateField.cos(minuteAngle) * (clockSize / 2 - 10) >> 16, -(DateField.sin(minuteAngle) * (clockSize / 2 - 10)) >> 16);
            g.translate(0, clockSize / 2 + 2 + ARROW_UP.getHeight());
            g.setFont(this.large);
            String ampm = Resource.getString(DateField.ampmString(this.calendar));
            if (hour == 0) {
                hour = 12;
            }
            String timeString = this.ampmAfterTime ? DateField.twoDigits(hour) + ":" + DateField.twoDigits(minute) + " " + ampm : ampm + " " + DateField.twoDigits(hour) + ":" + DateField.twoDigits(minute);
            g.translate(-this.large.stringWidth(timeString) / 2, 0);
            g.drawString(timeString, 0, 0, 20);
            int h = this.large.getBaselinePosition() + 1;
            if (this.ampmAfterTime) {
                if (this.timeSel == 10) {
                    offset = 0;
                    len = 2;
                } else if (this.timeSel == 12) {
                    offset = 3;
                    len = 2;
                } else {
                    offset = 6;
                    len = timeString.length() - offset;
                }
            } else {
                offset = ampm.length();
                if (this.timeSel == 10) {
                    ++offset;
                    len = 2;
                } else if (this.timeSel == 12) {
                    offset += 4;
                    len = 2;
                } else {
                    len = offset;
                    offset = 0;
                }
            }
            int dX = this.large.substringWidth(timeString, 0, offset);
            int w = this.large.substringWidth(timeString, offset, len);
            g.fillRect(dX, 1, w, h - 1);
            g.setColor(Display.FG_H_COLOR);
            g.drawSubstring(timeString, offset, len, dX, 0, 20);
            if (this.ampmAfterTime) {
                if (this.timeSel != 10) {
                    g.drawImage(ARROW_LEFT, -1, h / 2 + 2, 10);
                }
                if (this.timeSel != 9) {
                    g.drawImage(ARROW_RIGHT, this.large.stringWidth(timeString) + 1, h / 2 + 2, 6);
                }
            } else {
                if (this.timeSel != 9) {
                    g.drawImage(ARROW_LEFT, -1, h / 2 + 2, 10);
                }
                if (this.timeSel != 12) {
                    g.drawImage(ARROW_RIGHT, this.large.stringWidth(timeString) + 1, h / 2 + 2, 6);
                }
            }
            g.drawImage(ARROW_UP, dX + w / 2, 0, 33);
            g.drawImage(ARROW_DOWN, dX + w / 2, h + 1, 17);
        }

        int traverseClock(int action, int top, int bottom) {
            int hrInc = 1;
            switch (action) {
                case 2: {
                    if (this.timeSel == 12) {
                        this.timeSel = 10;
                        return 0;
                    }
                    if (this.timeSel == 9) {
                        this.timeSel = 12;
                    } else if (this.timeSel == 10) {
                        this.timeSel = 9;
                    }
                    return 0;
                }
                case 5: {
                    if (this.timeSel == 10) {
                        this.timeSel = 12;
                        return 0;
                    }
                    if (this.timeSel == 12) {
                        this.timeSel = 9;
                    } else if (this.timeSel == 9) {
                        this.timeSel = 10;
                    }
                    return 0;
                }
                case 1: {
                    if (this.timeSel == 9) {
                        hrInc = 12;
                    } else if (this.timeSel == 12) {
                        int m = this.calendar.get(12);
                        if (m == 59) {
                            this.calendar.set(12, 0);
                        } else {
                            this.calendar.set(12, m + 1);
                            hrInc = 0;
                        }
                    }
                    this.calendar.set(11, (hrInc + this.calendar.get(11)) % 24);
                    return 0;
                }
                case 6: {
                    if (this.timeSel == 9) {
                        hrInc = 12;
                    } else if (this.timeSel == 12) {
                        int m = this.calendar.get(12);
                        if (m == 0) {
                            this.calendar.set(12, 59);
                        } else {
                            this.calendar.set(12, m - 1);
                            hrInc = 0;
                        }
                    }
                    hrInc = 24 - hrInc;
                    this.calendar.set(11, (hrInc + this.calendar.get(11)) % 24);
                    return 0;
                }
            }
            return -1;
        }

        int traverseDate(int action, int top, int bottom) {
            int scrollHeight = 0;
            switch (action) {
                case 2: {
                    if (this.highlight == 1) {
                        return -1;
                    }
                    if (this.highlight > 1) {
                        int topOfHighlight;
                        --this.highlight;
                        if (this.calendar.get(7) != 1 || (topOfHighlight = this.highlightY(false)) >= top) break;
                        scrollHeight = top - topOfHighlight;
                        break;
                    }
                    int year = this.calendar.get(1);
                    int month = this.calendar.get(2);
                    if (this.highlight == 0) {
                        if (month > 0) {
                            int day = this.calendar.get(5);
                            this.lastDay = this.daysInMonth(month - 1, year);
                            if (day > this.lastDay) {
                                this.calendar.set(5, this.lastDay);
                            }
                            this.calendar.set(2, month - 1);
                        } else {
                            this.lastDay = 31;
                            this.calendar.set(2, 11);
                            this.calendar.set(1, year - 1);
                        }
                    } else if (this.highlight == -1) {
                        this.calendar.set(1, year - 1);
                        this.lastDay = this.daysInMonth(month, year);
                    }
                    this.setDayOffset();
                    break;
                }
                case 5: {
                    if (this.highlight == this.lastDay) {
                        return -1;
                    }
                    if (this.highlight > 0 && this.highlight < this.lastDay) {
                        int bottomOfHighlight;
                        ++this.highlight;
                        if (this.calendar.get(7) != 7 || (bottomOfHighlight = this.highlightY(true)) <= bottom) break;
                        scrollHeight = bottomOfHighlight - bottom;
                        break;
                    }
                    int year = this.calendar.get(1);
                    int month = this.calendar.get(2);
                    if (this.highlight == 0) {
                        if (month < 11) {
                            int day = this.calendar.get(5);
                            this.lastDay = this.daysInMonth(month + 1, year);
                            if (day > this.lastDay) {
                                this.calendar.set(5, this.lastDay);
                            }
                            this.calendar.set(2, month + 1);
                        } else {
                            this.calendar.set(2, 0);
                            this.calendar.set(1, year + 1);
                        }
                    } else if (this.highlight == -1) {
                        this.calendar.set(1, year + 1);
                        this.lastDay = this.daysInMonth(month, year);
                    }
                    this.setDayOffset();
                    break;
                }
                case 1: {
                    if (this.highlight == -1) {
                        return -1;
                    }
                    this.highlight = this.highlight == 0 ? -1 : (this.highlight <= 7 ? 0 : (this.highlight -= 7));
                    int topOfHighlight = this.highlightY(false);
                    if (topOfHighlight >= top) break;
                    scrollHeight = top - topOfHighlight;
                    break;
                }
                case 6: {
                    if (this.highlight == this.lastDay) {
                        return -1;
                    }
                    if (this.highlight == -1) {
                        this.highlight = 0;
                    } else if (this.highlight == 0) {
                        this.highlight = 1;
                    } else if (this.highlight + 7 <= this.lastDay) {
                        this.highlight += 7;
                    } else if (this.highlight + 7 > this.lastDay) {
                        this.highlight = this.lastDay;
                    }
                    int bottomOfHighlight = this.highlightY(true);
                    if (bottomOfHighlight <= bottom) break;
                    scrollHeight = bottomOfHighlight - bottom;
                    break;
                }
                default: {
                    return -1;
                }
            }
            if (this.highlight > 0) {
                this.calendar.set(5, this.highlight);
            }
            return scrollHeight;
        }

        private int daysInMonth(int month, int year) {
            switch (month) {
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: {
                    return 31;
                }
                case 1: {
                    if (year % 400 == 0 || (year & 3) == 0 && year % 100 != 0) {
                        return 29;
                    }
                    return 28;
                }
            }
            return 30;
        }

        int highlightY(boolean addLineHeight) {
            if (this.highlight == -1) {
                return addLineHeight ? this.regular.getBaselinePosition() : 0;
            }
            if (this.highlight == 0) {
                return this.regular.getBaselinePosition() + (addLineHeight ? this.regular.getHeight() : 0);
            }
            int line = 1 + (this.highlight + this.dayOffset - 2) / 7;
            return (this.regular.getBaselinePosition() + 1) * line + this.regular.getHeight() + (addLineHeight ? this.regular.getBaselinePosition() : 0);
        }

        void paintCalendar(Graphics g) {
            g.setColor(Display.ERASE_COLOR);
            g.fillRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
            boolean currentDateOnDisplay = false;
            int year = this.calendar.get(1);
            int month = this.calendar.get(2);
            int selection = this.calendar.get(5);
            int currYear = DateField.this.currentDate.get(1);
            int currMonth = DateField.this.currentDate.get(2);
            int currDate = DateField.this.currentDate.get(5);
            if (currYear == year && currMonth == month) {
                currentDateOnDisplay = true;
            }
            g.setFont(this.regular);
            int w = this.regular.stringWidth("0000");
            int h = this.regular.getBaselinePosition();
            g.translate(0, -1);
            if (this.highlight == -1) {
                g.setColor(Display.BG_H_COLOR);
                g.fillRect((this.width - w) / 2 - 1, 1, w + 1, h);
                g.setColor(Display.FG_H_COLOR);
            } else {
                g.setColor(Display.FG_COLOR);
            }
            g.drawString("" + year, this.width / 2, 0, 17);
            g.drawImage(ARROW_LEFT, (this.width - w) / 2 - 2, h / 2, 10);
            g.drawImage(ARROW_RIGHT, (this.width + w) / 2 + 2, h / 2, 6);
            g.translate(0, h + 1);
            w = this.regular.stringWidth(Resource.getString(MONTH_NAMES[month]));
            h = this.regular.getHeight();
            if (this.highlight == 0) {
                g.setColor(Display.BG_H_COLOR);
                g.fillRect((this.width - w) / 2 - 1, 1, w + 2, h);
                g.setColor(Display.FG_H_COLOR);
            } else {
                g.setColor(Display.FG_COLOR);
            }
            g.setFont(this.regular);
            g.drawString(Resource.getString(MONTH_NAMES[month]), this.width / 2, 0, 17);
            g.drawImage(ARROW_LEFT, (this.width - w) / 2 - 2, h / 2, 10);
            g.drawImage(ARROW_RIGHT, (this.width + w) / 2 + 2, h / 2, 6);
            g.translate(0, h);
            int o = this.width / 14;
            int rem = this.width % 14 / 2;
            int x = o * (this.dayOffset * 2 - 1) + rem;
            int y = 0;
            int lastCol = 14 * o;
            h = this.regular.getBaselinePosition() + 1;
            for (int i = 1; i <= this.lastDay; ++i) {
                String str = "" + i;
                if (i == this.highlight) {
                    w = this.regular.stringWidth(str);
                    g.setColor(Display.BG_H_COLOR);
                    g.fillRect(x - w / 2 - 1, y + 1, w + 1, h - 1);
                    g.setColor(Display.FG_H_COLOR);
                } else {
                    g.setColor(Display.FG_COLOR);
                }
                g.setFont(currentDateOnDisplay && i == currDate && i != this.highlight ? this.bold : this.regular);
                g.drawString(str, x, y, 17);
                if ((x += 2 * o) <= lastCol) continue;
                x = o + rem;
                y += h;
            }
        }

        private void setDayOffset() {
            Date save = this.calendar.getTime();
            this.calendar.set(5, 1);
            this.dayOffset = this.calendar.get(7);
            if (Resource.getFirstDayOfWeek() != 1) {
                this.dayOffset = this.dayOffset == 1 ? 7 : this.dayOffset - 1;
            }
            this.calendar.setTime(save);
        }

        boolean isEditScreen(Displayable d) {
            return d == this.returnScreen;
        }
    }
}

