/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia.protocol;

public final class LocatorParser {
    public static final String S_ENCODING = "encoding";
    public static final String S_TYPE = "type";
    public static final String S_WIDTH = "width";
    public static final String S_HEIGHT = "height";
    public static final String S_QUALITY = "quality";
    public static final String S_PROGRESSIVE = "progressive";
    public static final String S_INTERLACED = "interlaced";
    public static final String S_FPS = "fps";
    public static final String S_COLORS = "colors";
    public static final String S_JPEG = "jpeg";
    public static final String S_PNG = "png";
    public static final String S_JFIF = "jfif";
    public static final String S_TRUE = "true";
    public static final String S_FALSE = "false";
    public static final String S_AUDIO = "audio";
    public static final String S_VIDEO = "video";
    public static final String S_RATE = "rate";
    public static final String S_BITS = "bits";
    public static final String S_CHANNELS = "channels";
    public static final String S_ENDIAN = "endian";
    public static final String S_SIGNED = "signed";
    private String locator;
    private int index;
    private int length;
    private String value;

    public LocatorParser(String s) {
        this.length = s.length();
        this.locator = s;
    }

    public String getProtocol() {
        int colonIndex = this.locator.indexOf("://");
        int oldIndex = this.index;
        if (colonIndex < 1) {
            return null;
        }
        this.index = colonIndex + 3;
        return this.locator.substring(oldIndex, colonIndex);
    }

    public String getDevice() {
        if (this.index >= this.length) {
            return null;
        }
        int oldIndex = this.index;
        int queryIndex = this.locator.indexOf("?", this.index);
        if (queryIndex < 0) {
            this.index = this.length;
            return this.locator.substring(oldIndex);
        }
        if (queryIndex == 0) {
            return null;
        }
        this.index = queryIndex + 1;
        return this.locator.substring(oldIndex, queryIndex);
    }

    public String getParameter() {
        String token;
        int eq;
        if (this.index >= this.length) {
            return null;
        }
        int ampIndex = this.locator.indexOf("&", this.index);
        if (ampIndex < 0) {
            ampIndex = this.length;
        }
        if ((eq = (token = this.locator.substring(this.index, ampIndex)).indexOf("=")) < 1 || eq == token.length() - 1) {
            return null;
        }
        String key = token.substring(0, eq);
        this.value = token.substring(eq + 1);
        this.index = ampIndex + 1;
        return key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasMore() {
        return this.index < this.length;
    }
}

