/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

public final class ZCamera {
    private int peer = 0;

    private native int nOpen();

    private native void nClose(int var1);

    private native int nStart(int var1, int var2, int var3);

    private native void nStop(int var1);

    private native int nGetImage(int var1, byte[] var2, int var3, int var4);

    synchronized boolean open() {
        if (this.peer != 0) {
            return true;
        }
        this.peer = this.nOpen();
        return this.peer != 0;
    }

    synchronized void close() {
        if (this.peer != 0) {
            this.nClose(this.peer);
            this.peer = 0;
        }
    }

    synchronized void start(int width, int height) {
        if (this.peer != 0 && this.nStart(this.peer, width, height) == 0) {
            throw new OutOfMemoryError("Error allocating native memory");
        }
    }

    synchronized void stop() {
        if (this.peer != 0) {
            this.nStop(this.peer);
        }
    }

    synchronized int getImage(byte[] data, int offset, int length) {
        if (this.peer != 0) {
            data[offset] = 0;
            data[offset + length - 1] = 0;
            return this.nGetImage(this.peer, data, offset, length);
        }
        return 0;
    }
}

