/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

class WaveOut {
    int peer = 0;

    WaveOut() {
    }

    native int nOpen(int var1, int var2, int var3, boolean var4, boolean var5);

    native int nWrite(int var1, byte[] var2, int var3, int var4);

    native int nCommon(int var1, int var2, int var3);

    public boolean open(int sampleRate, int bits, int channels, boolean signed, boolean bigEndian) {
        this.peer = this.nOpen(sampleRate, bits, channels, signed, bigEndian);
        return this.peer != 0;
    }

    public int write(byte[] data, int offset, int len) {
        return this.nWrite(this.peer, data, offset, len);
    }

    public void pause() {
        this.nCommon(this.peer, 1, 0);
    }

    public void resume() {
        this.nCommon(this.peer, 2, 0);
    }

    public void flush() {
        this.nCommon(this.peer, 3, 0);
    }

    public int drain() {
        return this.nCommon(this.peer, 4, 0);
    }

    public synchronized void close() {
        this.nCommon(this.peer, 5, 0);
        this.peer = 0;
    }

    public synchronized boolean isOpen() {
        return this.peer != 0;
    }

    public void setVolume(int level) {
        if (this.peer == 0) {
            return;
        }
        this.nCommon(this.peer, 7, level);
    }

    public int getVolume() {
        int vol = this.nCommon(this.peer, 8, 0);
        return vol;
    }

    public synchronized long getMediaTime() {
        return this.nCommon(this.peer, 15, 0);
    }

    public synchronized void setMediaTime(long mediaTime) {
        this.nCommon(this.peer, 16, (int)mediaTime);
    }

    void setRate(int rate) {
        if (this.peer == 0) {
            return;
        }
        this.nCommon(this.peer, 17, rate);
    }
}

