/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.MIDICtrl;
import com.sun.mmedia.MIDIOut;
import com.sun.mmedia.MetaCtrl;
import com.sun.mmedia.VolCtrl;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.MIDIControl;

public class MIDIPlayer
extends BasicPlayer
implements Runnable {
    private static final boolean DEBUG = false;
    private static final boolean HAS_SX = true;
    private static final boolean HAS_META = true;
    private static final boolean HAS_NATIVE_SORT = false;
    private static final boolean HAS_SP_MIDI = true;
    private long duration = -1L;
    protected MIDIOut midiOut = new MIDIOut();
    protected VolCtrl voc;
    protected MIDIControl mic;
    private MetaCtrl mec;
    private static Hashtable metaMap;
    private boolean isStandAlone;
    private boolean canSendLong = true;
    private Thread playThread;
    private boolean started;
    private boolean interrupted;
    private Object playLock = new Object();
    private int resolution;
    private int titleTagCount;
    private int kTrack = -1;
    private StringBuffer kString;
    private int[] events;
    private int eventCount;
    private int[] tempoEvents;
    private int tempoEventCount;
    private int[] longEvents;
    private Object[] longData;
    private int longEventCount;
    private int playReadPos;
    private long stopTick;
    private int tempoSnapshotUs;
    private int tempoSnapshotIndex;
    private int lastLongIndex;
    private static final String MIDI_LYRICS_EVENT = "com.sun.midi.lyrics";
    private static final int BUFFER_SIZE = 128;
    private byte[] intArray = new byte[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setToneSequence(int[] events, int evtLen, int tempo, int resolution) {
        this.isStandAlone = false;
        Object object = this.playLock;
        synchronized (object) {
            this.resolution = resolution;
            this.duration = -1L;
            this.events = events;
            this.eventCount = evtLen >> 1;
            this.tempoEventCount = 0;
            this.addTempoEvent(0, MIDIOut.convertTempo(tempo * 1000));
            this.longData = null;
            this.longEventCount = 0;
            this.longEvents = null;
            this.lastLongIndex = 0;
            this.playReadPos = 0;
            this.midiOut.setTickPosition(0L);
            this.midiOut.setTempo(tempo * 1000);
            if (this.eventCount > 0) {
                this.sendEvent("durationUpdated", new Long(this.getDuration()));
            }
        }
    }

    protected void doRealize() throws MediaException {
        this.eventQueueSize = 40;
        if (this.source == null) {
            this.isStandAlone = true;
        } else {
            try {
                if (!(this.events != null && this.tempoEvents != null || this.readSMF())) {
                    throw new MediaException("not a MIDI file");
                }
                this.midiOut.mSMFTempo = this.tempoEvents[1];
            }
            catch (IOException e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void doPrefetch() throws MediaException {
        if (!this.midiOut.midiOpen()) {
            throw new MediaException("error opening MIDI/tone device");
        }
        if (this.voc != null) {
            int level = this.voc.getLevel();
            if (this.voc.isMuted()) {
                this.doSetLevel(0);
            } else if (level != -1) {
                this.doSetLevel(level);
            }
            if (level < 0) {
                this.voc.setLevel(this.doSetLevel(-1));
            }
        }
        if (!this.isStandAlone && !this.midiOut.seqOpen(this.resolution)) {
            this.midiOut.midiClose();
            throw new MediaException("error opening MIDI sequencer");
        }
        this.interrupted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doStart() {
        Object object = this.playLock;
        synchronized (object) {
            this.started = true;
            if (this.playThread == null) {
                this.playThread = new Thread(this);
                this.playThread.setPriority(9);
                this.playThread.start();
            } else {
                this.playLock.notifyAll();
            }
            this.midiOut.resume();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Object object = this.playLock;
        synchronized (object) {
            if (this.started) {
                this.started = false;
                this.midiOut.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeallocate() {
        Object object = this.playLock;
        synchronized (object) {
            this.interrupted = true;
            this.playLock.notifyAll();
            if (this.playThread != null) {
                try {
                    this.playLock.wait(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.midiOut.seqClose();
        this.midiOut.midiClose();
        if (!this.isStandAlone) {
            this.playReadPos = this.tick2index(this.events, this.eventCount, this.midiOut.getTickPosition());
        }
    }

    protected void doClose() {
        this.events = null;
        this.tempoEvents = null;
        this.longEvents = null;
        this.longData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doSetMediaTime(long now) throws MediaException {
        if (this.isStandAlone) {
            throw new MediaException("no media");
        }
        int[] tempo = new int[1];
        long tick = this.time2tick(now, tempo);
        int newReadPos = this.tick2index(this.events, this.eventCount, tick);
        Object object = this.playLock;
        synchronized (object) {
            this.midiOut.setTempo(MIDIOut.convertTempo(tempo[0]));
            this.midiOut.setTickPosition(tick);
            this.playReadPos = newReadPos;
            this.playLock.notifyAll();
        }
        return this.getMediaTime();
    }

    protected void doSetStopTime(long time) {
        this.stopTick = time == Long.MAX_VALUE ? (long)this.getTickLength() : this.time2tick(time, null);
    }

    public long doGetDuration() {
        if (this.duration == -1L && this.getState() >= 200) {
            this.duration = this.tick2time(this.getTickLength());
        }
        return this.duration;
    }

    public long doGetMediaTime() {
        return this.tick2time(this.midiOut.getTickPosition());
    }

    public String getContentType() {
        this.chkClosed(true);
        if (this.isStandAlone) {
            return "audio/midi";
        }
        return super.getContentType();
    }

    protected Control doGetControl(String type) {
        if (type.startsWith("javax.microedition.media.control.")) {
            if (type.endsWith("VolumeControl") && this.midiOut != null && this.midiOut.getVolume() >= 0) {
                if (this.voc == null) {
                    this.voc = new VolCtrl(this);
                    if (this.midiOut.midiIsOpen()) {
                        this.voc.level = this.doSetLevel(-1);
                    }
                }
                return this.voc;
            }
            if (type.endsWith("MIDIControl")) {
                if (this.mic == null) {
                    this.mic = new MIDICtrl(this.midiOut);
                }
                return this.mic;
            }
            if (!this.isStandAlone && this.getState() != 100) {
                if (type.endsWith("StopTimeControl")) {
                    return this;
                }
                if (type.endsWith("TempoControl") || type.endsWith("RateControl") || type.endsWith("PitchControl")) {
                    return this.midiOut;
                }
                if (type.endsWith("MetaDataControl")) {
                    return this.mec;
                }
            }
        }
        return null;
    }

    private long tick2time(long tick) {
        long us = 0L;
        int doubleTempoEventCount = this.tempoEventCount << 1;
        if (this.tempoSnapshotIndex <= 0 || this.tempoSnapshotIndex >= doubleTempoEventCount || (long)this.tempoEvents[this.tempoSnapshotIndex] > tick) {
            this.tempoSnapshotUs = 0;
            this.tempoSnapshotIndex = 0;
        }
        if (doubleTempoEventCount > 1) {
            for (int i = this.tempoSnapshotIndex + 2; i < doubleTempoEventCount && (long)this.tempoEvents[i] <= tick; ++i) {
                this.tempoSnapshotUs = (int)((long)this.tempoSnapshotUs + this.ticks2microsec(this.tempoEvents[i] - this.tempoEvents[i - 2], this.tempoEvents[i - 1]));
                this.tempoSnapshotIndex = i++;
            }
            us = (long)this.tempoSnapshotUs + this.ticks2microsec(tick - (long)this.tempoEvents[this.tempoSnapshotIndex], this.tempoEvents[this.tempoSnapshotIndex + 1]);
        }
        return us;
    }

    private long time2tick(long time, int[] tempo) {
        int i;
        long us = 0L;
        long tick = 0L;
        boolean newReadPos = false;
        int doubleTempoEventCount = this.tempoEventCount << 1;
        if (time > 0L && doubleTempoEventCount > 0) {
            long nextTime;
            for (i = 2; i < doubleTempoEventCount && (nextTime = us + this.ticks2microsec(this.tempoEvents[i] - this.tempoEvents[i - 2], this.tempoEvents[i - 1])) <= time; ++i) {
                us = nextTime;
                ++i;
            }
            tick = (long)this.tempoEvents[i - 2] + this.microsec2ticks(time - us, this.tempoEvents[i - 1]);
        }
        if (tempo != null) {
            tempo[0] = this.tempoEvents[i - 1];
        }
        return tick;
    }

    private int tick2index(int[] array, int count, long tick) {
        int ret = 0;
        if (tick > 0L) {
            int t;
            int low = 0;
            int high = count - 1;
            while (low < high && (long)(t = array[ret = low + high & 0xFFFFFFFE]) != tick) {
                if ((long)t < tick) {
                    if (low == high - 1) {
                        ++ret;
                        ++ret;
                        break;
                    }
                    low = ret >> 1;
                    continue;
                }
                high = ret >> 1;
            }
        }
        return ret;
    }

    private int getTickLength() {
        if (this.eventCount > 0) {
            return this.events[(this.eventCount << 1) - 2] + 1;
        }
        return 0;
    }

    private boolean readSMF() throws IOException, MediaException {
        this.addTempoEvent(0, 500000);
        this.longEventCount = 0;
        if (this.readInt() != 1297377380) {
            return false;
        }
        int length = this.readInt();
        short fileType = this.readShort();
        int trackCount = this.readShort();
        this.resolution = this.readShort();
        if (this.resolution < 0) {
            return false;
        }
        if (trackCount <= 0 || fileType < 0 || fileType > 1) {
            return false;
        }
        if (length > 6) {
            this.skipFully(length - 6);
        }
        this.events = new int[4096];
        int currWritePos = 0;
        for (int currTrack = 1; currTrack <= trackCount; ++currTrack) {
            int trackLength;
            while (true) {
                int magic = this.readInt();
                trackLength = this.readInt();
                if (magic == 1297379947) break;
                this.skipFully(trackLength);
            }
            int currReadTick = 0;
            int runStatus = 0;
            long trackLimit = this.stream.tell() + (long)trackLength;
            while (this.stream.tell() < trackLimit) {
                boolean ignoreEvent;
                int thisStatus;
                int special;
                int data2;
                int data1;
                block25: {
                    int byteValue;
                    block24: {
                        if (currWritePos >= this.events.length) {
                            this.events = this.grow(this.events, currWritePos, 8192);
                            System.gc();
                        }
                        this.events[currWritePos] = currReadTick += this.readVarInt();
                        data1 = -1;
                        data2 = 0;
                        special = 0;
                        byteValue = this.readByte();
                        thisStatus = runStatus;
                        if (byteValue >= 128) {
                            thisStatus = byteValue;
                            if (byteValue < 240) {
                                runStatus = byteValue;
                            }
                        } else {
                            data1 = byteValue;
                        }
                        ignoreEvent = false;
                        if ((thisStatus & 0xF0) != 240) break block24;
                        switch (thisStatus) {
                            case 240: 
                            case 247: {
                                int sxLength = this.readVarInt();
                                data1 = 0;
                                data2 = 0;
                                thisStatus = this.addLongEvent(currReadTick, thisStatus, sxLength, currTrack);
                                special = 3;
                                break block25;
                            }
                            case 255: {
                                int metaType = this.readByte();
                                int metaLength = this.readVarInt();
                                data1 = 0;
                                data2 = 0;
                                thisStatus = this.addLongEvent(currReadTick, metaType, metaLength, currTrack);
                                special = metaType == 81 && metaLength == 3 ? 1 : 2;
                                if (thisStatus == -1) {
                                    ignoreEvent = true;
                                }
                                break block25;
                            }
                            default: {
                                throw new MediaException("Invalid status byte: " + byteValue);
                            }
                        }
                    }
                    switch (thisStatus & 0xF0) {
                        case 128: 
                        case 144: 
                        case 160: 
                        case 176: 
                        case 224: {
                            if (data1 == -1) {
                                data1 = this.readByte();
                            }
                            data2 = this.readByte();
                            break;
                        }
                        case 192: 
                        case 208: {
                            if (data1 != -1) break;
                            data1 = this.readByte();
                            break;
                        }
                        default: {
                            throw new MediaException("Invalid status byte: " + byteValue);
                        }
                    }
                }
                if (ignoreEvent) continue;
                this.events[currWritePos + 1] = thisStatus | data1 << 8 | data2 << 16 | special << 24;
                currWritePos += 2;
            }
        }
        this.eventCount = currWritePos >> 1;
        if (trackCount > 1) {
            this.sort(this.events, 0, this.eventCount - 1);
            if (this.longEvents != null) {
                this.sort(this.longEvents, 0, this.longEventCount - 1);
                if (this.kString != null) {
                    this.mec.put("lyrics", this.kString.toString());
                    this.kString = null;
                }
            }
        }
        this.applySP_MIDI();
        return true;
    }

    private int[] grow(int[] data, int validData, int growBy) {
        if (data == null || validData == data.length) {
            int[] newData = new int[validData + growBy];
            if (data != null) {
                System.arraycopy(data, 0, newData, 0, validData);
            }
            data = newData;
        }
        return data;
    }

    private void addTempoEvent(int tick, int tempo) {
        if (tick == 0) {
            this.tempoEventCount = 0;
        }
        int doubleEvtCnt = this.tempoEventCount << 1;
        this.tempoEvents = this.grow(this.tempoEvents, doubleEvtCnt, 8);
        this.tempoEvents[doubleEvtCnt] = tick;
        this.tempoEvents[doubleEvtCnt + 1] = tempo;
        ++this.tempoEventCount;
    }

    private int addLongEvent(int tick, int type, int length, int currTrack) throws IOException, MediaException {
        int ret = 0;
        byte[] data = new byte[length + 1];
        data[0] = (byte)(type & 0xFF);
        if (length > 0) {
            this.readFully(data, 1, length);
        }
        String value = null;
        switch (type) {
            case 0: 
            case 32: 
            case 47: 
            case 84: {
                return -1;
            }
        }
        String key = null;
        switch (type) {
            case 1: {
                if (length <= 0) break;
                if (data[1] == 64) {
                    if (length <= 2) break;
                    key = "@";
                    break;
                }
                if (currTrack != this.kTrack) break;
                key = "";
                break;
            }
            case 2: {
                key = "copyright";
                break;
            }
            case 3: {
                key = "track" + currTrack;
                break;
            }
            case 4: {
                key = "instrument" + currTrack;
                break;
            }
            case 8: {
                key = "patch" + currTrack;
                break;
            }
            case 9: {
                key = "device" + currTrack;
            }
        }
        if (key != null) {
            if (this.mec == null) {
                if (metaMap == null) {
                    metaMap = new Hashtable(2);
                    metaMap.put("@L", "language");
                    metaMap.put("@T", "title");
                }
                this.mec = new MetaCtrl(metaMap);
            }
            value = new String(data, 1, length);
            if (type == 1) {
                if (key == "@") {
                    key = new String(data, 1, 2);
                    value = new String(data, 3, length - 2);
                    if (data[2] == 84) {
                        if (this.titleTagCount > 0) {
                            key = "title" + (this.titleTagCount + 1);
                        }
                        ++this.titleTagCount;
                    } else if (data[2] == 76) {
                        key = "language";
                        this.kTrack = currTrack;
                    }
                } else {
                    if (this.kString == null) {
                        this.kString = new StringBuffer();
                    }
                    int pos = this.kString.length();
                    int len = value.length();
                    this.kString.append(value);
                    data = new byte[]{96, (byte)((pos & 0xFF0000) >> 16), (byte)((pos & 0xFF00) >> 8), (byte)(pos & 0xFF), (byte)((len & 0xFF0000) >> 16), (byte)((len & 0xFF00) >> 8), (byte)(len & 0xFF)};
                    key = null;
                }
            }
        }
        if (key != null && value != "") {
            this.mec.put(key, value);
        } else {
            if (this.longData == null || this.longEventCount >= this.longData.length) {
                Object[] newLongData = new Object[this.longEventCount + 16];
                if (this.longData != null) {
                    System.arraycopy(this.longData, 0, newLongData, 0, this.longData.length);
                }
                this.longData = newLongData;
                this.longEvents = this.grow(this.longEvents, this.longEventCount << 1, 32);
            }
            this.longData[this.longEventCount] = data;
            this.longEvents[this.longEventCount << 1] = tick;
            this.longEvents[(this.longEventCount << 1) + 1] = this.longEventCount;
            ++this.longEventCount;
            if (type == 81 && length == 3) {
                ret = (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                this.addTempoEvent(tick, ret);
            }
        }
        return ret;
    }

    private void applySP_MIDI() {
        int devicePolyphony = this.midiOut.getPolyphony();
        int deviceSoundSet = this.midiOut.getSoundSet();
        boolean[] mipUnmuted = null;
        int[] lastBankChangeIndex = new int[32];
        boolean mapChannel11To10 = false;
        int currLong = 0;
        int currEvent = 0;
        int doubleEventCount = this.eventCount << 1;
        for (int i = 0; i < 32; ++i) {
            lastBankChangeIndex[i] = -1;
        }
        while (currEvent < doubleEventCount) {
            while (currLong < this.longEventCount && this.longEvents[currLong * 2] <= this.events[currEvent]) {
                byte[] data = (byte[])this.longData[this.longEvents[currLong * 2 + 1]];
                if (data != null && data.length > 5 && (data[0] & 0xFF) == 240 && data[1] == 127 && data[3] == 11 && data[4] == 1 && (data[2] == 0 || data[2] == 127)) {
                    mipUnmuted = new boolean[16];
                    for (int mip = 5; mip < data.length - 1; mip += 2) {
                        byte channel = data[mip];
                        if ((channel & 0xFFFFFFF0) != 0 || data[mip + 1] > devicePolyphony) continue;
                        mipUnmuted[channel] = true;
                    }
                }
                ++currLong;
            }
            int type = this.events[currEvent + 1] & 0xF0;
            int channel = this.events[currEvent + 1] & 0xF;
            if (type == 176) {
                int ccType = (this.events[currEvent + 1] & 0x7F00) >> 8;
                if (ccType == 0) {
                    lastBankChangeIndex[channel * 2] = currEvent + 1;
                } else if (ccType == 32) {
                    lastBankChangeIndex[channel * 2 + 1] = currEvent + 1;
                } else {
                    currEvent += 2;
                    continue;
                }
                int msbIndex = lastBankChangeIndex[channel * 2];
                int lsbIndex = lastBankChangeIndex[channel * 2 + 1];
                if (msbIndex >= 0 && lsbIndex >= 0) {
                    int msb = this.events[msbIndex] >> 16 & 0x7F;
                    int lsb = this.events[lsbIndex] >> 16 & 0x7F;
                    if (deviceSoundSet == 1 && (msb == 120 || msb == 121)) {
                        int n = lsbIndex;
                        this.events[n] = this.events[n] & 0xFFFF;
                    }
                    if (deviceSoundSet == 1 && channel == 10) {
                        mapChannel11To10 = msb == 120;
                    }
                    lastBankChangeIndex[channel * 2] = -1;
                    lastBankChangeIndex[channel * 2 + 1] = -1;
                }
            }
            switch (type) {
                case 128: 
                case 144: {
                    if (mipUnmuted != null && mipUnmuted[channel] == false) {
                        this.events[currEvent + 1] = 0;
                        break;
                    }
                }
                case 160: 
                case 176: 
                case 192: 
                case 208: 
                case 224: {
                    if (!mapChannel11To10 || channel != 10) break;
                    this.events[currEvent + 1] = this.events[currEvent + 1] & 0xFFFFF0 | 9;
                }
            }
            currEvent += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean statusOK = true;
        while (true) {
            int doubleEventCount = this.eventCount << 1;
            this.doSetStopTime(this.stopTime);
            int lastTick = this.getTickLength();
            long currTick = this.midiOut.getTickPosition();
            int stopReason = 0;
            while (!this.interrupted && this.started && statusOK) {
                int wlen;
                currTick = this.midiOut.getTickPosition();
                if (currTick >= (long)lastTick) {
                    stopReason = 1;
                    break;
                }
                if (currTick >= this.stopTick) {
                    stopReason = 2;
                    break;
                }
                long callback = this.midiOut.getCallback();
                if (callback != -1L && this.longEventCount > 0) {
                    int lastLongTick = this.longEvents[this.lastLongIndex];
                    if ((long)lastLongTick > callback) {
                        this.lastLongIndex = this.tick2index(this.longEvents, this.longEventCount, callback);
                    }
                    while (this.lastLongIndex < this.longEventCount << 1 && (long)(lastLongTick = this.longEvents[this.lastLongIndex]) <= currTick) {
                        if ((long)lastLongTick >= callback) {
                            byte[] data = (byte[])this.longData[this.longEvents[this.lastLongIndex + 1]];
                            int type = data[0] & 0xFF;
                            if (type == 240 || type == 247) {
                                if (this.canSendLong && this.midiOut.longMsg(data, 0, data.length) < 0) {
                                    this.canSendLong = false;
                                }
                            } else {
                                this.sendEvent(MIDI_LYRICS_EVENT, this.longData[this.longEvents[this.lastLongIndex + 1]]);
                            }
                        }
                        ++this.lastLongIndex;
                        ++this.lastLongIndex;
                    }
                    this.lastLongIndex -= 2;
                    if (this.lastLongIndex < 0) {
                        this.lastLongIndex = 0;
                    }
                }
                if ((wlen = doubleEventCount - this.playReadPos) > 0) {
                    if (wlen > 128) {
                        wlen = 128;
                    }
                    if ((wlen = this.midiOut.write(this.events, this.playReadPos, wlen)) == -1) {
                        statusOK = false;
                        break;
                    }
                    this.playReadPos += wlen;
                }
                if (wlen >= 128) continue;
                Object object = this.playLock;
                synchronized (object) {
                    if (this.interrupted || !statusOK) {
                        break;
                    }
                    try {
                        this.playLock.wait(30L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            this.doStop();
            if (currTick >= (long)lastTick) {
                this.midiOut.setTickPosition(lastTick);
                if (stopReason == 1) {
                    this.sendEvent("endOfMedia", new Long(this.getMediaTime()));
                }
            } else if (stopReason == 2) {
                this.satev();
            }
            Object object = this.playLock;
            synchronized (object) {
                if (this.interrupted || !statusOK) {
                    break;
                }
                while (!this.started && !this.interrupted && statusOK) {
                    try {
                        this.playLock.wait();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        Object object = this.playLock;
        synchronized (object) {
            this.playThread = null;
            this.playLock.notifyAll();
        }
    }

    protected int readByte() throws IOException, MediaException {
        this.readFully(this.intArray, 0, 1);
        return this.intArray[0] & 0xFF;
    }

    protected int readInt() throws IOException, MediaException {
        this.readFully(this.intArray, 0, 4);
        return (this.intArray[0] & 0xFF) << 24 | (this.intArray[1] & 0xFF) << 16 | (this.intArray[2] & 0xFF) << 8 | this.intArray[3] & 0xFF;
    }

    protected short readShort() throws IOException, MediaException {
        this.readFully(this.intArray, 0, 2);
        return (short)((this.intArray[0] & 0xFF) << 8 | this.intArray[1] & 0xFF);
    }

    private int readVarInt() throws IOException, MediaException {
        int result = 0;
        int curr = 0;
        for (int i = 0; i < 6; ++i) {
            curr = this.readByte();
            result = (result << 7) + (curr & 0x7F);
            if ((curr & 0x80) == 0) break;
        }
        if ((curr & 0x80) != 0) {
            throw new MediaException("corrupt MIDI file (vli)");
        }
        return result;
    }

    private long ticks2microsec(long tick, int smfTempo) {
        return tick * (long)smfTempo / (long)this.resolution;
    }

    private long microsec2ticks(long us, int smfTempo) {
        return ((us * (long)this.resolution << 1) + (long)smfTempo) / ((long)smfTempo << 1);
    }

    private void sort(int[] array, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = array[lo0 + hi0 & 0xFFFFFFFE];
            while (lo <= hi) {
                while (lo < hi0 && array[lo << 1] < mid) {
                    ++lo;
                }
                while (hi > lo0 && array[hi << 1] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int i = lo << 1;
                int j = hi << 1;
                int T = array[i];
                array[i] = array[j];
                array[j] = T;
                T = array[++i];
                array[i] = array[++j];
                array[j] = T;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.sort(array, lo0, hi);
            }
            if (lo < hi0) {
                this.sort(array, lo, hi0);
            }
        }
    }

    int doSetLevel(int l) {
        if (this.midiOut.midiIsOpen()) {
            if (l != -1) {
                this.midiOut.setVolume(l * 655);
            }
            return this.midiOut.getVolume() / 655;
        }
        return l;
    }
}

