/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.MIDIOut;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.MIDIControl;

class MIDICtrl
implements MIDIControl {
    private MIDIOut midiOut;
    private static final boolean DEBUG = false;

    MIDICtrl(MIDIOut midiOut) {
        this.midiOut = midiOut;
    }

    private void checkChannel(int c) {
        if ((c & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("channel out of bounds (0-15)");
        }
    }

    private void check7bit(int d, String err) {
        if ((d & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(err + " out of bounds (0-127)");
        }
    }

    private void checkState() {
        if (!this.midiOut.midiIsOpen()) {
            throw new IllegalStateException("player is not prefetched");
        }
    }

    public boolean isBankQuerySupported() {
        return false;
    }

    public int[] getProgram(int channel) throws MediaException {
        throw new MediaException("not implemented");
    }

    public int getChannelVolume(int channel) {
        this.checkState();
        this.checkChannel(channel);
        return this.midiOut.getChannelVolume(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgram(int channel, int bank, int program) {
        this.checkChannel(channel);
        this.check7bit(program, "program");
        if (bank == -1) {
            bank = 0;
        }
        if (bank < 0 || bank > 16383) {
            throw new IllegalArgumentException("bank out of bounds (-1, or 0-16383)");
        }
        MIDIOut mIDIOut = this.midiOut;
        synchronized (mIDIOut) {
            try {
                this.shortMidiEvent(0xB0 | channel, 0, bank >> 7);
                this.shortMidiEvent(0xB0 | channel, 32, bank & 0x7F);
                this.shortMidiEvent(0xC0 | channel, program, 0);
            }
            catch (IllegalArgumentException ie) {
                // empty catch block
            }
        }
    }

    public void setChannelVolume(int channel, int volume) {
        this.checkChannel(channel);
        this.check7bit(volume, "volume");
        try {
            this.shortMidiEvent(0xB0 | channel, 7, volume);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public int[] getBankList(boolean custom) throws MediaException {
        throw new MediaException("not implemented");
    }

    public int[] getProgramList(int bank) throws MediaException {
        throw new MediaException("not implemented");
    }

    public String getProgramName(int bank, int prog) throws MediaException {
        throw new MediaException("not implemented");
    }

    public String getKeyName(int bank, int prog, int key) throws MediaException {
        throw new MediaException("not implemented");
    }

    public void shortMidiEvent(int type, int data1, int data2) {
        this.checkState();
        if ((type & 0xFFFFFF00) != 0 || type < 128 || type == 240 || type == 247) {
            throw new IllegalArgumentException("type out of bounds");
        }
        this.check7bit(data1, "data1");
        this.check7bit(data2, "data2");
        this.midiOut.shortMsg(type, data1, data2);
    }

    public int longMidiEvent(byte[] data, int offset, int length) {
        this.checkState();
        if (data == null || offset < 0 || length < 0 || offset + length > data.length || offset + length < 0) {
            throw new IllegalArgumentException("invalid parameter");
        }
        return this.midiOut.longMsg(data, offset, length);
    }
}

