/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.CameraPlayer;
import com.sun.mmedia.EvtQ;
import com.sun.mmedia.MIDIPlayer;
import com.sun.mmedia.MIDletPauseListener;
import com.sun.mmedia.MidiTonePlayer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.media.protocol.SourceStream;

public abstract class BasicPlayer
implements Player,
TimeBase,
StopTimeControl {
    private static int pcount = -1;
    private static Hashtable mplayers = new Hashtable(4);
    private static Object idLock = new Object();
    int state = 100;
    int loopCountSet = 1;
    int loopCount;
    boolean EOM = false;
    boolean loopAfterEOM = false;
    Vector listeners = new Vector(2);
    EvtQ evtQ = null;
    Object evtLock = new Object();
    protected int pID = 0;
    protected static final String pkgName = "javax.microedition.media.control.";
    protected static final String fpcName = "FramePositioningControl";
    protected static final String mdcName = "MetaDataControl";
    protected static final String micName = "MIDIControl";
    protected static final String picName = "PitchControl";
    protected static final String racName = "RateControl";
    protected static final String recName = "RecordControl";
    protected static final String stcName = "StopTimeControl";
    protected static final String tecName = "TempoControl";
    protected static final String guiName = "GUIControl";
    protected static final String vicName = "VideoControl";
    protected static final String rtspName = "RtspControl";
    protected static final String tocName = "ToneControl";
    protected static final String vocName = "VolumeControl";
    private static final String[] allCtrls = new String[]{"FramePositioningControl", "MetaDataControl", "MIDIControl", "PitchControl", "RateControl", "RecordControl", "StopTimeControl", "TempoControl", "GUIControl", "VideoControl", "RtspControl", "ToneControl", "VolumeControl"};
    protected DataSource source;
    protected SourceStream stream;
    private TimeBase timeBase = this;
    protected long stopTime = Long.MAX_VALUE;
    int eventQueueSize = 20;
    private boolean closedDelivered;
    private static MIDletPauseListener pauseListener = null;
    private static boolean vmPaused = false;
    private long origin = 0L;
    private long offset = 0L;
    private long time = 0L;
    private long sysOffset = 0L;
    private boolean useSystemTime = true;
    private Object timeLock = new Object();
    int NOT_SEEKABLE = 0;
    int SEEKABLE_TO_START = 1;
    int RANDOM_ACCESSIBLE = 2;
    private static final int MAX_SKIP = 2048;
    private static byte[] skipArray;

    public static void setMIDletPauseListener(MIDletPauseListener listener) {
        if (pauseListener == null) {
            pauseListener = listener;
        }
    }

    public static void pauseStateEntered(MIDletPauseListener listener, boolean paused) {
        if (listener != pauseListener) {
            return;
        }
        vmPaused = paused;
        if (vmPaused) {
            Enumeration e = mplayers.elements();
            while (e.hasMoreElements()) {
                BasicPlayer p = (BasicPlayer)e.nextElement();
                if (p.getState() != 400) continue;
                BasicPlayer.notifyPauseListener("Player");
            }
        }
    }

    public static void notifyPauseListener(String msg) {
        if (vmPaused && pauseListener != null) {
            pauseListener.reportActivity(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicPlayer() {
        this.sysOffset = System.currentTimeMillis() * 1000L;
        Object object = idLock;
        synchronized (object) {
            this.pID = pcount = (pcount + 1) % Short.MAX_VALUE;
        }
        mplayers.put(new Integer(this.pID), this);
    }

    protected void chkClosed(boolean unrealized) {
        if (this.state == 0 || unrealized && this.state == 100) {
            throw new IllegalStateException("Can't invoke the method at the " + (this.state == 0 ? "closed" : "unrealized") + " state");
        }
    }

    public void setLoopCount(int count) {
        this.chkClosed(false);
        if (this.state == 400) {
            throw new IllegalStateException("setLoopCount");
        }
        if (count == 0 || count < -1) {
            throw new IllegalArgumentException("setLoopCount");
        }
        this.loopCountSet = count;
        this.loopCount = count;
    }

    public synchronized void realize() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 200) {
            return;
        }
        if (this.source != null && this.stream == null) {
            this.stream = this.source.getStreams()[0];
        } else if (!(this instanceof MidiTonePlayer || this instanceof MIDIPlayer || this instanceof CameraPlayer)) {
            this.state = 100;
            throw new MediaException("Unable to realize");
        }
        this.doRealize();
        this.state = 200;
    }

    protected abstract void doRealize() throws MediaException;

    public synchronized void prefetch() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 300) {
            return;
        }
        if (this.state < 200) {
            this.realize();
        }
        this.doPrefetch();
        this.state = 300;
    }

    protected abstract void doPrefetch() throws MediaException;

    public synchronized void start() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 400) {
            return;
        }
        if (this.state < 200) {
            this.realize();
        }
        if (this.state < 300) {
            this.prefetch();
        }
        this.updateTimeBase(true);
        if (this.stopTime != Long.MAX_VALUE && this.stopTime <= this.getMediaTime()) {
            this.satev();
            return;
        }
        if (this.EOM) {
            this.setMediaTime(0L);
        }
        if (!this.doStart()) {
            throw new MediaException("start");
        }
        this.state = 400;
        this.sendEvent("started", new Long(this.getMediaTime()));
        BasicPlayer.notifyPauseListener("Player");
        this.doPostStart();
    }

    protected abstract boolean doStart();

    protected void doPostStart() {
    }

    public synchronized void stop() throws MediaException {
        this.chkClosed(false);
        this.loopAfterEOM = false;
        if (this.state < 400) {
            return;
        }
        this.doStop();
        this.updateTimeBase(false);
        this.state = 300;
        this.sendEvent("stopped", new Long(this.getMediaTime()));
    }

    protected abstract void doStop() throws MediaException;

    public synchronized void deallocate() {
        this.chkClosed(false);
        this.loopAfterEOM = false;
        if (this.state < 300) {
            return;
        }
        if (this.state == 400) {
            try {
                this.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        this.doDeallocate();
        this.state = 200;
    }

    protected abstract void doDeallocate();

    public synchronized void close() {
        if (this.state == 0) {
            return;
        }
        this.deallocate();
        this.doClose();
        this.state = 0;
        if (this.source != null) {
            this.source.disconnect();
        }
        this.sendEvent("closed", null);
        mplayers.remove(new Integer(this.pID));
    }

    protected abstract void doClose();

    public synchronized long setMediaTime(long now) throws MediaException {
        long theDur;
        this.chkClosed(true);
        if (now < 0L) {
            now = 0L;
        }
        if (this.state == 400) {
            this.origin = this.getTime();
        }
        if ((theDur = this.doGetDuration()) != -1L && now > theDur) {
            now = theDur;
        }
        long rtn = this.doSetMediaTime(now);
        this.EOM = false;
        if (this.state == 400) {
            this.offset = rtn;
        }
        return rtn;
    }

    protected abstract long doSetMediaTime(long var1) throws MediaException;

    public long getMediaTime() {
        this.chkClosed(false);
        return this.doGetMediaTime();
    }

    protected abstract long doGetMediaTime();

    public int getState() {
        return this.state;
    }

    public long getDuration() {
        this.chkClosed(false);
        return this.doGetDuration();
    }

    protected abstract long doGetDuration();

    public void addPlayerListener(PlayerListener playerListener) {
        this.chkClosed(false);
        if (playerListener != null) {
            this.listeners.addElement(playerListener);
        }
    }

    public void removePlayerListener(PlayerListener playerListener) {
        this.chkClosed(false);
        this.listeners.removeElement(playerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(String evt, Object evtData) {
        if (this.listeners.size() == 0 && evt != "endOfMedia" && evt != "closed" && evt != "error") {
            return;
        }
        if (this.closedDelivered) {
            return;
        }
        Object object = this.evtLock;
        synchronized (object) {
            if (this.evtQ == null) {
                this.evtQ = new EvtQ(this);
            }
            this.evtQ.sendEvent(evt, evtData);
        }
        if (evt == "closed" || evt == "error") {
            this.closedDelivered = true;
        }
    }

    synchronized void doLoop() {
        block7: {
            if (this.loopCount > 1 || this.loopCount == -1) {
                try {
                    if (this.setMediaTime(0L) == 0L) {
                        if (this.loopCount > 1) {
                            --this.loopCount;
                        }
                        this.start();
                        break block7;
                    }
                    this.loopCount = 1;
                }
                catch (MediaException ex) {
                    this.loopCount = 1;
                }
            } else if (this.loopCountSet > 1) {
                this.loopCount = this.loopCountSet;
            }
        }
        this.loopAfterEOM = false;
    }

    public final Control[] getControls() {
        this.chkClosed(true);
        Vector<Control> v = new Vector<Control>(3);
        for (int i = 0; i < allCtrls.length; ++i) {
            Control c = this.getControl(allCtrls[i]);
            if (c == null || v.contains(c)) continue;
            v.addElement(c);
        }
        Object[] ret = new Control[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public Control getControl(String type) {
        this.chkClosed(true);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.indexOf(46) < 0) {
            for (int i = 0; i < allCtrls.length; ++i) {
                if (allCtrls[i].equals(type)) {
                    return this.doGetControl(pkgName + type);
                }
                if (!allCtrls[i].endsWith(type)) continue;
                return this.doGetControl(allCtrls[i]);
            }
        }
        return this.doGetControl(type);
    }

    protected abstract Control doGetControl(String var1);

    public static BasicPlayer get(int pid) {
        return (BasicPlayer)mplayers.get(new Integer(pid));
    }

    int doSetLevel(int ll) {
        return ll;
    }

    public void setSource(DataSource source) throws IOException, MediaException {
        this.source = source;
    }

    public void setTimeBase(TimeBase master) throws MediaException {
        this.chkClosed(true);
        if (this.state == 400) {
            throw new IllegalStateException("Cannot call setTimeBase on a player in the STARTED state");
        }
        if (master == null) {
            return;
        }
        if (master != this) {
            throw new MediaException("Incompatible TimeBase");
        }
    }

    public TimeBase getTimeBase() {
        this.chkClosed(true);
        return this.timeBase;
    }

    public String getContentType() {
        this.chkClosed(true);
        return this.source != null ? this.source.getContentType() : "";
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public synchronized void setStopTime(long time) {
        if (this.state == 400) {
            if (this.stopTime != Long.MAX_VALUE && time != Long.MAX_VALUE) {
                throw new IllegalStateException("StopTime already set");
            }
            if (time < this.getMediaTime()) {
                try {
                    this.doStop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.satev();
                return;
            }
        }
        this.stopTime = time;
        this.doSetStopTime(this.stopTime);
    }

    protected void doSetStopTime(long time) {
    }

    protected void satev() {
        this.updateTimeBase(false);
        this.state = 300;
        this.stopTime = Long.MAX_VALUE;
        this.sendEvent("stoppedAtTime", new Long(this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTime() {
        Object object = this.timeLock;
        synchronized (object) {
            this.time = this.useSystemTime ? this.origin + (System.currentTimeMillis() * 1000L - this.sysOffset) - this.offset : this.origin + this.getMediaTime() - this.offset;
            return this.time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeBase(boolean started) {
        Object object = this.timeLock;
        synchronized (object) {
            this.origin = this.getTime();
            this.useSystemTime = !started;
            this.offset = started ? this.getMediaTime() : System.currentTimeMillis() * 1000L - this.sysOffset;
        }
    }

    protected int readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new IOException("premature end of stream");
        }
        return len;
    }

    protected long skipFully(int numBytes) throws IOException {
        long target = this.stream.tell() + (long)numBytes;
        if (this.stream.getSeekType() == 2) {
            if (this.stream.seek(target) != target) {
                throw new IOException("skipped past end");
            }
            return numBytes;
        }
        if (numBytes < 0) {
            throw new IOException("bad param");
        }
        int toSkip = numBytes;
        int min = numBytes;
        if (min > 2048) {
            min = 2048;
        }
        if (skipArray == null || skipArray.length < min) {
            skipArray = new byte[min];
        }
        while (toSkip > 0) {
            min = toSkip;
            if (min > 2048) {
                min = 2048;
            }
            if (this.stream.read(skipArray, 0, min) < min) {
                throw new IOException("skipped past end");
            }
            toSkip -= min;
        }
        return numBytes;
    }

    protected long seekStrm(long where) throws IOException {
        return this.stream.seek(where);
    }

    protected int getSeekType() {
        return this.stream.getSeekType();
    }

    public static void setMMCreator(Object obj) {
    }
}

