/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.ssl;

import com.sun.midp.ssl.CertStore;
import com.sun.midp.ssl.Handshake;
import com.sun.midp.ssl.In;
import com.sun.midp.ssl.Out;
import com.sun.midp.ssl.Record;
import com.sun.midp.ssl.SSLSecurityInfo;
import com.sun.midp.ssl.X509Certificate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.SecurityInfo;
import javax.microedition.io.StreamConnection;

public class SSLStreamConnection
implements StreamConnection {
    static final int READY = 0;
    static final int OPEN = 1;
    static final int CLOSED = 2;
    private static CertStore trustedCertStore = null;
    private static boolean trustedCertStoreLocked = false;
    private static boolean trustedCertStoreInitialized = false;
    private Record rec = null;
    private In uin = null;
    private Out uout = null;
    private InputStream sin = null;
    private OutputStream sout = null;
    private String host = null;
    private int port = 0;
    private boolean copen = false;
    private X509Certificate serverCert;
    private String cipherSuite;
    int inputStreamState;
    int outputStreamState;

    public static synchronized void setTrustedCertStore(CertStore certStore) {
        if (trustedCertStoreLocked) {
            return;
        }
        trustedCertStore = certStore;
        trustedCertStoreInitialized = true;
    }

    public static synchronized CertStore getTrustedCertStore() {
        if (!trustedCertStoreInitialized) {
            try {
                trustedCertStore = (CertStore)Class.forName("com.sun.midp.ssl.KSImpl").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            trustedCertStoreInitialized = true;
        }
        return trustedCertStore;
    }

    public static synchronized void lockTrustedCertStore() {
        if (trustedCertStore == null) {
            return;
        }
        trustedCertStoreLocked = true;
    }

    public SSLStreamConnection(String string, int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            throw new IllegalArgumentException("SSLStreamConnection: stream missing");
        }
        this.host = string;
        this.port = n;
        this.sin = inputStream;
        this.sout = outputStream;
        this.rec = new Record(1, this.sin, this.sout);
        this.uin = new In(this.rec, this);
        this.uout = new Out(this.rec, this);
        try {
            Handshake handshake = new Handshake(string, n, this.rec);
            handshake.doHandShake((byte)1);
            this.serverCert = handshake.sCert;
            this.cipherSuite = handshake.negSuiteName;
        }
        catch (IOException iOException) {
            this.cleanupIfNeeded();
            throw iOException;
        }
        this.copen = true;
    }

    public synchronized InputStream openInputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        if (this.inputStreamState != 0) {
            throw new IOException("Input stream already opened");
        }
        this.inputStreamState = 1;
        return this.uin;
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        if (this.outputStreamState != 0) {
            throw new IOException("Output stream already opened");
        }
        this.outputStreamState = 1;
        return this.uout;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public synchronized void close() throws IOException {
        if (this.copen) {
            this.copen = false;
            this.cleanupIfNeeded();
        }
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        return new SSLSecurityInfo(this);
    }

    public X509Certificate getServerCertificate() {
        return this.serverCert;
    }

    String getCipherSuite() {
        return this.cipherSuite;
    }

    void cleanupIfNeeded() throws IOException {
        if (this.copen || this.inputStreamState == 1 || this.outputStreamState == 1 || this.rec == null) {
            return;
        }
        this.rec.shutdownConnection();
        this.rec = null;
    }
}

