/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.ssl;

import com.sun.midp.ssl.CryptoException;
import com.sun.midp.ssl.KeyBuilder;
import com.sun.midp.ssl.RSAPrivateKey;
import com.sun.midp.ssl.RSAPublicKey;

final class RSAKey
implements RSAPublicKey,
RSAPrivateKey {
    byte kind;
    short bitsize;
    boolean initOk;
    byte[] exp = null;
    byte[] mod = null;

    RSAKey(byte by, short s) {
        this.kind = by;
        this.bitsize = s;
        this.initOk = false;
    }

    public void clearKey() {
        this.initOk = false;
        this.bitsize = 0;
    }

    public boolean equals(RSAPrivateKey rSAPrivateKey) {
        return this.equals((RSAKey)rSAPrivateKey);
    }

    public boolean equals(RSAPublicKey rSAPublicKey) {
        return this.equals((RSAKey)rSAPublicKey);
    }

    public boolean equals(RSAKey rSAKey) {
        byte[] byArray = new byte[this.exp.length];
        byte[] byArray2 = new byte[this.mod.length];
        if (this.kind != rSAKey.getType()) {
            return false;
        }
        if (rSAKey.getExponent(byArray, (short)0) != this.exp.length) {
            return false;
        }
        if (rSAKey.getModulus(byArray2, (short)0) != this.mod.length) {
            return false;
        }
        int n = 0;
        while (n < this.exp.length) {
            if (byArray[n] != this.exp[n]) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mod.length) {
            if (byArray2[n2] != this.mod[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public short getSize() {
        return (short)(this.bitsize + 63 >>> 6 << 6);
    }

    public byte getType() {
        return this.kind;
    }

    public boolean isInitialized() {
        return this.initOk;
    }

    public short getExponent(byte[] byArray, short s) {
        if (this.kind != 2 && this.kind != 1 || !this.initOk) {
            return 0;
        }
        if (s + this.exp.length > byArray.length) {
            return 0;
        }
        System.arraycopy(this.exp, 0, byArray, s, this.exp.length);
        return (short)this.exp.length;
    }

    public short getModulus(byte[] byArray, short s) {
        if (this.kind != 2 && this.kind != 1 || !this.initOk) {
            return 0;
        }
        if (s + this.mod.length > byArray.length) {
            return 0;
        }
        System.arraycopy(this.mod, 0, byArray, s, this.mod.length);
        return (short)this.mod.length;
    }

    public void setExponent(byte[] byArray, short s, short s2) throws CryptoException {
        if (this.kind != 2 && this.kind != 1) {
            return;
        }
        int n = this.getSize() >>> 3;
        if (s2 > n) {
            throw new CryptoException(2);
        }
        this.exp = new byte[s2];
        System.arraycopy(byArray, s, this.exp, 0, s2);
        if (this.mod != null) {
            this.initOk = true;
        }
    }

    public void setModulus(byte[] byArray, short s, short s2) throws CryptoException {
        if (this.kind != 2 && this.kind != 1) {
            return;
        }
        int n = this.getSize() >>> 3;
        if (s2 > n) {
            throw new CryptoException(2);
        }
        this.mod = new byte[n];
        System.arraycopy(byArray, s, this.mod, n - s2, s2);
        if (this.exp != null) {
            this.initOk = true;
        }
    }

    public String toString() {
        return "[" + this.getSize() + "-bit RSA " + (this.kind == 1 ? "Public" : "Private") + " key, Exponent: 0x" + KeyBuilder.hexEncode(this.exp) + ",  Modulus: 0x" + KeyBuilder.hexEncode(this.mod) + "]";
    }
}

