/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.security;

import com.sun.midp.lcdui.AutomatedEventHandler;
import com.sun.midp.lcdui.EventHandler;
import com.sun.midp.security.ConfirmPermission;
import com.sun.midp.security.Permissions;

public final class SecurityToken {
    public static final String STD_EX_MSG = "Application not authorized to access the restricted API";
    private static boolean firstCaller = true;
    private byte[] permissions;
    private byte[] permissionAsked;
    private byte[] maxPermissionLevels;
    private boolean checkForBlocking = true;

    public SecurityToken(SecurityToken securityToken, byte[][] ApiPermissions) {
        if (firstCaller) {
            firstCaller = false;
        } else {
            securityToken.checkIfPermissionAllowed(0);
        }
        this.maxPermissionLevels = ApiPermissions[0];
        this.permissions = ApiPermissions[1];
        this.permissionAsked = new byte[this.permissions.length];
    }

    private SecurityToken() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkPermission(String permission) {
        boolean found = false;
        SecurityToken securityToken = this;
        synchronized (securityToken) {
            int i;
            for (i = 0; i < 36; ++i) {
                if (!Permissions.getName(i).equals(permission)) continue;
                found = true;
                break;
            }
            if (!found) {
                return 0;
            }
            switch (this.permissions[i]) {
                case 1: 
                case 2: {
                    return 1;
                }
                case 8: {
                    if (this.permissionAsked[i] != 0) {
                        return 1;
                    }
                }
                case 4: 
                case 16: 
                case 64: {
                    return -1;
                }
                case 32: {
                    if (this.permissionAsked[i] != 0) break;
                    return -1;
                }
            }
            return 0;
        }
    }

    public void checkIfPermissionAllowed(int permission) {
        this.checkIfPermissionAllowed(permission, STD_EX_MSG);
    }

    public void checkIfPermissionAllowed(int permission, String exceptionMsg) {
        if (this.permissions == null) {
            return;
        }
        if (permission >= 0 && permission < this.permissions.length && this.permissions[permission] == 1) {
            return;
        }
        throw new SecurityException(exceptionMsg);
    }

    public void checkForPermission(int permission, String title, String question, String app, String resource, String extraValue) throws InterruptedException {
        this.checkForPermission(permission, title, question, app, resource, extraValue, STD_EX_MSG);
    }

    public void checkForPermission(int permission, String title, String question, String app, String resource, String extraValue, String exceptionMsg) throws InterruptedException {
        EventHandler handler;
        if (this.checkForBlocking && (handler = (EventHandler)((Object)AutomatedEventHandler.getAutomationHandler())) != null && handler.isDispatchThread()) {
            SecurityToken.warnPotentialBlocking0();
            this.checkForBlocking = false;
        }
        if (this.permissions == null) {
            return;
        }
        SecurityToken securityToken = this;
        synchronized (securityToken) {
            if (permission >= 0 && permission < this.permissions.length) {
                switch (this.permissions[permission]) {
                    case 1: 
                    case 2: {
                        return;
                    }
                    case 4: {
                        if (SecurityToken.askUserForPermission(new SecurityToken(), title, question, app, resource, extraValue)) {
                            Permissions.setPermissionGroup(this.permissions, permission, (byte)2);
                            return;
                        }
                        Permissions.setPermissionGroup(this.permissions, permission, (byte)-128);
                        break;
                    }
                    case 8: 
                    case 32: {
                        if (this.permissionAsked[permission] != 0) {
                            if (this.permissions[permission] != 8) break;
                            return;
                        }
                        if (SecurityToken.askUserForPermission(new SecurityToken(), title, question, app, resource, extraValue)) {
                            Permissions.setPermissionGroup(this.permissions, permission, (byte)8);
                            Permissions.setPermissionAsked(this.permissionAsked, permission, (byte)1);
                            return;
                        }
                        Permissions.setPermissionGroup(this.permissions, permission, (byte)32);
                        Permissions.setPermissionAsked(this.permissionAsked, permission, (byte)1);
                        break;
                    }
                    case 16: 
                    case 64: {
                        if (SecurityToken.askUserForPermission(new SecurityToken(), title, question, app, resource, extraValue)) {
                            Permissions.setPermissionGroup(this.permissions, permission, (byte)16);
                            return;
                        }
                        Permissions.setPermissionGroup(this.permissions, permission, (byte)64);
                    }
                }
            }
            throw new SecurityException(exceptionMsg);
        }
    }

    public static boolean askUserForPermission(SecurityToken token, String title, String question, String app, String resource, String extraValue) throws InterruptedException {
        ConfirmPermission confirmPermission = new ConfirmPermission(token, title, question, app, resource, extraValue);
        return confirmPermission.waitForAnswer();
    }

    private static native void warnPotentialBlocking0();
}

