/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.security;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.MIDletEventListener;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

class ConfirmPermission
implements CommandListener,
MIDletEventListener {
    private DisplayManager displayManager = DisplayManagerFactory.getDisplayManager();
    private Command yesCmd = new Command(Resource.getString("Yes"), 4, 1);
    private Command noCmd = new Command(Resource.getString("No"), 2, 1);
    private Object preemptToken;
    private boolean answer;

    ConfirmPermission(SecurityToken token, String title, String question, String app, String resource, String extraValue) throws InterruptedException {
        String[] substitutions = new String[]{app, resource, extraValue};
        Alert alert = new Alert(Resource.getString(title, substitutions));
        String iconFilename = File.getConfigRoot() + "security_query.png";
        RandomAccessStream stream = new RandomAccessStream(token);
        try {
            stream.connect(iconFilename, 1);
            byte[] rawPng = new byte[stream.getSizeOf()];
            stream.readBytes(rawPng, 0, rawPng.length);
            stream.disconnect();
            Image icon = Image.createImage(rawPng, 0, rawPng.length);
            alert.setImage(icon);
        }
        catch (IOException noImage) {
            // empty catch block
        }
        alert.setString(Resource.getString(question, substitutions));
        alert.addCommand(this.noCmd);
        alert.addCommand(this.yesCmd);
        alert.setCommandListener(this);
        this.preemptToken = this.displayManager.preemptDisplay(token, this, alert, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForAnswer() {
        ConfirmPermission confirmPermission = this;
        synchronized (confirmPermission) {
            if (this.preemptToken == null) {
                return false;
            }
            try {
                this.wait();
            }
            catch (Throwable t) {
                return false;
            }
            return this.answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnswer(boolean theAnswer) {
        ConfirmPermission confirmPermission = this;
        synchronized (confirmPermission) {
            this.answer = theAnswer;
            this.displayManager.donePreempting(this.preemptToken);
            this.notify();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.yesCmd) {
            this.setAnswer(true);
        } else {
            this.setAnswer(false);
        }
    }

    public void pauseMIDlet(MIDlet midlet) {
    }

    public void startMIDlet(MIDlet midlet) {
    }

    public void destroyMIDlet(MIDlet midlet) {
    }
}

