/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.rms;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStore;

public class RecordStoreFile {
    private static SecurityToken classSecurityToken;
    private static RecordStoreFile rootRSF;
    private static final String dbExtension = ".db";
    private RandomAccessStream recordStream;
    private String myStoragePath;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
        try {
            RecordStore.openRecordStore(null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RecordStoreFile() {
        if (rootRSF != null) {
            throw new SecurityException();
        }
        rootRSF = this;
    }

    public RecordStoreFile newRecordStoreFile(String uidPath) throws IOException {
        if (this != rootRSF) {
            throw new SecurityException();
        }
        return new RecordStoreFile(uidPath);
    }

    private RecordStoreFile(String uidPath) throws IOException {
        this.myStoragePath = uidPath;
        RandomAccessStream newStream = new RandomAccessStream(classSecurityToken);
        newStream.connect(this.myStoragePath, 3);
        this.recordStream = newStream;
    }

    public String getUniqueIdPath(String fileName) {
        return this.getStoragePath(fileName);
    }

    public String getUniqueIdPath(String vendorName, String suiteName, String fileName) {
        return this.getStoragePath(vendorName, suiteName, fileName);
    }

    public String getUniqueIdPath() {
        return this.myStoragePath;
    }

    public boolean exists(String uidPath) {
        File file = new File(classSecurityToken);
        return file.exists(uidPath);
    }

    public boolean deleteFile(String recordStoreName) {
        String uidPath = this.getUniqueIdPath(recordStoreName);
        File file = new File(classSecurityToken);
        try {
            file.delete(uidPath);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void seek(int pos) throws IOException {
        this.recordStream.setPosition(pos);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int numBytes) throws IOException {
        this.recordStream.writeBytes(buf, offset, numBytes);
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int numBytes) throws IOException {
        return this.recordStream.readBytes(buf, offset, numBytes);
    }

    public void close() throws IOException {
        if (this.recordStream != null) {
            this.recordStream.disconnect();
            this.recordStream = null;
        }
    }

    public void truncate(int size) throws IOException {
        if (this.recordStream != null) {
            this.recordStream.truncate(size);
        }
    }

    public String[] listRecordStores() {
        return RecordStoreFile.listRecordStoresForSuite(new File(classSecurityToken), this.getStoragePath(null), false);
    }

    private static String[] listRecordStoresForSuite(File storage, String suiteStorageRoot, boolean rawNames) {
        Vector files = storage.filenamesThatStartWith(suiteStorageRoot);
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < files.size(); ++i) {
            String file = (String)files.elementAt(i);
            if (!file.endsWith(dbExtension)) continue;
            if (rawNames) {
                names.addElement(file);
                continue;
            }
            String asciiName = file.substring(suiteStorageRoot.length(), file.length() - 3);
            names.addElement(File.asciiFilenameToUnicode(asciiName));
        }
        if (names.size() == 0) {
            return null;
        }
        Object[] rv = new String[names.size()];
        names.copyInto(rv);
        return rv;
    }

    public static void removeRecordStoresForSuite(SecurityToken token, String suiteStorageRoot) {
        File storage = new File(token);
        String[] filenames = RecordStoreFile.listRecordStoresForSuite(storage, suiteStorageRoot, true);
        if (filenames == null) {
            return;
        }
        for (int i = 0; i < filenames.length; ++i) {
            try {
                storage.delete(filenames[i]);
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public static boolean suiteHasRmsData(SecurityToken token, String suiteStorageRoot) {
        File storage = new File(token);
        Vector files = storage.filenamesThatStartWith(suiteStorageRoot);
        for (int i = 0; i < files.size(); ++i) {
            String file = (String)files.elementAt(i);
            if (!file.endsWith(dbExtension)) continue;
            return true;
        }
        return false;
    }

    public int spaceAvailable() {
        return new File(classSecurityToken).getBytesAvailableForFiles();
    }

    private String getStoragePath(String name) {
        MIDletSuite mSuite = Scheduler.getScheduler().getMIDletSuite();
        String str = mSuite.getStorageRoot();
        if (name != null) {
            StringBuffer path = new StringBuffer(str);
            path.append(File.unicodeToAsciiFilename(name));
            path.append(dbExtension);
            str = path.toString();
        }
        return str;
    }

    private String getStoragePath(String vendor, String suite, String name) {
        String str = File.getStorageRoot();
        StringBuffer path = new StringBuffer(str);
        if (vendor != null && suite != null) {
            path.append(File.unicodeToAsciiFilename(vendor));
            path.append('_');
            path.append(File.unicodeToAsciiFilename(suite));
            path.append('_');
        }
        if (name != null) {
            path.append(File.unicodeToAsciiFilename(name));
            path.append(dbExtension);
            str = path.toString();
        }
        return str;
    }
}

