/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.publickeystore.InputStorage;
import com.sun.midp.publickeystore.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class PublicKeyStore {
    private Vector keyList = null;

    protected PublicKeyStore() {
    }

    public PublicKeyStore(InputStream in) throws IOException {
        this.initPublicKeyStore(in, new Vector());
    }

    protected void initPublicKeyStore(Vector sharedKeyList) {
        if (this.keyList != null) {
            return;
        }
        this.keyList = sharedKeyList;
    }

    protected void initPublicKeyStore(InputStream in, Vector sharedKeyList) throws IOException {
        InputStorage storage = new InputStorage(in);
        if (this.keyList != null) {
            return;
        }
        this.keyList = sharedKeyList;
        PublicKeyInfo keyInfo;
        while ((keyInfo = PublicKeyInfo.getKeyFromStorage(storage)) != null) {
            this.keyList.addElement(keyInfo);
        }
        return;
    }

    public synchronized PublicKeyInfo getKey(int number) {
        return (PublicKeyInfo)this.keyList.elementAt(number);
    }

    public synchronized Vector findKeys(String owner) {
        Vector<PublicKeyInfo> keys = null;
        for (int i = 0; i < this.keyList.size(); ++i) {
            PublicKeyInfo keyInfo = (PublicKeyInfo)this.keyList.elementAt(i);
            if (keyInfo.getOwner().compareTo(owner) != 0) continue;
            if (keys == null) {
                keys = new Vector<PublicKeyInfo>();
            }
            keys.addElement(keyInfo);
        }
        return keys;
    }

    public synchronized int numberOfKeys() {
        return this.keyList.size();
    }
}

