/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.midp.io.Base64;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.WebPublicKeyStore;
import com.sun.midp.ssl.CryptoException;
import com.sun.midp.ssl.PublicKey;
import com.sun.midp.ssl.Signature;
import com.sun.midp.ssl.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.pki.CertificateException;

public class SecureInstaller
extends Installer {
    private static final String SIG_PROP = "MIDlet-Jar-RSA-SHA1";
    private static final String CERT_PROP = "MIDlet-Certificate-";
    private String lastCa;
    private X509Certificate cpCert;

    protected String getSecurityDomainName(String storageName, String ca) {
        String domain;
        try {
            Vector keys = WebPublicKeyStore.getTrustedKeyStore().findKeys(ca);
            domain = ((PublicKeyInfo)keys.elementAt(0)).getDomain();
        }
        catch (Exception e) {
            domain = "untrusted";
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyJar(RandomAccessStream jarStorage, String jarFilename) throws IOException, InvalidJadException {
        String jarSig = this.state.getAppProperty(SIG_PROP);
        if (jarSig == null) {
            return;
        }
        this.findProviderCert();
        jarStorage.connect(jarFilename, 1);
        try {
            InputStream jarStream = jarStorage.openInputStream();
            try {
                this.verifyStream(jarStream, jarSig);
                this.state.ca = this.lastCa;
            }
            finally {
                jarStream.close();
            }
        }
        finally {
            jarStorage.disconnect();
        }
    }

    private void findProviderCert() throws InvalidJadException {
        WebPublicKeyStore.loadCertificateAuthorities();
        int chain = 1;
        while (true) {
            int result;
            if ((result = this.checkCertChain(chain)) == 1) {
                return;
            }
            if (result == -1) break;
            ++chain;
        }
        if (chain == 1) {
            throw new InvalidJadException(4);
        }
        throw new InvalidJadException(6, this.lastCa);
    }

    private int checkCertChain(int chainNum) throws InvalidJadException {
        String base64Cert;
        Vector<X509Certificate> derCerts = new Vector<X509Certificate>();
        int certNum = 1;
        while ((base64Cert = this.state.getAppProperty(CERT_PROP + chainNum + "-" + certNum)) != null) {
            try {
                byte[] derCert = Base64.decode(base64Cert);
                derCerts.addElement(X509Certificate.generateCertificate(derCert, 0, derCert.length));
            }
            catch (Exception e) {
                throw new InvalidJadException(5);
            }
            ++certNum;
        }
        if (certNum == 1) {
            return -1;
        }
        try {
            this.lastCa = X509Certificate.verifyChain(derCerts, 1, 8, WebPublicKeyStore.getTrustedKeyStore()).getIssuer();
            this.cpCert = (X509Certificate)derCerts.elementAt(0);
            return 1;
        }
        catch (CertificateException ce) {
            switch (ce.getReason()) {
                case 8: {
                    this.lastCa = ce.getCertificate().getIssuer();
                    return 0;
                }
                case 3: 
                case 6: {
                    throw new InvalidJadException(11, ce.getCertificate().getSubject());
                }
                case 12: {
                    throw new InvalidJadException(12, ce.getCertificate().getIssuer());
                }
            }
            throw new InvalidJadException(7, ce.getCertificate().getSubject());
        }
    }

    private void verifyStream(InputStream stream, String base64Signature) throws InvalidJadException, IOException {
        byte[] sig;
        PublicKey cpKey;
        try {
            cpKey = this.cpCert.getPublicKey();
        }
        catch (CertificateException e) {
            throw new InvalidJadException(7);
        }
        try {
            sig = Base64.decode(base64Signature);
        }
        catch (IOException e) {
            throw new InvalidJadException(8);
        }
        try {
            int bytesRead;
            Signature sigVerifier = Signature.getInstance((byte)2, false);
            sigVerifier.init(cpKey, (byte)2);
            byte[] temp = new byte[1024];
            while ((bytesRead = stream.read(temp)) != -1) {
                sigVerifier.update(temp, 0, bytesRead);
            }
            if (!sigVerifier.verify(null, 0, 0, sig, 0, (short)sig.length)) {
                throw new InvalidJadException(9);
            }
        }
        catch (CryptoException e) {
            throw new InvalidJadException(9);
        }
    }
}

