/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.midp.io.Properties;
import com.sun.midp.midletsuite.InvalidJadException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JadProperties
extends Properties {
    protected static final int HT = 9;
    protected static final int LF = 10;
    protected static final int CR = 13;
    protected static final int EOF = 26;
    protected static final int SP = 32;
    protected char[] lineBuffer = null;

    public synchronized void load(InputStream inStream, String enc) throws IOException, InvalidJadException {
        this.partialLoad(inStream, enc, Integer.MAX_VALUE);
    }

    public void partialLoad(InputStream inStream, String enc, int propertiesToLoad) throws IOException, InvalidJadException {
        String line;
        String key = null;
        String value = null;
        InvalidJadException jadException = null;
        InputStreamReader in = enc == null ? new InputStreamReader(inStream, "UTF-8") : new InputStreamReader(inStream, enc);
        this.lineBuffer = new char[512];
        for (int i = 0; i < propertiesToLoad && (line = this.readLine(in)) != null; ++i) {
            if (line.length() == 0) continue;
            int endOfKey = line.indexOf(":");
            if (endOfKey == -1) {
                jadException = new InvalidJadException(28, line);
                continue;
            }
            key = line.substring(0, endOfKey);
            if (key == null || key.length() == 0) {
                jadException = new InvalidJadException(28, line);
                continue;
            }
            if (!this.checkKeyChars(key)) {
                jadException = new InvalidJadException(28, line);
                continue;
            }
            int startOfValue = endOfKey + 1;
            value = line.substring(startOfValue, line.length());
            if ((value = value.trim()) == null) {
                jadException = new InvalidJadException(29, key);
                continue;
            }
            if (!this.checkValueChars(value)) {
                jadException = new InvalidJadException(29, key);
                continue;
            }
            this.putProperty(key, value);
        }
        this.lineBuffer = null;
        if (jadException != null) {
            throw jadException;
        }
    }

    public synchronized void load(InputStream inStream) throws IOException, InvalidJadException {
        this.load(inStream, null);
    }

    protected void putProperty(String key, String value) {
        this.setProperty(key, value);
    }

    protected String readLine(Reader in) throws IOException {
        int offset = 0;
        int c = 0;
        int room = this.lineBuffer.length;
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13 || c == 26) continue;
            if (--room < 0) {
                char[] temp = new char[offset + 128];
                room = temp.length - offset - 1;
                System.arraycopy(this.lineBuffer, 0, temp, 0, offset);
                this.lineBuffer = temp;
            }
            this.lineBuffer[offset++] = (char)c;
        }
        if (c == -1 && offset <= 0) {
            return null;
        }
        return new String(this.lineBuffer, 0, offset);
    }

    protected boolean checkKeyChars(String key) {
        char[] temp = key.toCharArray();
        int len = temp.length;
        for (int i = 0; i < len; ++i) {
            char current = temp[i];
            if (current > '\u001f' && current != '\u007f' && current != '(' && current != ')' && current != '<' && current != '>' && current != '@' && current != ',' && current != ';' && current != '\'' && current != '\"' && current != '/' && current != '[' && current != ']' && current != '?' && current != '=' && current != '{' && current != '}' && current != ' ' && current != '\t') continue;
            return false;
        }
        return true;
    }

    protected boolean checkValueChars(String value) {
        char[] temp = value.toCharArray();
        int len = temp.length;
        for (int i = 0; i < len; ++i) {
            char current = temp[i];
            if (current > '\u001f' && current != '\u007f' || current == '\t') continue;
            return false;
        }
        return true;
    }
}

