/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.main;

import com.sun.kvem.DeviceConfiguration;
import com.sun.midp.dev.DevMIDletSuiteImpl;
import com.sun.midp.io.j2me.cbs.Protocol;
import com.sun.midp.io.j2me.push.PushRegistryImpl;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.lcdui.DefaultInputMethodHandler;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.main.CommandProcessor;
import com.sun.midp.main.CommandState;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletState;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.publickeystore.WebPublicKeyStore;
import com.sun.midp.rms.RecordStoreFile;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.Permissions;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.util.Vector;

public class Main {
    private static final String DEV_STORAGE_NAME = "run_by_class_storage_";
    private static SecurityToken internalSecurityToken;
    private static final String PUSH_INTERRUPT_QUESTION = "Information is arriving for %1. Is it OK to launch %1?%1 needs to start itself to check to see if it has received information. Is that OK?";
    private static String[] optionalTokenClients;

    public static void main(String[] args) {
        CommandState state = new CommandState();
        Main.initSystemLabels();
        try {
            Main.initializeInternalSecurity();
            String jamMode = DeviceConfiguration.getProperty("ProfileConfiguration.JAM_MODE");
            if (jamMode == null || jamMode.length() == 0) {
                PushRegistryImpl.enablePushLaunch(internalSecurityToken, false);
            } else {
                new Thread(new PushRegistryImpl()).start();
            }
            Main.restoreCommandState(state);
            switch (state.nextCommand) {
                case 8: {
                    Main.runLocalClass(state);
                    state.nextCommand = 1;
                    break;
                }
                case 2: {
                    Main.manage(state);
                    break;
                }
                case 7: 
                case 9: {
                    Main.list(state);
                    state.nextCommand = 1;
                    break;
                }
                case 6: {
                    if (DEV_STORAGE_NAME.equals(state.suiteStorageName)) {
                        Main.removeDevStorage(state);
                        state.nextCommand = 1;
                        break;
                    }
                }
                default: {
                    CommandProcessor.perform(state);
                    if (state.status == -2) {
                        System.out.println("The MIDlet suite was not found.");
                        break;
                    }
                    if (state.initialCommand == 3 && state.status == 0) {
                        System.out.println("Storage name: " + state.suiteStorageName);
                    }
                    break;
                }
            }
        }
        catch (InvalidJadException ije) {
            System.out.println("** Error installing suite (" + ije.getReason() + "): " + Main.messageForInvalidJadException(ije));
        }
        catch (IOException ioe) {
            System.out.println("** Error installing suite: " + ioe.getMessage());
        }
        catch (ClassNotFoundException ex) {
            if (state.initialCommand == 2) {
                state.runExceptionMessage = Resource.getString("The application cannot be launched. One of the application classes appears to be missing. This could be due to a mis-named class. Contact the application provider to resolve the issue.");
            } else {
                System.out.println("MIDlet class(s) not found: " + ex.getMessage());
            }
        }
        catch (InstantiationException ex) {
            if (state.initialCommand == 2) {
                state.runExceptionMessage = Resource.getString("The application cannot be launched. The application may have done an illegal operation. Contact the application provider to resolve the issue.") + "\n\n" + ex.getMessage();
            } else {
                System.out.println("MIDlet instance(s) could not be created: " + ex.getMessage());
            }
        }
        catch (IllegalAccessException ex) {
            if (state.initialCommand == 2) {
                state.runExceptionMessage = Resource.getString("The application cannot be launched. The application may have done an illegal operation. Contact the application provider to resolve the issue.") + "\n\n" + ex.getMessage();
            } else {
                System.out.println("MIDlet class(s) could not be accessed: " + ex.getMessage());
            }
        }
        catch (OutOfMemoryError ex) {
            if (state.initialCommand == 2) {
                state.runExceptionMessage = Resource.getString("The application has unexpectedly quit because it ran out of memory.");
            } else {
                System.out.println("The MIDlet has run out of memory");
            }
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Throwable t) {
            if (state.initialCommand == 2) {
                state.runExceptionMessage = Resource.getString("The application has unexpectedly  quit. Contact the application provider to resolve the issue.") + "\n\n" + t.getMessage();
            }
            System.out.println("Exception caught in main:");
            t.printStackTrace();
            state.nextCommand = 1;
        }
        Main.saveCommandState(state);
        Main.exitInternal(2001);
    }

    private static void initializeInternalSecurity() {
        internalSecurityToken = new SecurityToken(null, Permissions.forDomain(null, "internal"));
        Installer.initSecurityToken(internalSecurityToken);
        RecordStoreFile.initSecurityToken(internalSecurityToken);
        WebPublicKeyStore.initSecurityToken(internalSecurityToken);
        com.sun.midp.io.j2me.http.Protocol.initSecurityToken(internalSecurityToken);
        com.sun.midp.io.j2me.https.Protocol.initSecurityToken(internalSecurityToken);
        com.sun.midp.io.j2me.ssl.Protocol.initSecurityToken(internalSecurityToken);
        com.sun.midp.io.j2me.datagram.Protocol.initSecurityToken(internalSecurityToken);
        DefaultInputMethodHandler.initSecurityToken(internalSecurityToken);
        DisplayManagerFactory.initSecurityToken(internalSecurityToken);
        MIDletState.initSecurityToken(internalSecurityToken);
        com.sun.midp.io.j2me.sms.Protocol.initSecurityToken(internalSecurityToken);
        Protocol.initSecurityToken(internalSecurityToken);
        com.sun.kvem.io.j2me.cbs.Protocol.initSecurityToken(internalSecurityToken);
        Main.initOptionalClassesToken();
    }

    private static void initOptionalClassesToken() {
        if (optionalTokenClients == null) {
            return;
        }
        for (int i = 0; i < optionalTokenClients.length; ++i) {
            try {
                ImplicitlyTrustedClass trustedClass = (ImplicitlyTrustedClass)Class.forName(optionalTokenClients[i]).newInstance();
                trustedClass.initSecurityToken(internalSecurityToken);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void manage(CommandState state) {
        String[] propValues;
        String[] propKeys;
        Installer installer = Installer.getInstaller();
        if (state.runExceptionMessage != null) {
            propKeys = new String[2];
            propValues = new String[2];
            propKeys[1] = "run-message";
            propValues[1] = state.runExceptionMessage;
        } else {
            propKeys = new String[1];
            propValues = new String[1];
        }
        propKeys[0] = "logo-displayed";
        propValues[0] = state.logoDisplayed ? "T" : "F";
        state.logoDisplayed = true;
        state.runExceptionMessage = null;
        try {
            String nextMidletSuiteToRun;
            String nameOfManager = Configuration.getProperty("com.sun.midp.graphicalmanager");
            if (nameOfManager == null) {
                nameOfManager = "com.sun.midp.dev.Manager";
            }
            MIDletSuite midletSuite = DevMIDletSuiteImpl.create(internalSecurityToken, null, nameOfManager, "manager_storage_", propKeys, propValues, "internal", true, PUSH_INTERRUPT_QUESTION, PUSH_INTERRUPT_QUESTION);
            if (!Scheduler.getScheduler().schedule(midletSuite)) {
                state.nextCommand = 1;
            }
            if ((nextMidletSuiteToRun = installer.getNextMIDletSuiteToRun()) != null) {
                state.nextCommand = 5;
                state.suiteStorageName = nextMidletSuiteToRun;
                state.midletName = installer.getNextMIDletToRun();
            }
            state.status = 0;
            return;
        }
        catch (Throwable e) {
            state.status = -1;
            state.nextCommand = 1;
            e.printStackTrace();
            return;
        }
    }

    private static void list(CommandState state) {
        Installer installer = Installer.getInstaller();
        String[] appList = installer.list();
        if (appList == null || appList.length == 0) {
            System.out.println("** No MIDlet Suites installed on phone");
        } else {
            for (int i = 0; i < appList.length; ++i) {
                MIDletSuite midletSuite = installer.getMIDletSuite(appList[i]);
                if (midletSuite == null) {
                    System.out.println(i + 1 + ": suite corrupted");
                    continue;
                }
                if (state.nextCommand == 9) {
                    System.out.println(appList[i]);
                    continue;
                }
                System.out.println("[" + (i + 1) + "]");
                System.out.println("  Name: " + midletSuite.getProperty("MIDlet-Name"));
                System.out.println("  Vendor: " + midletSuite.getProperty("MIDlet-Vendor"));
                System.out.println("  Version: " + midletSuite.getProperty("MIDlet-Version"));
                String temp = midletSuite.getCA();
                if (temp != null) {
                    System.out.println("  Authorized by: " + temp);
                }
                if ((temp = midletSuite.getProperty("MIDlet-Description")) != null) {
                    System.out.println("  Description: " + temp);
                }
                System.out.println("  Storage name: " + appList[i]);
                System.out.println("  Size: " + (midletSuite.getStorageUsed() + 1023) / 1024 + "K");
                System.out.println("  Installed From: " + midletSuite.getDownloadUrl());
                System.out.println("  MIDlets:");
                int j = 1;
                while ((temp = midletSuite.getProperty("MIDlet-" + j)) != null) {
                    MIDletInfo midletInfo = new MIDletInfo(temp);
                    System.out.println("    " + midletInfo.name);
                    ++j;
                }
            }
        }
        state.status = 0;
    }

    private static void runLocalClass(CommandState state) {
        try {
            MIDletSuite midletSuite = DevMIDletSuiteImpl.create(internalSecurityToken, state.descriptorName, state.midletClassName, DEV_STORAGE_NAME, state.securityDomain);
            while (Scheduler.getScheduler().schedule(midletSuite) && state.midletClassName == null) {
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void removeDevStorage(CommandState state) {
        File file = new File(internalSecurityToken);
        String storageRoot = File.getStorageRoot() + DEV_STORAGE_NAME;
        Vector files = file.filenamesThatStartWith(storageRoot);
        int numberOfFiles = files.size();
        for (int i = 0; i < numberOfFiles; ++i) {
            try {
                file.delete((String)files.elementAt(i));
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        PushRegistryImpl.unregisterConnections(internalSecurityToken, DEV_STORAGE_NAME);
    }

    private static String messageForInvalidJadException(InvalidJadException ije) {
        switch (ije.getReason()) {
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 41: 
            case 42: {
                return "A required attribute is missing";
            }
            case 25: 
            case 26: 
            case 27: {
                return "A required suite ID attribute in the JAR manifest do not match the one in the JAD";
            }
            case 50: {
                return "The value for " + ije.getExtraData() + " in the " + "trusted JAR manifest did not match the one in the JAD";
            }
            case 5: {
                return "The content provider certificate cannot be decoded.";
            }
            case 6: {
                return "The content provider certificate issuer " + ije.getExtraData() + " is unknown.";
            }
            case 7: {
                return "The signature of the content provider certificate is invalid.";
            }
            case 8: {
                return "The JAR signature cannot be decoded.";
            }
            case 9: {
                return "The signature of the JAR is invalid.";
            }
            case 10: {
                return "The content provider certificate is not a supported version.";
            }
            case 11: {
                return "The content provider certificate is expired.";
            }
            case 12: {
                return "The public key of " + ije.getExtraData() + " has expired.";
            }
            case 31: {
                return "The Jar downloaded was not the size in the JAD";
            }
            case 17: {
                return "The application is an older version of one that is already installed";
            }
            case 32: {
                return "The application is an newer version of one that is already installed";
            }
            case 43: {
                return "The JAD URL is invalid";
            }
            case 1: {
                return "JAD server not found";
            }
            case 2: {
                return "JAD not found";
            }
            case 44: {
                return "The JAR URL in the JAD is invalid: " + ije.getExtraData();
            }
            case 19: {
                return "JAR server not found: " + ije.getExtraData();
            }
            case 20: {
                return "JAR not found: " + ije.getExtraData();
            }
            case 36: {
                return "Corrupt JAR, error while reading: " + ije.getExtraData();
            }
            case 38: {
                if (ije.getExtraData() != null) {
                    return "JAR did not have the correct media type, it had " + ije.getExtraData();
                }
                return "The server did not have a resource with an acceptable media type for the JAR URL. (code 406)";
            }
            case 37: {
                if (ije.getExtraData() != null) {
                    String temp = ije.getExtraData();
                    if (temp.length() == 0) {
                        return "JAD did not have a media type";
                    }
                    return "JAD did not have the correct media type, it had " + temp;
                }
                return "The server did not have a resource with an acceptable media type for the JAD URL. (code 406)";
            }
            case 28: {
                return "The attribute key [" + ije.getExtraData() + "] is not in the proper format";
            }
            case 29: {
                return "The value for attribute " + ije.getExtraData() + " is not in the proper format";
            }
            case 30: {
                return "There is insufficient storage to install this suite";
            }
            case 33: {
                return "Authentication required or failed";
            }
            case 34: {
                return "The JAD to be installed is for an existing suite, but not from the same domain as the existing one: " + ije.getExtraData();
            }
            case 35: {
                return "Cannot authenticate with the server, unsupported scheme";
            }
            case 40: {
                return "Either the configuration or profile is not supported.";
            }
            case 39: {
                return "The JAD matches a version of a suite already installed.";
            }
            case 49: {
                return "The suite is not authorized for " + ije.getExtraData();
            }
            case 45: {
                return "The suite is in confict with another application listening for network data on " + ije.getExtraData();
            }
            case 46: {
                return "Push attribute in incorrectly formated: " + ije.getExtraData();
            }
            case 47: {
                return "Connection in push attribute is not supported: " + ije.getExtraData();
            }
            case 48: {
                return "The class in push attribute not in a MIDlet-<n> attribute: " + ije.getExtraData();
            }
            case 52: {
                return "Cannot update a trusted suite with an untrusted version";
            }
        }
        return ije.getMessage();
    }

    private static void initSystemLabels() {
        String[] sa = new String[]{Resource.getString("1234567890"), Resource.getString("Menu"), Resource.getString("Back"), Resource.getString("Cancel")};
        Main.initSystemLabels(sa);
    }

    private static native void initSystemLabels(String[] var0);

    private static native void saveCommandState(CommandState var0);

    private static native void restoreCommandState(CommandState var0);

    private static native void exitInternal(int var0);

    private Main() {
    }

    static {
        optionalTokenClients = new String[]{"com.sun.midp.io.j2me.tcpobex.Protocol", "com.sun.midp.io.j2me.irdaobex.Protocol", "com.sun.midp.io.j2me.btgoep.Protocol", "com.sun.kvem.jsr082.impl.bluetooth.SecurityTokenHandler", "com.sun.kvem.io.j2me.tcpobex.Protocol", "com.sun.mmedia.VideoPlayer2", "com.sun.midp.io.j2me.push.PushRegistryImpl", "com.sun.midp.io.j2me.mms.Protocol"};
    }
}

