/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

import com.sun.midp.lcdui.InputMethodClient;
import com.sun.midp.main.Configuration;

public abstract class InputMethodHandler {
    public static final int KEYCODE_NONE = -1;
    public static final int KEYCODE_CLEAR = -2;
    public static final int KEYCODE_CLEARALL = -3;
    public static final int KEYCODE_SIGNCHANGE = -4;
    public static final int KEYCODE_SHIFT = -5;
    private static InputMethodHandler thisIM;

    public static InputMethodHandler getInputMethodHandler() {
        if (thisIM != null) {
            return thisIM;
        }
        thisIM = InputMethodHandler.getInputMethodHandlerImpl();
        return thisIM;
    }

    private static InputMethodHandler getInputMethodHandlerImpl() {
        try {
            String n = Configuration.getProperty("com.sun.midp.lcdui.inputMethodHandler");
            if (n != null) {
                Class<?> c = Class.forName(n);
                return (InputMethodHandler)c.newInstance();
            }
            String loc = Configuration.getProperty("microedition.locale");
            if (loc != null) {
                int hyphen = loc.indexOf(45);
                if (hyphen != -1) {
                    StringBuffer tmploc = new StringBuffer(loc);
                    tmploc.setCharAt(hyphen, '_');
                    loc = tmploc.toString();
                }
                String cls = "com.sun.midp.lcdui.i18n.DefaultInputMethodHandler_";
                while (true) {
                    try {
                        Class<?> c = Class.forName(cls + loc);
                        return (InputMethodHandler)c.newInstance();
                    }
                    catch (Throwable t) {
                        int pos = loc.lastIndexOf(95);
                        if (pos == -1) break;
                        loc = loc.substring(0, pos);
                        continue;
                    }
                    break;
                }
            }
            Class<?> c = Class.forName("com.sun.midp.lcdui.DefaultInputMethodHandler");
            return (InputMethodHandler)c.newInstance();
        }
        catch (Throwable t) {
            System.out.println(t);
            throw new Error("Textbox input method was not initialized.");
        }
    }

    public abstract void setInputMethodClient(InputMethodClient var1);

    public abstract boolean clearInputMethodClient(InputMethodClient var1);

    public abstract int keyPressed(int var1);

    public abstract int keyReleased(int var1);

    public abstract int keyRepeated(int var1);

    public abstract int keyTyped(char var1);

    public abstract void flush();

    public abstract String[] supportedInputModes();

    public abstract boolean setConstraints(int var1);

    public boolean isSymbol(char c) {
        return false;
    }

    public abstract void endComposition(boolean var1);
}

