/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

import com.sun.midp.lcdui.InputMethodClient;
import com.sun.midp.lcdui.InputMethodHandler;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class EmulInputMethodHandler
extends InputMethodHandler {
    protected InputMethodClient imc = null;
    protected static final int IM_NONE = 0;
    protected static final int IM_ROMAN_CAPS = 1;
    protected static final int IM_ROMAN_SMALL = 2;
    protected static final int IM_NUMERIC = 3;
    protected static final int IM_SYMBOL = 4;
    protected static int NUM_INPUT_MODES = 5;
    protected int currentConstraints;
    protected int currentModifiers;
    protected int defaultMode;
    protected int allowedModesNum;
    protected int[] allowedModes = new int[NUM_INPUT_MODES];
    protected int inputMode;
    protected int oldInputMode;
    protected boolean quickSymbolAccess = false;
    protected boolean canUseSymbolTable = true;
    protected int lastInputMode;
    protected String[] supportedCharSubset = new String[]{"UCB_BASIC_LATIN", "IS_LATIN", "IS_LATIN_DIGITS", "MIDP_UPPERCASE_LATIN", "MIDP_LOWERCASE_LATIN", "LATIN", "LATIN_DIGITS"};
    protected int[] supportedInputModes = new int[]{1, 2, 3, 4};
    protected Object[][] inputModeConvTable = new Object[][]{{"UCB_BASIC_LATIN", new Integer(1)}, {"UCB_BASIC_LATIN", new Integer(2)}, {"UCB_BASIC_LATIN", new Integer(3)}, {"UCB_BASIC_LATIN", new Integer(4)}, {"IS_LATIN", new Integer(1)}, {"IS_LATIN", new Integer(2)}, {"IS_LATIN", new Integer(3)}, {"IS_LATIN", new Integer(4)}, {"IS_LATIN_DIGITS", new Integer(3)}, {"MIDP_UPPERCASE_LATIN", new Integer(1)}, {"MIDP_LOWERCASE_LATIN", new Integer(2)}, {"LATIN", new Integer(1)}, {"LATIN", new Integer(2)}, {"LATIN_DIGITS", new Integer(3)}, {"LATIN", new Integer(4)}};
    protected boolean capWord;
    protected boolean capSentence;
    protected static final int KEY_UNKNOWN = -1;
    protected static final int KEY_NUM0 = 0;
    protected static final int KEY_NUM1 = 1;
    protected static final int KEY_NUM2 = 2;
    protected static final int KEY_NUM3 = 3;
    protected static final int KEY_NUM4 = 4;
    protected static final int KEY_NUM5 = 5;
    protected static final int KEY_NUM6 = 6;
    protected static final int KEY_NUM7 = 7;
    protected static final int KEY_NUM8 = 8;
    protected static final int KEY_NUM9 = 9;
    protected static final int KEY_STAR = 10;
    protected static final int KEY_POUND = 11;
    protected static final int KEY_CLEAR = 100;
    protected char[][] upperRomanKeyMap = new char[][]{{'0'}, {'1'}, {'A', 'B', 'C', '2'}, {'D', 'E', 'F', '3'}, {'G', 'H', 'I', '4'}, {'J', 'K', 'L', '5'}, {'M', 'N', 'O', '6'}, {'P', 'Q', 'R', 'S', '7'}, {'T', 'U', 'V', '8'}, {'W', 'X', 'Y', 'Z', '9'}, {'\u0000'}, {' '}};
    protected char[][] lowerRomanKeyMap = new char[][]{{'0'}, {'1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}, {'\u0000'}, {' '}};
    protected char[][] numericKeyMap = new char[][]{{'0'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {'*'}, {' '}};
    protected char[][] decimalKeyMap = new char[][]{{'0'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {'.'}, {' '}};
    protected char[][] phoneNumericKeyMap = new char[][]{{'0'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {'*'}, {'#', '+'}};
    protected char[] symbolTableChars = new char[]{'_', '$', '(', ')', '\\', '~', '\"', '\'', '/', '&', '*', '@', '.', '?', '!', '#', '-', ',', ':', ';', '%', '=', '+', '<', '>'};
    protected SymbolTable st = new SymbolTable();
    protected char[][] keyMap = this.upperRomanKeyMap;
    protected static final int TM_NONE = 0;
    protected static final int TM_INPUT_MODE = 1;
    protected static final int TM_IN_COMPOSING = 2;
    protected static final int TM_CLEAR_BUFFER = 3;
    protected int timerType;
    protected Timer timerService = new Timer();
    protected TimerTask timerClient = null;
    protected int lastKey;
    protected int lastKeyIndex;
    protected int charIndex;
    protected boolean ignoreNextKeyRelease = false;

    public synchronized void setInputMethodClient(InputMethodClient imc) {
        this.cancelTimer();
        this.ignoreNextKeyRelease = true;
        this.imc = imc;
        this.lastKey = -1;
        this.lastKeyIndex = -1;
        this.charIndex = 0;
        if (imc != null) {
            this.setConstraints(imc.getConstraints());
        }
    }

    public synchronized boolean clearInputMethodClient(InputMethodClient imc) {
        if (this.imc == imc) {
            this.endComposition(false);
            this.setKeyMap(0, this.currentConstraints);
            this.imc = null;
            return true;
        }
        return false;
    }

    protected int getKeyMapIndex(int keyCode) {
        switch (keyCode) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
            case -8: {
                return 100;
            }
        }
        return -1;
    }

    public synchronized int keyPressed(int keyCode) {
        this.cancelTimer();
        this.ignoreNextKeyRelease = false;
        this.quickSymbolAccess = false;
        int idx = this.getKeyMapIndex(keyCode);
        if (idx != this.lastKeyIndex) {
            this.endComposition(false);
        }
        this.lastKeyIndex = idx;
        if (idx == -1) {
            this.lastKey = -1;
            return -1;
        }
        if (idx == 100) {
            this.lastKey = -2;
            this.setTimer(3, 1500L);
            return -1;
        }
        if (this.capWord || this.capSentence) {
            if (this.imc.isNewWord() || this.imc.isNewSentence()) {
                this.oldInputMode = 1;
                this.inputMode = 1;
            } else {
                this.oldInputMode = 2;
                this.inputMode = 2;
            }
            this.setKeyMap(this.inputMode, this.currentConstraints);
        }
        this.lastKey = this.keyMap[idx][this.charIndex];
        this.charIndex = (this.charIndex + 1) % this.keyMap[idx].length;
        if (idx == 10 && this.canUseSymbolTable) {
            this.setTimer(1, 1000L);
            this.lastKey = -5;
            return -1;
        }
        if (idx == 11 && (this.currentConstraints == 2 || this.currentConstraints == 5)) {
            this.lastKey = -4;
            this.endComposition(false);
            return -1;
        }
        this.endComposition(true);
        return this.lastKey;
    }

    public synchronized int keyReleased(int keyCode) {
        if (this.ignoreNextKeyRelease) {
            this.ignoreNextKeyRelease = false;
            this.lastKey = -1;
            this.lastKeyIndex = -1;
            return this.lastKey;
        }
        int idx = this.getKeyMapIndex(keyCode);
        switch (idx) {
            case -1: {
                return -1;
            }
            case 10: {
                if (this.timerType != 1) break;
                this.cancelTimer();
                if (this.canUseSymbolTable) {
                    this.lastKey = -1;
                    this.lastKeyIndex = -1;
                    this.switchToNextInputMode(false);
                    break;
                }
                this.endComposition(false);
                break;
            }
            case 100: {
                if (this.timerType != 3) break;
                this.cancelTimer();
                this.endComposition(false);
            }
        }
        return this.lastKey;
    }

    public synchronized int keyRepeated(int keyCode) {
        return this.keyPressed(keyCode);
    }

    public synchronized int keyTyped(char c) {
        this.cancelTimer();
        this.ignoreNextKeyRelease = false;
        this.quickSymbolAccess = false;
        this.endComposition(false);
        this.lastKey = c == '\b' || c == '\u007f' ? -2 : (int)c;
        this.endComposition(false);
        return -1;
    }

    public void flush() {
        this.cancelTimer();
        this.ignoreNextKeyRelease = true;
        this.lastKey = -1;
        this.lastKeyIndex = -1;
        this.charIndex = 0;
    }

    public synchronized void endComposition(boolean discard) {
        if (this.lastKey == -1) {
            return;
        }
        this.cancelTimer();
        if (!discard && this.imc != null) {
            this.imc.keyEntered(this.lastKey);
            if (this.imc.isNewInputEntry()) {
                this.capWord = (this.currentModifiers & 0x100000) == 0x100000;
                this.capSentence = (this.currentModifiers & 0x200000) == 0x200000;
            }
        }
        this.lastKey = -1;
        this.lastKeyIndex = -1;
        this.charIndex = 0;
    }

    public String[] supportedInputModes() {
        return this.supportedCharSubset;
    }

    protected void setTimer(int type, long delay) {
        if (type != this.timerType) {
            if (type == 2) {
                // empty if block
            }
            this.timerType = type;
        }
        this.cancelTimer();
        try {
            this.timerClient = new TimerClient();
            this.timerService.schedule(this.timerClient, delay);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.cancelTimer();
        }
    }

    protected synchronized void cancelTimer() {
        if (this.timerType != 0 && this.timerClient != null) {
            this.timerClient.cancel();
            this.timerClient = null;
            this.timerType = 0;
        }
    }

    protected synchronized void timerWentOff() {
        switch (this.timerType) {
            case 1: {
                this.quickSymbolAccess = true;
                this.ignoreNextKeyRelease = true;
                this.endComposition(true);
                this.oldInputMode = this.inputMode;
                this.st.invokeSYM();
                break;
            }
            case 3: {
                this.lastKey = -3;
            }
            case 2: {
                this.endComposition(false);
                this.ignoreNextKeyRelease = true;
            }
        }
    }

    protected void switchToNextInputMode(boolean fromSymTable) {
        if (fromSymTable && this.quickSymbolAccess) {
            this.inputMode = this.oldInputMode;
        } else if (fromSymTable) {
            this.oldInputMode = this.defaultMode;
            this.inputMode = this.defaultMode;
        } else {
            int n;
            for (n = 0; n < this.allowedModesNum && this.allowedModes[n] != this.inputMode; ++n) {
            }
            n = (n + 1) % this.allowedModesNum;
            this.oldInputMode = this.inputMode;
            this.inputMode = this.allowedModes[n];
            this.capSentence = false;
            this.capWord = false;
        }
        this.setKeyMap(this.inputMode, this.currentConstraints);
    }

    protected boolean setKeyMap(int mode, int constraints) {
        switch (mode) {
            case 1: {
                this.keyMap = this.upperRomanKeyMap;
                break;
            }
            case 2: {
                this.keyMap = this.lowerRomanKeyMap;
                break;
            }
            case 3: {
                this.keyMap = constraints == 3 ? this.phoneNumericKeyMap : (constraints == 5 ? this.decimalKeyMap : this.numericKeyMap);
                break;
            }
            case 4: {
                this.st.invokeSYM();
                break;
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        this.imc.showInputMode(mode);
        return true;
    }

    public synchronized boolean setConstraints(int constraints) {
        boolean ret = false;
        this.currentConstraints = constraints & 0xFFFF;
        this.currentModifiers = constraints & 0xFFFF0000;
        this.canUseSymbolTable = this.currentConstraints == 4 || this.currentConstraints == 1 || this.currentConstraints == 0;
        ret = this.buildInputModes(this.currentConstraints, this.currentModifiers, this.imc.getInputMode(), this.imc.getAllowedModes());
        this.setKeyMap(this.inputMode, this.currentConstraints);
        return ret;
    }

    protected boolean buildInputModes(int constraints, int modifiers, String dMode, String[] aMode) {
        boolean ret = true;
        this.capSentence = false;
        this.capWord = false;
        if (constraints == 2 || constraints == 5 || constraints == 3) {
            this.defaultMode = 3;
            this.allowedModesNum = 1;
            this.allowedModes[0] = 3;
        } else if (constraints == 1 || constraints == 4) {
            this.defaultMode = 2;
            this.allowedModesNum = 4;
            this.allowedModes[0] = 2;
            this.allowedModes[1] = 1;
            this.allowedModes[2] = 3;
            this.allowedModes[3] = 4;
        } else {
            if (constraints != 0) {
                dMode = null;
                aMode = null;
            }
            Vector<Integer> uniqueModes = new Vector<Integer>(NUM_INPUT_MODES);
            if (dMode == null && aMode == null) {
                this.allowedModesNum = this.supportedInputModes.length;
                System.arraycopy(this.supportedInputModes, 0, this.allowedModes, 0, this.allowedModesNum);
                this.defaultMode = this.allowedModes[0];
            } else {
                int i;
                if (dMode == null && aMode != null) {
                    dMode = aMode[0];
                }
                if (dMode != null && aMode == null) {
                    aMode = new String[this.supportedCharSubset.length];
                    System.arraycopy(this.supportedCharSubset, 0, aMode, 0, this.supportedCharSubset.length);
                }
                for (i = 0; i < this.inputModeConvTable.length; ++i) {
                    if (!((String)this.inputModeConvTable[i][0]).equals(dMode)) continue;
                    this.defaultMode = (Integer)this.inputModeConvTable[i][1];
                    break;
                }
                for (int j = 0; j < this.inputModeConvTable.length; ++j) {
                    for (int i2 = 0; i2 < aMode.length; ++i2) {
                        Integer imode = (Integer)this.inputModeConvTable[i2][1];
                        if (!((String)this.inputModeConvTable[j][0]).equals(aMode[i2]) || uniqueModes.indexOf(imode) != -1) continue;
                        uniqueModes.addElement(imode);
                    }
                }
                this.allowedModesNum = uniqueModes.size();
                for (i = 0; i < this.allowedModesNum; ++i) {
                    this.allowedModes[i] = (Integer)uniqueModes.elementAt(i);
                }
                if (this.defaultMode == 0) {
                    this.defaultMode = this.allowedModes[0];
                }
            }
            this.capWord = (modifiers & 0x100000) == 0x100000;
            boolean bl = this.capSentence = (modifiers & 0x200000) == 0x200000;
            if (this.capWord || this.capSentence) {
                this.defaultMode = 1;
            }
        }
        this.oldInputMode = this.defaultMode;
        this.inputMode = this.defaultMode;
        return ret;
    }

    public boolean isSymbol(char c) {
        for (int i = 0; i < this.symbolTableChars.length; ++i) {
            if (this.symbolTableChars[i] != c) continue;
            return true;
        }
        return false;
    }

    protected class SymbolTable
    extends Canvas {
        private final int MARGIN;
        private final int DMARGIN;
        private int cc;
        private int hmargin;
        private int wmargin;
        private int margin;
        private int wx;
        private int wy;
        private int ww;
        private int wh;
        private int cols;
        private int rows;
        private int pos;
        private int newpos;
        private Font font;
        private boolean firstTime = true;
        private Display currentDisplay;
        private Displayable previousScreen;
        protected int defaultSymbolCursorPos = 12;
        InputMethodClient tmpimc;

        protected SymbolTable() {
            this.MARGIN = 1;
            this.DMARGIN = 2;
        }

        void init() {
            if (EmulInputMethodHandler.this.symbolTableChars.length <= 25) {
                this.cols = 5;
                this.rows = 5;
            } else {
                this.rows = 6;
                this.cols = 6;
            }
            int w = this.getWidth() / this.cols;
            int h = this.getHeight() / this.rows;
            this.cc = w > h ? h : w;
            int cw = 0;
            int ch = 0;
            int[] fs = new int[]{16, 0, 8};
            for (int i = 0; i < fs.length; ++i) {
                this.font = Font.getFont(0, 1, fs[i]);
                cw = this.font.charWidth('M');
                ch = this.font.getHeight();
                if (cw <= this.cc && ch <= this.cc) break;
            }
            this.ww = this.cols * this.cc;
            this.wh = this.rows * this.cc;
            this.wx = (this.getWidth() - this.ww) / 2;
            this.wy = this.getHeight() - this.wh;
            this.hmargin = (this.cc - ch) / 2;
            this.wmargin = this.cc / 2;
            this.margin = this.hmargin + 2;
        }

        public void invokeSYM() {
            if (this.font == null) {
                this.init();
            }
            this.tmpimc = EmulInputMethodHandler.this.imc;
            this.currentDisplay = EmulInputMethodHandler.this.imc.getDisplay();
            this.previousScreen = this.currentDisplay.getCurrent();
            this.currentDisplay.setCurrent(this);
        }

        protected void showNotify() {
            this.pos = this.newpos = this.defaultSymbolCursorPos;
        }

        protected void hideNotify() {
            this.firstTime = true;
        }

        protected void paint(Graphics g) {
            if (this.firstTime) {
                this.paintPanel(g);
                this.firstTime = false;
            }
            this.showCursor(g, this.pos, false);
            this.pos = this.newpos;
            this.showCursor(g, this.pos, true);
        }

        void paintPanel(Graphics g) {
            g.setFont(this.font);
            g.setGrayScale(255);
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setGrayScale(0);
            g.drawRect(this.wx + 1, this.wy + 1, this.ww - 2, this.wh - 2);
            for (int r = 0; r < this.rows; ++r) {
                int i;
                for (int c = 0; c < this.cols && (i = r * this.cols + c) != EmulInputMethodHandler.this.symbolTableChars.length; ++c) {
                    this.drawChar(g, EmulInputMethodHandler.this.symbolTableChars[i], r, c, false);
                }
            }
        }

        void drawChar(Graphics g, char c, int row, int col, boolean reverse) {
            int h = this.font.charWidth(c);
            int y = this.wy + row * this.cc + this.hmargin;
            int x = this.wx + col * this.cc + this.wmargin;
            g.setFont(this.font);
            if (reverse) {
                g.setGrayScale(255);
            } else {
                g.setGrayScale(0);
            }
            g.drawChar(c, x, y, 17);
        }

        void showCursor(Graphics g, int pos, boolean show) {
            int row = pos / this.cols;
            int col = pos % this.cols;
            int y = this.wy + row * this.cc;
            int x = this.wx + col * this.cc;
            if (show) {
                g.setGrayScale(0);
            } else {
                g.setGrayScale(255);
            }
            g.fillRect(x + this.margin, y + this.margin, this.cc - this.margin - 1, this.cc - this.margin - 1);
            this.drawChar(g, EmulInputMethodHandler.this.symbolTableChars[pos], row, col, show);
        }

        protected void keyPressed(int keyCode) {
            if (keyCode > 0 && (char)keyCode == '*') {
                this.tmpimc.setCurrent(this.previousScreen, this.currentDisplay);
                this.currentDisplay.callSerially(new Runnable(this){
                    private final /* synthetic */ SymbolTable this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        SymbolTable.access$000(this.this$1).endComposition(true);
                        SymbolTable.access$000((SymbolTable)this.this$1).ignoreNextKeyRelease = true;
                        SymbolTable.access$000(this.this$1).switchToNextInputMode(true);
                    }
                });
            } else {
                switch (this.getGameAction(keyCode)) {
                    case 5: {
                        if (this.pos + 1 >= EmulInputMethodHandler.this.symbolTableChars.length) break;
                        this.newpos = this.pos + 1;
                        this.repaint();
                        break;
                    }
                    case 2: {
                        if (this.pos <= 0) break;
                        this.newpos = this.pos - 1;
                        this.repaint();
                        break;
                    }
                    case 1: {
                        int p = this.pos - this.cols;
                        if (p < 0) break;
                        this.newpos = p;
                        this.repaint();
                        break;
                    }
                    case 6: {
                        int p = this.pos + this.cols;
                        if (p >= EmulInputMethodHandler.this.symbolTableChars.length) break;
                        this.newpos = p;
                        this.repaint();
                        break;
                    }
                    case 8: {
                        this.tmpimc.setCurrent(this.previousScreen, this.currentDisplay);
                        this.currentDisplay.callSerially(new Runnable(this){
                            private final /* synthetic */ SymbolTable this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                SymbolTable.access$000((SymbolTable)this.this$1).lastKey = SymbolTable.access$000((SymbolTable)this.this$1).symbolTableChars[SymbolTable.access$100(this.this$1)];
                                SymbolTable.access$000(this.this$1).endComposition(false);
                                SymbolTable.access$000((SymbolTable)this.this$1).ignoreNextKeyRelease = true;
                                SymbolTable.access$000(this.this$1).switchToNextInputMode(true);
                            }
                        });
                    }
                }
            }
        }

        static /* synthetic */ EmulInputMethodHandler access$000(SymbolTable x0) {
            return x0.EmulInputMethodHandler.this;
        }

        static /* synthetic */ int access$100(SymbolTable x0) {
            return x0.pos;
        }
    }

    class TimerClient
    extends TimerTask {
        TimerClient() {
        }

        public final void run() {
            EmulInputMethodHandler.this.timerWentOff();
        }
    }
}

