/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.sms;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.midp.io.j2me.sms.BinaryObject;
import com.sun.midp.io.j2me.sms.DatagramImpl;
import com.sun.midp.io.j2me.sms.MessageObject;
import com.sun.midp.io.j2me.sms.TextObject;
import com.sun.midp.io.j2me.sms.TransportImpl;
import com.sun.midp.io.j2me.sms.TransportMessage;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class Protocol
implements MessageConnection,
ConnectionBaseInterface,
StreamConnection {
    protected static Vector openconnections = new Vector();
    protected TransportImpl smsimpl;
    protected static TransportImpl sharedimpl;
    protected String url;
    protected static int open_count;
    private MIDletSuite midletSuite;
    private int connectionPermission = -1;
    private int receivePermission = -1;
    private boolean openPermission = false;
    protected boolean profiling = false;
    int[] restrictedPorts = new int[]{2805, 2923, 2948, 2949, 5502, 5503, 5508, 5511, 5512, 9200, 9201, 9202, 9203, 9207, 49996, 49999};
    protected String host = null;
    protected String port = null;
    protected String tunnelport = null;
    protected boolean usetunnel = false;
    protected boolean open;
    private static SecurityToken classSecurityToken;

    public Protocol() {
        try {
            this.midletSuite = Scheduler.getScheduler().getMIDletSuite();
            this.tunnelport = Configuration.getProperty("com.sun.midp.io.j2me.sms.CBSPort");
            String impl = Configuration.getPropertyDefault("com.sun.midp.io.j2me.sms.Impl", "com.sun.midp.io.j2me.sms.DatagramImpl");
            if (sharedimpl == null) {
                sharedimpl = (TransportImpl)Class.forName(impl).newInstance();
                try {
                    sharedimpl.open(this, classSecurityToken);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.smsimpl = sharedimpl;
            String prof = Configuration.getProperty("com.sun.midp.io.j2me.sms.profiling");
            if (prof != null) {
                this.profiling = prof.equals("true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connectionPermission = 11;
        this.receivePermission = 14;
    }

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        return this.openPrimInternal(name, mode, timeouts, false);
    }

    public Connection openPrimInternal(String name, int mode, boolean timeouts, boolean usecbs) throws IOException {
        int len;
        this.usetunnel = usecbs;
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Missing protocol separator");
        }
        int colon = name.indexOf(58);
        if (colon > 0) {
            if (colon != 2) {
                this.host = name.substring(2, colon);
            }
            this.port = name.substring(colon + 1);
        } else if (name.length() > 2) {
            this.host = name.substring(2);
        }
        if (this.host != null) {
            int offset = 0;
            int len2 = this.host.length();
            char c = '\u0000';
            if (len2 > 0) {
                c = this.host.charAt(0);
                if (c == '+') {
                    offset = 1;
                }
                for (int i = offset; i < this.host.length(); ++i) {
                    c = this.host.charAt(i);
                    if ('0' <= c && c <= '9') continue;
                    throw new IllegalArgumentException("Host format");
                }
            }
        }
        if (this.port != null) {
            len = this.port.length();
            char c = '\u0000';
            if (len > 0) {
                for (int i = 0; i < this.port.length(); ++i) {
                    c = this.port.charAt(i);
                    if ('0' <= c && c <= '9') continue;
                    throw new IllegalArgumentException("Port format");
                }
            } else {
                throw new IllegalArgumentException("Port length");
            }
            try {
                long portNumber = Long.parseLong(this.port);
                if (portNumber > 65535L) {
                    throw new IllegalArgumentException("Port range");
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (this.port.equals(this.tunnelport) && !usecbs) {
                throw new IllegalArgumentException("Reserved CBS port");
            }
        }
        if (mode == 1 && this.host != null && this.host.length() > 0) {
            throw new IllegalArgumentException("Cannot read on client connection");
        }
        if (mode <= 0 || 3 < mode) {
            throw new IllegalArgumentException("Invalid mode");
        }
        if (!this.openPermission) {
            try {
                this.midletSuite.checkForPermission(this.connectionPermission, usecbs ? "cbs:open" : "sms:open");
                this.openPermission = true;
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted while trying to ask the user permission");
            }
        }
        len = openconnections.size();
        for (int i = 0; i < len; ++i) {
            if (openconnections.elementAt(i) instanceof com.sun.midp.io.j2me.cbs.Protocol || !((Protocol)Protocol.openconnections.elementAt((int)i)).url.equals(name)) continue;
            throw new IOException("Already opened");
        }
        openconnections.addElement(this);
        this.url = name;
        ++open_count;
        this.open = true;
        return this;
    }

    public void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Connection closed");
        }
    }

    public void close() throws IOException {
        this.ensureOpen();
        if (this.open) {
            this.open = false;
            this.smsimpl.setMessageListener(this, null, this.port);
            int len = openconnections.size();
            for (int i = 0; i < len; ++i) {
                if (openconnections.elementAt(i) != this) continue;
                openconnections.removeElementAt(i);
                break;
            }
            --open_count;
            if (this.smsimpl instanceof DatagramImpl) {
                ((DatagramImpl)this.smsimpl).notifyClosedConnection();
            }
            if (open_count == 0) {
                sharedimpl.close();
                sharedimpl = null;
            }
        }
    }

    public Message newMessage(String type) {
        String addr = null;
        if (this.host != null) {
            addr = "sms://" + this.host;
            if (this.port != null) {
                addr = addr + ":" + this.port;
            }
        }
        return this.newMessage(type, addr);
    }

    public Message newMessage(String type, String addr) {
        if (type.equals("text")) {
            return new TextObject(addr);
        }
        if (type.equals("binary")) {
            return new BinaryObject(addr);
        }
        throw new IllegalArgumentException("Type not supported");
    }

    public void send(Message dmsg) throws IOException {
        long start = 0L;
        long end = 0L;
        byte[] buf = null;
        String type = null;
        String sendHost = null;
        if (this.profiling) {
            start = System.currentTimeMillis();
        }
        this.ensureOpen();
        if (dmsg instanceof TextMessage) {
            type = "text";
            buf = ((TextObject)dmsg).getBytes();
        } else if (dmsg instanceof BinaryMessage) {
            buf = ((BinaryMessage)dmsg).getPayloadData();
            type = "binary";
        }
        String addr = dmsg.getAddress();
        if (addr == null || addr.length() == 0 || !addr.startsWith("sms://")) {
            throw new IllegalArgumentException("Invalid address");
        }
        int colon = addr.lastIndexOf(58);
        if (colon != -1) {
            int sendPort = -1;
            sendHost = colon != 3 ? addr.substring(6, colon) : addr.substring(6);
            if (sendHost == null || sendHost.length() == 0) {
                throw new IllegalArgumentException("Invalid send address");
            }
            if (sendHost != null) {
                int offset = 0;
                int len = sendHost.length();
                char c = '\u0000';
                if (len > 0) {
                    c = sendHost.charAt(0);
                    if (c == '+') {
                        offset = 1;
                    }
                    for (int i = offset; i < sendHost.length(); ++i) {
                        c = sendHost.charAt(i);
                        if ('0' <= c && c <= '9') continue;
                        throw new IllegalArgumentException("Host format");
                    }
                }
            }
            try {
                sendPort = Integer.parseInt(addr.substring(colon + 1));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (sendPort > 65535) {
                throw new IllegalArgumentException("Port range");
            }
            for (int i = 0; i < this.restrictedPorts.length; ++i) {
                if (sendPort != this.restrictedPorts[i]) continue;
                throw new SecurityException("Port not allowed");
            }
        }
        try {
            this.midletSuite.checkForPermission(13, sendHost, Integer.toString(this.numberOfSegments(dmsg)));
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
        long sendTime = this.smsimpl.send(type, dmsg.getAddress(), buf, this.host == null ? this.port : null);
        if (this.profiling) {
            end = System.currentTimeMillis();
            System.out.println("S," + sendTime + "," + start + "," + end + "," + (end - start));
        }
    }

    public synchronized Message receive() throws IOException {
        long start = 0L;
        long end = 0L;
        if (this.host != null) {
            throw new IOException("Can not receive from client only connection." + this.host);
        }
        this.checkReceivePermission();
        if (this.profiling) {
            start = System.currentTimeMillis();
        }
        this.ensureOpen();
        boolean portMatch = false;
        TextObject msg = null;
        TransportMessage tm = null;
        while (!portMatch) {
            byte[] buf;
            tm = this.smsimpl.receive(this);
            String addr = tm.getAddress();
            int colon = addr.lastIndexOf(58);
            int urlcolon = this.url.lastIndexOf(58);
            if (colon > 0) {
                portMatch = this.usetunnel ? this.url.substring(urlcolon + 1).equals(addr.substring(colon + 1)) : addr.substring(colon + 1).equals(this.port);
            }
            if (tm.getType().equals("text")) {
                TextObject textmsg = (TextObject)this.newMessage("text", tm.getAddress());
                buf = tm.getData();
                textmsg.setBytes(buf);
                msg = textmsg;
            } else {
                BinaryMessage binmsg = (BinaryMessage)this.newMessage("binary", tm.getAddress());
                buf = tm.getData();
                binmsg.setPayloadData(buf);
                msg = binmsg;
            }
            ((MessageObject)msg).setTimeStamp(tm.getTimeStamp());
            ((MessageObject)msg).setAddress(tm.getSenderAddress());
        }
        if (this.profiling) {
            end = System.currentTimeMillis();
            System.out.println("R," + tm.getTimeStamp() + "," + start + "," + end + "," + (end - start));
        }
        return msg;
    }

    void checkReceivePermission() throws InterruptedIOException {
        try {
            this.midletSuite.checkForPermission(this.receivePermission, this.usetunnel ? "cbs:receive" : "sms:receive");
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
    }

    protected final void setPermissions(SecurityToken token, int connPerm, int receivePerm) {
        token.checkIfPermissionAllowed(0);
        this.connectionPermission = connPerm;
        this.receivePermission = receivePerm;
    }

    public void setMessageListener(MessageListener l) throws IOException {
        this.ensureOpen();
        this.checkReceivePermission();
        if (this.host != null && this.host.length() > 0) {
            throw new IOException("Cannot listen on client connection");
        }
        this.smsimpl.setMessageListener(this, l, this.port);
    }

    public int numberOfSegments(Message msg) {
        return this.smsimpl.numberOfSegments(msg);
    }

    public InputStream openInputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    public DataInputStream openDataInputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    public OutputStream openOutputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    static {
        open_count = 0;
    }
}

