/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.serversocket;

import com.sun.cldc.io.Waiter;
import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.socket.Protocol;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnection;

public class Socket
implements ServerSocketConnection {
    private int handle;
    private SecurityToken ownerSecurityToken = null;
    boolean connectionOpen = false;

    public void open(int port) throws IOException {
        this.open(null, port);
    }

    public void open(SecurityToken token, int port) throws IOException {
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        String root = midletSuite.getStorageName();
        byte[] asciiStorage = Util.toCString(root);
        this.open0(port > 0 ? port : 0, asciiStorage);
        this.connectionOpen = true;
        port = this.getLocalPort();
        try {
            if (token != null) {
                token.checkIfPermissionAllowed(6);
                this.ownerSecurityToken = token;
            } else {
                midletSuite.checkForPermission(6, "TCP://:" + port);
            }
        }
        catch (SecurityException e) {
            this.close();
            throw e;
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
        this.registerCleanup();
    }

    void ensureOpen() throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection closed");
        }
    }

    private native void open0(int var1, byte[] var2) throws IOException;

    public synchronized StreamConnection acceptAndOpen() throws IOException {
        int handle;
        this.ensureOpen();
        while (true) {
            if ((handle = this.accept()) >= 0) break;
            Waiter.waitForIO();
        }
        Protocol con = this.getProtocolClass();
        con.open(this.ownerSecurityToken, handle);
        return con;
    }

    public String getLocalAddress() throws IOException {
        this.ensureOpen();
        return this.getLocalAddress0();
    }

    public int getLocalPort() throws IOException {
        this.ensureOpen();
        return this.getLocalPort0();
    }

    public void close() throws IOException {
        if (this.connectionOpen) {
            this.close0();
            this.connectionOpen = false;
        }
    }

    private native int accept() throws IOException;

    private native void close0() throws IOException;

    private native void registerCleanup();

    private native void finalize();

    private native String getLocalAddress0();

    private native int getLocalPort0();

    protected synchronized Protocol getProtocolClass() throws IOException {
        return new Protocol();
    }
}

