/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.mms;

import com.sun.midp.io.j2me.mms.MMSAddress;
import com.sun.midp.io.j2me.sms.MessageObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.MultipartMessage;
import javax.wireless.messaging.SizeExceededException;

public class MultipartObject
extends MessageObject
implements MultipartMessage {
    Vector to = new Vector();
    Vector cc = new Vector();
    Vector bcc = new Vector();
    Vector parts = new Vector();
    String startContentID = null;
    String subject = null;
    String[] headerValues;
    String applicationID = null;
    String replyToApplicationID = null;
    static final String[] ALLOWED_HEADER_FIELDS = new String[]{"X-Mms-Delivery-Time", "X-Mms-Priority"};
    static final String[] DEFAULT_HEADER_VALUES = new String[]{null, "Normal"};
    static final String[] KNOWN_HEADER_FIELDS = new String[]{"X-Mms-Message-Type", "X-Mms-Transaction-ID", "X-Mms-MMS-Version", "X-Mms-Content-Type", "X-Mms-Subject", "X-Mms-From", "X-Mms-To", "X-Mms-CC", "X-Mms-BCC"};
    static final int MAX_TOTAL_SIZE = 30730;
    static final String STREAM_SIGNATURE = "application/vnd.wap.mms-message";

    public MultipartObject(String toAddress) {
        super("multipart", null);
        this.setupHeaderFields();
        if (toAddress != null) {
            this.addAddress("to", toAddress);
        }
    }

    String getReplyToApplicationID() {
        return this.replyToApplicationID;
    }

    public void setReplyToApplicationID(String appID) {
        this.replyToApplicationID = appID;
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public void setFromAddress(String fromAddress) {
        super.setAddress(fromAddress);
    }

    public void fixupReceivedMessageAddresses(String senderAddress, String myAddress) {
        String regularAddress = myAddress;
        String plusAddress = myAddress;
        if (regularAddress.charAt(0) == '+') {
            regularAddress = regularAddress.substring(1);
        } else if (plusAddress.charAt(0) != '+') {
            plusAddress = "+" + plusAddress;
        }
        Vector addresses = this.to;
        for (int i = 0; i < 2; ++i) {
            int numAdds = addresses.size();
            for (int index = 0; index < numAdds; ++index) {
                String thisAddress = (String)addresses.elementAt(index);
                MMSAddress parsedAddress = MMSAddress.getParsedMMSAddress(thisAddress);
                if (parsedAddress == null || !regularAddress.equals(parsedAddress.address) && !plusAddress.equals(parsedAddress.address)) continue;
                --numAdds;
                addresses.removeElementAt(index);
                --index;
            }
            addresses = this.cc;
        }
        if (senderAddress != null) {
            String formalAddress = senderAddress;
            this.to.insertElementAt(formalAddress, 0);
            MMSAddress parsedAddress = MMSAddress.getParsedMMSAddress(formalAddress);
            this.applicationID = parsedAddress.appId;
        } else {
            this.applicationID = null;
        }
    }

    Vector getAddressList(String type) {
        String lower = type.toLowerCase();
        if (lower.equals("to")) {
            return this.to;
        }
        if (lower.equals("cc")) {
            return this.cc;
        }
        if (lower.equals("bcc")) {
            return this.bcc;
        }
        throw new IllegalArgumentException("Address type is not 'to', 'cc', or 'bcc'");
    }

    MMSAddress checkValidAddress(String addr) throws IllegalArgumentException {
        MMSAddress parsedAddress = MMSAddress.getParsedMMSAddress(addr);
        if (parsedAddress == null || parsedAddress.type == -1 || parsedAddress.type == 5) {
            throw new IllegalArgumentException("Invalid destination address: " + addr);
        }
        return parsedAddress;
    }

    void checkApplicationID(String newAppID) throws IllegalArgumentException {
        if (this.applicationID != null) {
            if (!this.applicationID.equals(newAppID)) {
                throw new IllegalArgumentException("Only one Application-ID can be specified per message");
            }
        } else {
            this.applicationID = newAppID;
        }
    }

    static boolean isKnownHeaderField(String headerField) {
        String lowerFieldName = headerField.toLowerCase();
        for (int i = 0; i < KNOWN_HEADER_FIELDS.length; ++i) {
            if (!lowerFieldName.equals(KNOWN_HEADER_FIELDS[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    void setupHeaderFields() {
        this.headerValues = new String[ALLOWED_HEADER_FIELDS.length];
        for (int i = 0; i < DEFAULT_HEADER_VALUES.length; ++i) {
            this.headerValues[i] = DEFAULT_HEADER_VALUES[i];
        }
    }

    static int getHeaderFieldIndex(String headerField) {
        String lowerFieldName = headerField.toLowerCase();
        for (int i = 0; i < ALLOWED_HEADER_FIELDS.length; ++i) {
            if (!lowerFieldName.equals(ALLOWED_HEADER_FIELDS[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    boolean isAllowedToAccessHeaderField(String field) {
        return MultipartObject.getHeaderFieldIndex(field) != -1;
    }

    static void checkHeaderValue(int headerIndex, String value) {
        switch (headerIndex) {
            case 0: {
                try {
                    Long.parseLong(value);
                    return;
                }
                catch (NumberFormatException nfe) {
                    break;
                }
            }
            case 1: {
                String lower = value.toLowerCase();
                if (!lower.equals("normal") && !lower.equals("high") && !lower.equals("low")) break;
                return;
            }
            default: {
                throw new Error("Unknown headerIndex: " + headerIndex);
            }
        }
        throw new IllegalArgumentException("Illegal value for header " + ALLOWED_HEADER_FIELDS[headerIndex] + ": " + value);
    }

    public boolean addAddress(String type, String address) throws IllegalArgumentException {
        Vector which;
        MMSAddress parsedAddress = this.checkValidAddress(address);
        String appID = parsedAddress.appId;
        if (appID != null) {
            this.checkApplicationID(appID);
        }
        if (!(which = this.getAddressList(type)).contains(address)) {
            which.addElement(address);
            return true;
        }
        return false;
    }

    public void addMessagePart(MessagePart part) throws SizeExceededException {
        String thisContentID = part.getContentID();
        boolean duplicateContentID = false;
        int totalSizeSoFar = 0;
        int numPartsSoFar = this.parts.size();
        for (int i = 0; i < numPartsSoFar; ++i) {
            MessagePart onePart = (MessagePart)this.parts.elementAt(i);
            if (thisContentID.equals(onePart.getContentID())) {
                throw new IllegalArgumentException("Cannot add duplicate content-id: " + thisContentID);
            }
            totalSizeSoFar += onePart.getLength();
        }
        if (totalSizeSoFar + part.getLength() > 30730) {
            throw new SizeExceededException("Adding this MessagePart would exceed max size of 30730 bytes");
        }
        this.parts.addElement(part);
    }

    public String getAddress() {
        String returnMe = null;
        Date tStamp = this.getTimestamp();
        if (tStamp == null || tStamp.getTime() == 0L) {
            if (this.to.size() > 0) {
                returnMe = (String)this.to.elementAt(0);
            }
        } else {
            returnMe = super.getAddress();
        }
        return returnMe;
    }

    public String[] getAddresses(String type) {
        if (type.toLowerCase().equals("from")) {
            String address = super.getAddress();
            if (address == null) {
                return null;
            }
            return new String[]{address};
        }
        Vector which = this.getAddressList(type);
        int num = which.size();
        if (num == 0) {
            return null;
        }
        Object[] addresses = new String[num];
        which.copyInto(addresses);
        return addresses;
    }

    public String getHeader(String headerField) {
        if (headerField == null) {
            throw new IllegalArgumentException("headerField must not be null");
        }
        if (this.isAllowedToAccessHeaderField(headerField)) {
            int index = MultipartObject.getHeaderFieldIndex(headerField);
            if (index != -1) {
                return this.headerValues[index];
            }
            throw new Error("Allowed to access field but it has no index");
        }
        if (MultipartObject.isKnownHeaderField(headerField)) {
            throw new SecurityException("Cannot access restricted header field: " + headerField);
        }
        throw new IllegalArgumentException("Unknown header field: " + headerField);
    }

    public MessagePart getMessagePart(String contentID) {
        if (contentID == null) {
            throw new NullPointerException("contentID must not be null");
        }
        int numParts = this.parts.size();
        for (int i = 0; i < numParts; ++i) {
            MessagePart onePart = (MessagePart)this.parts.elementAt(i);
            if (!contentID.equals(onePart.getContentID())) continue;
            return onePart;
        }
        return null;
    }

    public MessagePart[] getMessageParts() {
        int num = this.parts.size();
        if (num == 0) {
            return null;
        }
        Object[] msgParts = new MessagePart[num];
        this.parts.copyInto(msgParts);
        return msgParts;
    }

    public String getStartContentId() {
        return this.startContentID;
    }

    public String getSubject() {
        return this.subject;
    }

    private void cleanupAppID() throws IllegalStateException {
        Vector addresses = this.to;
        boolean checkedTo = false;
        boolean checkedCC = false;
        int currIndex = 0;
        boolean matchedAppID = false;
        while (true) {
            String addr;
            MMSAddress parsedAddress;
            if (currIndex >= addresses.size()) {
                if (!checkedTo) {
                    checkedTo = true;
                    addresses = this.cc;
                    currIndex = 0;
                    continue;
                }
                if (checkedCC) break;
                checkedCC = true;
                addresses = this.bcc;
                currIndex = 0;
                continue;
            }
            if ((parsedAddress = MMSAddress.getParsedMMSAddress(addr = (String)addresses.elementAt(currIndex++))) == null || parsedAddress.type == -1 || parsedAddress.type == 5) {
                throw new IllegalStateException("Invalid MMS address: " + addr);
            }
            String thisAppID = parsedAddress.appId;
            if (thisAppID == null || !thisAppID.equals(this.applicationID)) continue;
            matchedAppID = true;
        }
        if (!matchedAppID) {
            this.applicationID = null;
        }
    }

    public boolean removeAddress(String type, String address) {
        Vector which = this.getAddressList(type);
        boolean result = which.removeElement(address);
        this.cleanupAppID();
        return result;
    }

    public void removeAddresses() {
        this.to.removeAllElements();
        this.cc.removeAllElements();
        this.bcc.removeAllElements();
        this.applicationID = null;
    }

    public void removeAddresses(String type) {
        Vector which = this.getAddressList(type);
        which.removeAllElements();
        this.cleanupAppID();
    }

    public boolean removeMessagePart(MessagePart part) {
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        if (part.getContentID().equals(this.startContentID)) {
            this.startContentID = null;
        }
        return this.parts.removeElement(part);
    }

    public boolean removeMessagePartId(String contentID) {
        if (contentID == null) {
            throw new NullPointerException("contentID must not be null");
        }
        int numParts = this.parts.size();
        for (int i = 0; i < numParts; ++i) {
            MessagePart onePart = (MessagePart)this.parts.elementAt(i);
            if (!contentID.equals(onePart.getContentID())) continue;
            if (contentID.equals(this.startContentID)) {
                this.startContentID = null;
            }
            this.parts.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean removeMessagePartLocation(String contentLocation) {
        if (contentLocation == null) {
            throw new NullPointerException("contentLocation must not be null");
        }
        int numParts = this.parts.size();
        boolean found = false;
        for (int i = 0; i < numParts; ++i) {
            MessagePart onePart = (MessagePart)this.parts.elementAt(i);
            if (!contentLocation.equals(onePart.getContentLocation())) continue;
            if (onePart.getContentID().equals(this.startContentID)) {
                this.startContentID = null;
            }
            this.parts.removeElementAt(i);
            --numParts;
            --i;
            found = true;
        }
        return found;
    }

    public void setAddress(String address) {
        if (address != null) {
            this.addAddress("to", address);
        }
    }

    public void setHeader(String headerField, String headerValue) {
        if (this.isAllowedToAccessHeaderField(headerField)) {
            int index = MultipartObject.getHeaderFieldIndex(headerField);
            if (index != -1) {
                if (headerValue != null) {
                    MultipartObject.checkHeaderValue(index, headerValue);
                }
                this.headerValues[index] = headerValue;
                return;
            }
            throw new Error("Allowed to access field but it has no index");
        }
        if (MultipartObject.isKnownHeaderField(headerField)) {
            throw new SecurityException("Cannot access restricted header field: " + headerField);
        }
        throw new IllegalArgumentException("Unknown header field: " + headerField);
    }

    public void setStartContentId(String contentId) {
        if (contentId != null && this.getMessagePart(contentId) == null) {
            throw new IllegalArgumentException("Unknown contentId: " + contentId);
        }
        this.startContentID = contentId;
    }

    public void setSubject(String subject) {
        if (subject != null && subject.length() > 40) {
            throw new IllegalArgumentException("Subject exceeds 40 chars");
        }
        this.subject = subject;
    }

    static String getDevicePortionOfAddress(String address) throws IllegalArgumentException {
        MMSAddress parsedAddress = MMSAddress.getParsedMMSAddress(address);
        if (parsedAddress == null || parsedAddress.address == null) {
            throw new IllegalArgumentException("MMS Address has no device portion");
        }
        return parsedAddress.address;
    }

    static void writeVector(DataOutputStream dos, Vector v, boolean isAddress) throws IOException {
        StringBuffer buff = new StringBuffer();
        int len = v.size();
        String appendMe = null;
        if (len > 0) {
            appendMe = (String)v.elementAt(0);
            if (isAddress) {
                appendMe = MultipartObject.getDevicePortionOfAddress(appendMe);
            }
            buff.append(appendMe);
        }
        for (int i = 1; i < len; ++i) {
            buff.append("; ");
            appendMe = (String)v.elementAt(i);
            if (isAddress) {
                appendMe = MultipartObject.getDevicePortionOfAddress(appendMe);
            }
            buff.append(appendMe);
        }
        dos.writeUTF(buff.toString());
    }

    static void readVector(DataInputStream dis, Vector v, boolean isAddress) throws IOException {
        String inputStr = dis.readUTF();
        int prevDelim = -2;
        String prefix = "";
        if (isAddress) {
            prefix = "mms://";
        }
        while (prevDelim != -1) {
            int nextDelim = inputStr.indexOf("; ", prevDelim + 2);
            String addStr = null;
            addStr = nextDelim == -1 ? prefix + inputStr.substring(prevDelim + 2) : prefix + inputStr.substring(prevDelim + 2, nextDelim);
            v.addElement(addStr);
            prevDelim = nextDelim;
        }
    }

    static void writeMessagePart(DataOutputStream dos, MessagePart p) throws IOException {
        String enc;
        dos.writeUTF("Content-Type");
        StringBuffer contentType = new StringBuffer(p.getMIMEType());
        String loc = p.getContentLocation();
        if (loc != null) {
            contentType.append("; name=\"");
            contentType.append(loc);
            contentType.append("\"");
        }
        dos.writeUTF(contentType.toString());
        String id = p.getContentID();
        if (id != null) {
            dos.writeUTF("Content-ID");
            dos.writeUTF(id);
        }
        if ((enc = p.getEncoding()) != null) {
            dos.writeUTF("Encoding");
            dos.writeUTF(enc);
        }
        dos.writeUTF("Content-Length");
        dos.writeInt(p.getLength());
        dos.writeUTF("Content");
        dos.write(p.getContent());
    }

    static MessagePart createMessagePart(DataInputStream dis) throws IOException {
        String nextField = dis.readUTF();
        String contentType = dis.readUTF();
        nextField = dis.readUTF();
        String contentID = null;
        if (nextField.equals("Content-ID")) {
            contentID = dis.readUTF();
            nextField = dis.readUTF();
        }
        String encoding = null;
        if (nextField.equals("Encoding")) {
            encoding = dis.readUTF();
            nextField = dis.readUTF();
        }
        int length = dis.readInt();
        byte[] contents = new byte[length];
        nextField = dis.readUTF();
        dis.readFully(contents);
        String mimeType = contentType;
        String contentLocation = null;
        int sepPos = contentType.indexOf(59);
        if (sepPos != -1 && contentType.substring(sepPos).startsWith("; name=\"")) {
            contentLocation = contentType.substring(sepPos + 8, contentType.length() - 1);
            mimeType = contentType.substring(0, sepPos);
        }
        return new MessagePart(contents, mimeType, contentID, contentLocation, encoding);
    }

    public byte[] getAsByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(STREAM_SIGNATURE);
        dos.writeUTF("X-Mms-Message-Type");
        dos.writeUTF("m-send-req");
        dos.writeUTF("X-Mms-Transaction-ID");
        dos.writeUTF(String.valueOf(System.currentTimeMillis()));
        dos.writeUTF("X-Mms-Version");
        dos.writeUTF("1.0");
        for (int i = 0; i < ALLOWED_HEADER_FIELDS.length; ++i) {
            String headerValue = this.headerValues[i];
            if (headerValue == null) continue;
            dos.writeUTF(ALLOWED_HEADER_FIELDS[i]);
            dos.writeUTF(headerValue);
        }
        String fromAddress = super.getAddress();
        if (fromAddress != null) {
            dos.writeUTF("From");
            dos.writeUTF(MultipartObject.getDevicePortionOfAddress(fromAddress));
        }
        if (this.to.size() != 0) {
            dos.writeUTF("To");
            MultipartObject.writeVector(dos, this.to, true);
        }
        if (this.cc.size() != 0) {
            dos.writeUTF("Cc");
            MultipartObject.writeVector(dos, this.cc, true);
        }
        if (this.bcc.size() != 0) {
            dos.writeUTF("Bcc");
            MultipartObject.writeVector(dos, this.bcc, true);
        }
        long date = 0L;
        Date tStamp = this.getTimestamp();
        if (tStamp != null && (date = tStamp.getTime()) != 0L) {
            dos.writeUTF("Date");
            dos.writeUTF(String.valueOf(date));
        }
        if (this.subject != null) {
            dos.writeUTF("Subject");
            dos.writeUTF(this.subject);
        }
        dos.writeUTF("Content-Type");
        Vector<String> contentTypeElements = new Vector<String>();
        if (this.startContentID != null) {
            contentTypeElements.addElement("application/vnd.wap.multipart.related");
        } else {
            contentTypeElements.addElement("application/vnd.wap.multipart.mixed");
        }
        if (this.startContentID != null) {
            contentTypeElements.addElement("start = <" + this.startContentID + ">");
            contentTypeElements.addElement("type = " + this.getMessagePart(this.startContentID).getMIMEType());
        }
        if (this.applicationID != null) {
            contentTypeElements.addElement("Application-ID = " + this.applicationID);
        }
        if (this.replyToApplicationID != null) {
            contentTypeElements.addElement("Reply-To-Application-ID = " + this.replyToApplicationID);
        }
        MultipartObject.writeVector(dos, contentTypeElements, false);
        dos.writeUTF("nEntries");
        int numParts = this.parts.size();
        dos.writeUTF(String.valueOf(numParts));
        for (int i = 0; i < numParts; ++i) {
            MessagePart p = (MessagePart)this.parts.elementAt(i);
            MultipartObject.writeMessagePart(dos, p);
        }
        dos.close();
        byte[] returnMe = baos.toByteArray();
        baos.close();
        return returnMe;
    }

    public static MultipartObject createFromByteArray(byte[] data) throws IOException {
        int headerIndex;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        String signature = dis.readUTF();
        if (!signature.equals(STREAM_SIGNATURE)) {
            throw new IOException("invalid data format");
        }
        for (int i = 0; i < 6; ++i) {
            dis.readUTF();
        }
        String[] headerValues = new String[ALLOWED_HEADER_FIELDS.length];
        String nextField = dis.readUTF();
        while ((headerIndex = MultipartObject.getHeaderFieldIndex(nextField)) != -1) {
            headerValues[headerIndex] = dis.readUTF();
            nextField = dis.readUTF();
        }
        String fromAddress = null;
        if (nextField.equals("From")) {
            fromAddress = "mms://" + dis.readUTF();
            nextField = dis.readUTF();
        }
        Vector to = new Vector();
        if (nextField.equals("To")) {
            MultipartObject.readVector(dis, to, true);
            nextField = dis.readUTF();
        }
        Vector cc = new Vector();
        if (nextField.equals("Cc")) {
            MultipartObject.readVector(dis, cc, true);
            nextField = dis.readUTF();
        }
        Vector bcc = new Vector();
        if (nextField.equals("Bcc")) {
            MultipartObject.readVector(dis, bcc, true);
            nextField = dis.readUTF();
        }
        long date = 0L;
        if (nextField.equals("Date")) {
            String dateStr = dis.readUTF();
            try {
                date = Long.parseLong(dateStr);
            }
            catch (NumberFormatException nfe) {
                date = 0L;
            }
            nextField = dis.readUTF();
        }
        String subject = null;
        if (nextField.equals("Subject")) {
            subject = dis.readUTF();
            nextField = dis.readUTF();
        }
        String startContentID = null;
        String applicationID = null;
        String replyToApplicationID = null;
        Vector contentTypeElements = new Vector();
        MultipartObject.readVector(dis, contentTypeElements, false);
        int numContentTypeElements = contentTypeElements.size();
        for (int i = 0; i < numContentTypeElements; ++i) {
            String element = (String)contentTypeElements.elementAt(i);
            if (element.startsWith("start = <")) {
                startContentID = element.substring(9);
                startContentID = startContentID.substring(0, startContentID.length() - 1);
                continue;
            }
            if (element.startsWith("Application-ID = ")) {
                applicationID = element.substring(17);
                continue;
            }
            if (!element.startsWith("Reply-To-Application-ID = ")) continue;
            replyToApplicationID = element.substring(26);
        }
        nextField = dis.readUTF();
        int numParts = 0;
        String numPartsStr = dis.readUTF();
        try {
            numParts = Integer.parseInt(numPartsStr);
        }
        catch (NumberFormatException nfe) {
            numParts = 0;
        }
        Vector<MessagePart> parts = new Vector<MessagePart>();
        for (int i = 0; i < numParts; ++i) {
            parts.addElement(MultipartObject.createMessagePart(dis));
        }
        dis.close();
        bais.close();
        MultipartObject mpo = new MultipartObject(fromAddress);
        mpo.setTimeStamp(date);
        mpo.headerValues = headerValues;
        mpo.subject = subject;
        mpo.startContentID = startContentID;
        mpo.to = to;
        mpo.cc = cc;
        mpo.parts = parts;
        mpo.applicationID = applicationID;
        mpo.replyToApplicationID = replyToApplicationID;
        return mpo;
    }
}

