/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.mms;

public class MMSAddress {
    public static final int INVALID_ADDRESS = -1;
    public static final int EMAIL = 0;
    public static final int GLOBAL_PHONE_NUMBER = 1;
    public static final int IPV4 = 2;
    public static final int IPV6 = 3;
    public static final int SHORTCODE = 4;
    public static final int APP_ID = 5;
    public String address;
    public String appId;
    public int type;

    private static boolean hex(char c) {
        return MMSAddress.digit(c) || c >= 'A' && c <= 'F';
    }

    private static boolean alpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean digit(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean parsePhoneNumber(String s, int i, MMSAddress mmsAddress) {
        int len = s.length();
        if (i < 0 || i >= len) {
            return false;
        }
        int initI = i;
        char c = s.charAt(i);
        if (c == '+' && len == ++i) {
            return false;
        }
        int j = 0;
        while (i < len && MMSAddress.digit(c = s.charAt(i))) {
            ++j;
            ++i;
        }
        if (j == 0) {
            return false;
        }
        if (i == len) {
            mmsAddress.set(s.substring(initI), null, 1);
            return true;
        }
        if (c == ':') {
            mmsAddress.set(s.substring(initI, i), null, 1);
            return MMSAddress.parseApplicationId(s, i, mmsAddress);
        }
        return false;
    }

    static boolean parseIpv4(String s, int i, MMSAddress mmsAddress) {
        int len = s.length();
        if (i <= 0 || i >= len) {
            return false;
        }
        int initI = i;
        for (int num = 1; num < 5; ++num) {
            char c;
            int j;
            for (j = 0; j < 3 && i < len && MMSAddress.digit(c = s.charAt(i)); ++i, ++j) {
            }
            if (j == 0 || j == 3 && ((s.charAt(i - 3) - 48) * 10 + (s.charAt(i - 2) - 48)) * 10 + (s.charAt(i - 1) - 48) > 255) {
                return false;
            }
            if (i == len) {
                if (num == 4) {
                    mmsAddress.set(s.substring(initI), null, 2);
                    return true;
                }
                return false;
            }
            c = s.charAt(i);
            if (c == ':') {
                mmsAddress.set(s.substring(initI, i), null, 2);
                return MMSAddress.parseApplicationId(s, i, mmsAddress);
            }
            if (c != '.') {
                return false;
            }
            ++i;
        }
        return false;
    }

    static boolean parseIpv6(String s, int i, MMSAddress mmsAddress) {
        int len = s.length();
        if (i <= 0 || i >= len) {
            return false;
        }
        int initI = i;
        for (int num = 1; num < 9; ++num) {
            char c;
            int j;
            for (j = 0; j < 4 && i < len && MMSAddress.hex(c = s.charAt(i)); ++i, ++j) {
            }
            if (j == 0) {
                return false;
            }
            if (i == len) {
                if (num == 8) {
                    mmsAddress.set(s.substring(initI), null, 3);
                    return true;
                }
                return false;
            }
            c = s.charAt(i);
            if (c == ':') {
                if (num == 8) {
                    mmsAddress.set(s.substring(initI, i), null, 3);
                    return MMSAddress.parseApplicationId(s, i, mmsAddress);
                }
            } else {
                return false;
            }
            ++i;
        }
        return false;
    }

    static boolean parseShortCode(String s, int i, MMSAddress mmsAddress) {
        int len = s.length();
        if (i > len) {
            return false;
        }
        if (i == len) {
            return false;
        }
        int initI = i;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!MMSAddress.digit(c) && !MMSAddress.alpha(c)) {
                return false;
            }
            ++i;
        }
        mmsAddress.set(s.substring(initI), null, 4);
        return true;
    }

    static boolean parseApplicationId(String s, int i, MMSAddress mmsAddress) {
        int len = s.length();
        if (i <= 0 || i >= len || len - i > 33 || len - i < 2 || s.charAt(i) != ':') {
            return false;
        }
        int initI = ++i;
        int j = 0;
        while (i < len) {
            char c = s.charAt(i);
            j = 0;
            while (i < len && ((c = s.charAt(i)) == '_' || MMSAddress.digit(c) || MMSAddress.alpha(c))) {
                ++i;
                ++j;
            }
            if (i == len) {
                if (mmsAddress.type == -1) {
                    mmsAddress.set(null, s.substring(initI), 5);
                } else {
                    mmsAddress.setAppid(s.substring(initI));
                }
                return true;
            }
            if (j == 0 || c != '.') {
                return false;
            }
            ++i;
        }
        return false;
    }

    private static boolean specials(char c) {
        return c == '(' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"' || c == '.' || c == '[' || c == ']';
    }

    private static boolean isChar(char c) {
        return c >= '\u0000' && c <= '\u007f';
    }

    private static boolean asciiControl(char c) {
        return c >= '\u0000' && c <= '\u001f';
    }

    private static boolean atomChar(char c) {
        return c <= '\u007f' && c > ' ' && !MMSAddress.specials(c);
    }

    private static int linearWhiteSpaceSeq(String s, int i, int n) {
        while (i < n) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t') {
                if (c == '\r') {
                    if (i == n - 1 || s.charAt(i + 1) != '\n') {
                        return i;
                    }
                    ++i;
                } else {
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    static boolean parseEmail(String s, int i, MMSAddress mmsAddress) {
        int len = s.length();
        if (i <= 0 || i >= len) {
            return false;
        }
        int initI = i;
        if (s.charAt(len - 1) == ';') {
            if ((i = MMSAddress.isPhrase(s, i, len - 1)) <= 0) {
                return false;
            }
            if (i >= len - 1 || s.charAt(i) != ':') {
                return false;
            }
            if (++i == len - 1) {
                mmsAddress.set(s.substring(initI), null, 0);
                return true;
            }
            if ((i = MMSAddress.isMailbox(s, i, len - 1)) <= 0) {
                return false;
            }
            while (i < len - 1) {
                if (i >= len - 2 && s.charAt(i) != ',') {
                    return false;
                }
                if ((i = MMSAddress.isMailbox(s, i + 1, len - 1)) > 0) continue;
                return false;
            }
            if (i == len - 1) {
                mmsAddress.set(s.substring(initI), null, 0);
                return true;
            }
            return false;
        }
        if (MMSAddress.isMailbox(s, i, len) == len) {
            mmsAddress.set(s.substring(initI), null, 0);
            return true;
        }
        return false;
    }

    private static int isMailbox(String s, int i, int n) {
        if (n > s.length()) {
            n = s.length();
        }
        if (i >= n) {
            return -1;
        }
        int initI = i;
        if ((i = MMSAddress.isLocalAtDomain(s, initI, n)) > 0) {
            return i;
        }
        i = initI;
        if (s.charAt(i) != '<' && (i = MMSAddress.isPhrase(s, initI, n)) < 0) {
            return -1;
        }
        if (i == n || s.charAt(i) != '<') {
            return -1;
        }
        if (++i == n) {
            return -1;
        }
        boolean atLeastOneDomain = false;
        while (s.charAt(i) == '@') {
            atLeastOneDomain = true;
            if ((i = MMSAddress.isDomain(s, i + 1, n)) < 0) {
                return -1;
            }
            if (i == n) {
                return -1;
            }
            if (s.charAt(i) == ':') break;
            while (s.charAt(i) == ',') {
                if (++i != n && s.charAt(i) != ':') continue;
                return -1;
            }
        }
        if (atLeastOneDomain) {
            if (i == n || s.charAt(i) != ':') {
                return -1;
            }
            ++i;
        }
        if ((i = MMSAddress.isLocalAtDomain(s, i, n)) <= 0) {
            return -1;
        }
        if (i < n && s.charAt(i) == '>') {
            return i + 1;
        }
        return -1;
    }

    private static int isLocalPart(String s, int i, int n) {
        return MMSAddress.isSequenceOfAtomAndText(s, i, n, '\"', '\"', true);
    }

    private static int isPhrase(String s, int i, int n) {
        return MMSAddress.isSequenceOfAtomAndText(s, i, n, '\"', '\"', false);
    }

    private static int isDomain(String s, int i, int n) {
        return MMSAddress.isSequenceOfAtomAndText(s, i, n, '[', ']', true);
    }

    private static int isSequenceOfAtomAndText(String s, int i, int n, char begSep, char endSep, boolean dotSeparated) {
        if (i >= s.length()) {
            return -1;
        }
        if (n > s.length()) {
            n = s.length();
        }
        boolean withinQuotation = false;
        boolean atLeastOneWord = false;
        int initI = i;
        while (i < n) {
            char c = s.charAt(i);
            if (c == begSep) {
                if (begSep == endSep) {
                    withinQuotation = !withinQuotation;
                } else {
                    if (withinQuotation) {
                        return -1;
                    }
                    withinQuotation = true;
                }
                atLeastOneWord = true;
            } else if (c == endSep) {
                if (!withinQuotation) {
                    return -1;
                }
                withinQuotation = false;
            } else if (c == '\\') {
                if (!withinQuotation || i == n - 1) {
                    return -1;
                }
                if (!MMSAddress.alpha(c = s.charAt(++i))) {
                    return -1;
                }
            } else if (dotSeparated && c == '.') {
                if (i == initI || i - initI > 0 && s.charAt(i - 1) == '.') {
                    return -1;
                }
            } else if (withinQuotation) {
                if (c == ' ' || c == '\t' || c == '\r') {
                    if ((i = MMSAddress.linearWhiteSpaceSeq(s, i, n)) < 0) {
                        return -1;
                    }
                    --i;
                }
            } else {
                if (!MMSAddress.atomChar(c)) break;
                atLeastOneWord = true;
            }
            ++i;
        }
        if (withinQuotation || !atLeastOneWord || dotSeparated && i > initI && s.charAt(i - 1) == '.') {
            return -1;
        }
        return i;
    }

    private static int isLocalAtDomain(String s, int i, int n) {
        if (n > s.length()) {
            n = s.length();
        }
        if (i >= n) {
            return -1;
        }
        if ((i = MMSAddress.isLocalPart(s, i, n)) <= 0) {
            return -1;
        }
        if (i == n || s.charAt(i) != '@') {
            return -1;
        }
        return MMSAddress.isDomain(s, ++i, n);
    }

    public static MMSAddress getParsedMMSAddress(String addressStr) {
        return MMSAddress.getParsedMMSAddress(addressStr, null);
    }

    public static MMSAddress getParsedMMSAddress(String addressStr, MMSAddress mmsAddress) {
        if (addressStr == null || !addressStr.startsWith("mms://")) {
            return null;
        }
        if (mmsAddress == null) {
            mmsAddress = new MMSAddress();
        }
        if (MMSAddress.parsePhoneNumber(addressStr, 6, mmsAddress) || MMSAddress.parseIpv4(addressStr, 6, mmsAddress) || MMSAddress.parseIpv6(addressStr, 6, mmsAddress) || MMSAddress.parseEmail(addressStr, 6, mmsAddress) || MMSAddress.parseShortCode(addressStr, 6, mmsAddress) || MMSAddress.parseApplicationId(addressStr, 6, mmsAddress)) {
            return mmsAddress;
        }
        return null;
    }

    MMSAddress() {
        this.clear();
    }

    MMSAddress(String address, String appId, int type) {
        this.set(address, appId, type);
    }

    void clear() {
        this.appId = null;
        this.address = null;
        this.type = -1;
    }

    void set(String address, String appId, int type) {
        this.address = address;
        this.appId = appId;
        this.type = type;
    }

    void setAppid(String appId) {
        this.appId = appId;
    }

    String getMMSAddressString() {
        if (this.type == -1 || this.address == null && this.appId == null) {
            return null;
        }
        StringBuffer mmsAddr = new StringBuffer("mms://");
        if (this.address != null) {
            mmsAddr.append(this.address);
        }
        if (this.appId != null) {
            mmsAddr.append(":").append(this.appId);
        }
        return mmsAddr.toString();
    }
}

