/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.mms;

import com.sun.midp.io.j2me.mms.MultipartObject;
import com.sun.midp.io.j2me.mms.Protocol;
import com.sun.midp.io.j2me.sms.DatagramImpl;
import com.sun.midp.io.j2me.sms.DatagramRecord;
import com.sun.midp.io.j2me.sms.TextEncoder;
import com.sun.midp.io.j2me.sms.TransportMessage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import javax.microedition.io.Datagram;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;

public class DatagramImpl
extends com.sun.midp.io.j2me.sms.DatagramImpl {
    public long send(String type, String address, byte[] buffer, String senderAppID) throws IOException {
        int segments;
        DatagramRecord dr = new DatagramRecord();
        long sendtime = System.currentTimeMillis();
        int offset = 0;
        int headersize = 50;
        if (buffer == null) {
            buffer = new byte[]{};
        }
        this.fragmentsize = 1200;
        if (buffer.length < this.fragmentsize) {
            segments = 1;
        } else {
            this.fragmentsize -= headersize;
            segments = (buffer.length + this.fragmentsize - 1) / this.fragmentsize;
        }
        int length = buffer.length;
        for (int i = 0; i < segments; ++i) {
            dr.setHeader("Date", String.valueOf(sendtime));
            if (address != null) {
                dr.setHeader("Address", address);
            }
            if (senderAppID == null) {
                dr.setHeader("SenderAddress", "mms://" + this.phoneNumber);
            } else {
                dr.setHeader("SenderAddress", "mms://" + this.phoneNumber + ":" + senderAppID);
            }
            dr.setHeader("Content-Type", type);
            dr.setHeader("Content-Length", String.valueOf(buffer.length));
            dr.setHeader("Segments", String.valueOf(segments));
            if (segments > 1) {
                offset = i * this.fragmentsize;
                length = i < segments - 1 ? this.fragmentsize : buffer.length - this.fragmentsize * i;
                dr.setHeader("Fragment", String.valueOf(i));
                dr.setHeader("Fragment-Size", String.valueOf(length));
                dr.setHeader("Fragment-Offset", String.valueOf(offset));
            }
            byte[] buf = new byte[length];
            System.arraycopy(buffer, offset, buf, 0, length);
            dr.setData(buf);
            byte[] messdata = dr.getFormattedData();
            Datagram mess = this.dgc.newDatagram(messdata.length);
            mess.setAddress("datagram://" + this.dhost + ":" + this.dportout);
            mess.setData(messdata, 0, messdata.length);
            this.dgc.send(mess);
        }
        return sendtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportMessage receive(MessageConnection forThisConnection) throws IOException {
        String te;
        Datagram mess = null;
        DatagramRecord previous = null;
        DatagramRecord current = null;
        if (this.reader == null) {
            this.reader = new Thread(new SubclassedDatagramReader());
            this.reader.start();
        }
        while (true) {
            Vector vector = this.queue;
            synchronized (vector) {
                while (this.queue.size() == 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (((Protocol)forThisConnection).open) continue;
                    throw new InterruptedIOException("connection closed");
                }
                mess = (Datagram)this.queue.elementAt(0);
                this.queue.removeElementAt(0);
            }
            current = new DatagramRecord();
            boolean expectMore = current.parseData(mess.getData(), mess.getLength());
            String ackPortStr = current.getHeader("Ack-Port");
            String ackCookie = current.getHeader("Ack-Cookie");
            if (ackPortStr != null && ackCookie != null) {
                int ackPort = 0;
                try {
                    ackPort = Integer.parseInt(ackPortStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (ackPort != 0) {
                    String ackStr = "ACK:" + ackCookie + "\n";
                    byte[] ackBytes = ackStr.getBytes();
                    Datagram ack = this.dgc.newDatagram(ackBytes.length);
                    ack.setAddress("datagram://" + this.dhost + ":" + ackPort);
                    ack.setData(ackBytes, 0, ackBytes.length);
                    this.dgc.send(ack);
                }
            }
            if (!expectMore || current.addData(previous)) break;
            previous = current;
        }
        String addr = current.getHeader("CBSAddress");
        if (addr == null) {
            addr = current.getHeader("Address");
        }
        String senderAddr = current.getHeader("SenderAddress");
        long time = 0L;
        try {
            time = Long.parseLong(current.getHeader("Date"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String type = current.getHeader("Content-Type");
        byte[] buf = current.getData();
        if (type.equals("text") && (te = current.getHeader("Text-Encoding")) != null && te.equals("gsm7bit")) {
            buf = TextEncoder.decode(buf);
        }
        return new TransportMessage(addr, senderAddr, type, time, buf);
    }

    public int numberOfSegments(Message msg) {
        int segments;
        if (!(msg instanceof MultipartObject)) {
            return 0;
        }
        int headersize = 7;
        byte[] buf = null;
        try {
            buf = ((MultipartObject)msg).getAsByteArray();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (buf == null) {
            return 1;
        }
        this.fragmentsize = 1200;
        if (buf.length < this.fragmentsize) {
            segments = 1;
        } else {
            this.fragmentsize -= headersize;
            segments = (buf.length + this.fragmentsize - 1) / this.fragmentsize;
        }
        return segments;
    }

    public String getDeviceID() {
        return this.phoneNumber;
    }

    public class SubclassedDatagramReader
    extends DatagramImpl.DatagramReader {
    }
}

