/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.https;

import com.sun.midp.io.Properties;
import com.sun.midp.io.j2me.http.StreamConnectionElement;
import com.sun.midp.main.Configuration;
import com.sun.midp.publickeystore.WebPublicKeyStore;
import com.sun.midp.security.SecurityToken;
import com.sun.midp.ssl.SSLStreamConnection;
import com.sun.midp.ssl.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.io.StreamConnection;
import javax.microedition.pki.CertificateException;

public class Protocol
extends com.sun.midp.io.j2me.http.Protocol
implements HttpsConnection {
    private static final String COMMON_NAME_LABEL = "CN=";
    private static final int COMMON_NAME_LABEL_LENGTH = "CN=".length();
    private static SecurityToken classSecurityToken;
    private Properties proxyHeaders = new Properties();
    private SSLStreamConnection sslConnection;
    private boolean permissionChecked;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    private static String getCommonName(String name) {
        if (name == null) {
            return null;
        }
        int start = name.indexOf(COMMON_NAME_LABEL);
        if (start < 0) {
            return null;
        }
        int end = name.indexOf(59, start += COMMON_NAME_LABEL_LENGTH);
        if (end < 0) {
            end = name.length();
        }
        return name.substring(start, end);
    }

    private static boolean checkSiteName(String siteName, String certName) {
        if (certName == null) {
            return false;
        }
        if (siteName.length() == certName.length() && siteName.regionMatches(true, 0, certName, 0, certName.length())) {
            return true;
        }
        if (!certName.startsWith("*.")) {
            return false;
        }
        int startOfDomain = siteName.indexOf(46);
        if (startOfDomain == -1) {
            return false;
        }
        int domainLength = siteName.length() - ++startOfDomain;
        if (certName.length() - 2 != domainLength) {
            return false;
        }
        return siteName.regionMatches(true, startOfDomain, certName, 2, domainLength);
    }

    public Protocol() {
        this.protocol = "https";
        this.default_port = 443;
    }

    protected void checkForPermission(SecurityToken token, String name) throws InterruptedIOException {
        if (this.permissionChecked) {
            return;
        }
        this.checkForPermission(token, 4, name, "https");
        this.permissionChecked = true;
        super.checkForPermission(classSecurityToken, name);
    }

    public String getRequestProperty(String key) {
        if (key.startsWith("Proxy-")) {
            return this.proxyHeaders.getProperty(key);
        }
        return super.getRequestProperty(key);
    }

    protected void setRequestField(String key, String value) {
        if (key.startsWith("Proxy-")) {
            this.proxyHeaders.setProperty(key, value);
            return;
        }
        super.setRequestField(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamConnection connect() throws IOException {
        InputStream tcpInputStream;
        OutputStream tcpOutputStream;
        if (!this.permissionChecked) {
            throw new SecurityException("The permission check was bypassed");
        }
        WebPublicKeyStore.loadCertificateAuthorities();
        com.sun.midp.io.j2me.socket.Protocol tcpConnection = new com.sun.midp.io.j2me.socket.Protocol();
        String httpsTunnel = Configuration.getProperty("com.sun.midp.io.http.proxy");
        if (httpsTunnel != null) {
            tcpConnection.openPrim(classSecurityToken, "//" + httpsTunnel);
            tcpConnection.setSocketOption((byte)0, 0);
            tcpOutputStream = tcpConnection.openOutputStream();
            tcpInputStream = tcpConnection.openInputStream();
            try {
                this.doTunnelHandshake(tcpOutputStream, tcpInputStream);
            }
            catch (IOException ioe) {
                String temp = ioe.getMessage();
                tcpConnection.close();
                tcpOutputStream.close();
                tcpInputStream.close();
                if (temp.indexOf(" 500 ") > -1) {
                    throw new ConnectionNotFoundException(temp);
                }
                throw ioe;
            }
        } else {
            tcpConnection.openPrim(classSecurityToken, "//" + this.hostAndPort);
            tcpConnection.setSocketOption((byte)0, 0);
            tcpOutputStream = tcpConnection.openOutputStream();
            tcpInputStream = tcpConnection.openInputStream();
        }
        tcpConnection.close();
        try {
            this.sslConnection = new SSLStreamConnection(this.url.host, this.url.port, tcpInputStream, tcpOutputStream);
        }
        catch (Exception e) {
            try {
                tcpInputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                tcpOutputStream.close();
            }
            finally {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (RuntimeException)e;
            }
        }
        try {
            X509Certificate serverCert = this.sslConnection.getServerCertificate();
            if (serverCert.getSubjectAltNameType() == 2) {
                if (!Protocol.checkSiteName(this.url.host, (String)serverCert.getSubjectAltName())) {
                    throw new CertificateException("Subject alternative name did not match site name", serverCert, 7);
                }
            } else {
                String cname = Protocol.getCommonName(serverCert.getSubject());
                if (cname == null) {
                    throw new CertificateException("Common name missing from subject name", serverCert, 7);
                }
                if (!Protocol.checkSiteName(this.url.host, cname)) {
                    throw new CertificateException(serverCert, 7);
                }
            }
            return this.sslConnection;
        }
        catch (Exception e) {
            try {
                this.sslConnection.close();
            }
            finally {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (RuntimeException)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(StreamConnection connection, InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            try {
                inputStream.close();
            }
            finally {
                try {
                    outputStream.close();
                }
                finally {
                    connection.close();
                }
            }
        }
        catch (IOException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        this.ensureOpen();
        this.sendRequest();
        if (this.sslConnection == null) {
            StreamConnection sc = ((StreamConnectionElement)this.getStreamConnection()).getBaseConnection();
            return ((SSLStreamConnection)sc).getSecurityInfo();
        }
        return this.sslConnection.getSecurityInfo();
    }
}

