/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.http;

import com.sun.midp.io.j2me.http.StreamConnectionElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.StreamConnection;

class StreamConnectionPool {
    private long m_connectionLingerTime;
    private Vector m_connections;
    private int m_max_connections;

    StreamConnectionPool(int number_of_connections, long connectionLingerTime) {
        this.m_max_connections = number_of_connections;
        this.m_connectionLingerTime = connectionLingerTime;
        this.m_connections = new Vector(this.m_max_connections);
    }

    synchronized boolean add(String p_protocol, String p_host, int p_port, StreamConnection sc, DataOutputStream dos, DataInputStream dis) {
        StreamConnectionElement oldestNotInUse = null;
        Enumeration cons = this.m_connections.elements();
        while (cons.hasMoreElements()) {
            StreamConnectionElement sce = (StreamConnectionElement)cons.nextElement();
            if (sce.m_in_use) {
                if (!p_host.equals(sce.m_host) || p_port != sce.m_port) continue;
                return false;
            }
            if (p_host.equals(sce.m_host) && p_port == sce.m_port) {
                sce.close();
                this.m_connections.removeElement(sce);
                break;
            }
            if (oldestNotInUse != null && sce.m_time >= oldestNotInUse.m_time) continue;
            oldestNotInUse = sce;
        }
        if (this.m_connections.size() >= this.m_max_connections) {
            if (oldestNotInUse == null) {
                return false;
            }
            oldestNotInUse.close();
            this.m_connections.removeElement(oldestNotInUse);
        }
        this.m_connections.addElement(new StreamConnectionElement(p_protocol, p_host, p_port, sc, dos, dis));
        return true;
    }

    synchronized void remove(StreamConnectionElement sce) {
        sce.close();
        this.m_connections.removeElement(sce);
    }

    synchronized StreamConnectionElement get(String p_protocol, String p_host, int p_port) {
        StreamConnectionElement result = null;
        long c_time = System.currentTimeMillis();
        Enumeration cons = this.m_connections.elements();
        while (cons.hasMoreElements()) {
            StreamConnectionElement sce = (StreamConnectionElement)cons.nextElement();
            if (c_time - sce.m_time > this.m_connectionLingerTime) {
                if (!sce.m_in_use) {
                    sce.close();
                } else {
                    sce.m_removed = true;
                }
                this.m_connections.removeElement(sce);
                continue;
            }
            if (!p_host.equals(sce.m_host) || p_port != sce.m_port || !p_protocol.equals(sce.m_protocol) || sce.m_in_use) continue;
            result = sce;
        }
        if (result != null) {
            result.m_in_use = true;
        }
        return result;
    }

    synchronized void returnForReuse(StreamConnectionElement returned) {
        returned.m_in_use = false;
        if (returned.m_removed) {
            returned.close();
            return;
        }
        returned.m_time = System.currentTimeMillis();
    }
}

