/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.file;

import java.io.UnsupportedEncodingException;

class EscapedUtil {
    EscapedUtil() {
    }

    public static String getEscapedString(String name) {
        try {
            if (name == null) {
                return null;
            }
            byte[] newName = new byte[name.length() * 12];
            int nextPlace = 0;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (EscapedUtil.containsReserved(c)) {
                    char[] data = new char[]{c};
                    byte[] reservedBytes = new String(data).getBytes("utf-8");
                    for (int j = 0; j < reservedBytes.length; ++j) {
                        newName[nextPlace++] = 37;
                        byte upper = (byte)(reservedBytes[j] >> 4 & 0xF);
                        newName[nextPlace++] = upper <= 9 ? (byte)(48 + upper) : (byte)(65 + (upper - 10));
                        byte lower = (byte)(reservedBytes[j] & 0xF);
                        newName[nextPlace++] = lower <= 9 ? (byte)(48 + lower) : (byte)(65 + (lower - 10));
                    }
                    continue;
                }
                newName[nextPlace++] = (byte)c;
            }
            return new String(newName, 0, nextPlace);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUnescapedString(String name) {
        try {
            if (name == null) {
                return null;
            }
            if (name.indexOf("%") == -1) {
                return name;
            }
            byte[] newName = new byte[name.length()];
            int nextPlace = 0;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '%') {
                    String hexNum = name.substring(i + 1, i + 3).toUpperCase();
                    if (!EscapedUtil.isHexCharsLegal(hexNum)) throw new IllegalArgumentException("Bad format");
                    c = EscapedUtil.hexToChar(hexNum);
                    i += 2;
                } else if (EscapedUtil.containsReserved(c)) {
                    throw new IllegalArgumentException("Bad escaped format");
                }
                newName[nextPlace++] = (byte)c;
            }
            return new String(newName, 0, nextPlace, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee.getMessage());
        }
    }

    private static boolean isHexCharsLegal(String hexValue) {
        return !(!EscapedUtil.isDigit(hexValue.charAt(0)) && !EscapedUtil.isABCDEF(hexValue.charAt(0)) || !EscapedUtil.isDigit(hexValue.charAt(1)) && !EscapedUtil.isABCDEF(hexValue.charAt(1)));
    }

    private static char hexToChar(String hexValue) {
        char c = '\u0000';
        c = EscapedUtil.isDigit(hexValue.charAt(0)) ? (char)((char)(c + (hexValue.charAt(0) - 48) * 16)) : (char)((char)(c + (hexValue.charAt(0) - 65 + 10) * 16));
        c = EscapedUtil.isDigit(hexValue.charAt(1)) ? (char)((char)(c + (hexValue.charAt(1) - 48))) : (char)((char)(c + (hexValue.charAt(1) - 65 + 10)));
        return c;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isABCDEF(char c) {
        return c >= 'A' && c <= 'F';
    }

    private static boolean containsReserved(char c) {
        return !(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "/:-_.!~*'()".indexOf(c) != -1);
    }
}

